/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.utils.AnimateResourceLoader;

public class ComboPointView
extends View {
    private static final float[] SCALE_FACTOR_TWO = new float[]{0.91f, 1.0f, 1.1f};
    private static final float[] SCALE_FACTOR_FOUR = new float[]{0.68f, 0.75f, 0.83f, 0.91f, 1.0f};
    private int width;
    private int height;
    private int mCurrentPoint;
    private int[] mPointArray;
    private int[] mNumWidth;
    private int[] mNumHeight;
    private int[] bitmapSize = new int[2];
    private Rect mRect = new Rect();

    public ComboPointView(Context context) {
        super(context);
    }

    public ComboPointView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public int getCurrentPoint() {
        return this.mCurrentPoint;
    }

    public int getComboWidth() {
        return this.width;
    }

    public int getComboHeight() {
        return this.height;
    }

    public void setCombPoint(int point) {
        int lastBits = this.getPointBits(this.mCurrentPoint);
        int lastWidth = this.width;
        this.mCurrentPoint = point;
        this.width = 0;
        this.height = 0;
        int bits = this.getPointBits(point);
        if (bits <= 0) {
            return;
        }
        this.mPointArray = new int[bits + 1];
        this.mNumWidth = new int[bits + 1];
        this.mNumHeight = new int[bits + 1];
        if (point < 100) {
            this.createNumberArray(point, SCALE_FACTOR_TWO);
        } else {
            this.createNumberArray(point, SCALE_FACTOR_FOUR);
        }
        if (lastBits > 0 && lastBits == bits) {
            this.width = Math.max(this.width, lastWidth);
        }
        ViewGroup.LayoutParams comboParams = this.getLayoutParams();
        comboParams.width = this.width;
        comboParams.height = this.height;
        this.setLayoutParams(comboParams);
        this.invalidate();
    }

    private void createNumberArray(int point, float[] scaleFactors) {
        this.width = 0;
        this.height = 0;
        this.mPointArray[0] = -1;
        this.calculateViewSize(0, scaleFactors[0]);
        for (int len = this.mPointArray.length - 1; point > 0 && len > 0; --len) {
            int num = point % 10;
            point /= 10;
            this.mPointArray[len] = num;
            int index = len;
            if (index >= scaleFactors.length) {
                index = scaleFactors.length - 1;
            }
            this.calculateViewSize(len, scaleFactors[index]);
        }
    }

    private void calculateViewSize(int index, float scaleFactor) {
        int[] size = this.getNumberSize(this.mPointArray[index]);
        int scaleWidth = (int)((float)size[0] * scaleFactor);
        int scaleHeight = (int)((float)size[1] * scaleFactor);
        this.mNumWidth[index] = scaleWidth;
        this.mNumHeight[index] = scaleHeight;
        this.width += scaleWidth;
        if (scaleHeight > this.height) {
            this.height = scaleHeight;
        }
    }

    private int getPointBits(int point) {
        int count = 0;
        while (point > 0) {
            ++count;
            point /= 10;
        }
        return count;
    }

    private int[] getNumberSize(int number) {
        int[] size = AnimateResourceLoader.getInstance().getNumberBitmapSize(number);
        this.bitmapSize[0] = size[0];
        this.bitmapSize[1] = size[1];
        return this.bitmapSize;
    }

    private Bitmap getNumberBitmap(int number) {
        return AnimateResourceLoader.getInstance().loadNumberBitmap(number);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.width, this.height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPointArray == null) {
            return;
        }
        int left = 0;
        float[] scaleFactors = this.mPointArray.length <= 3 ? SCALE_FACTOR_TWO : SCALE_FACTOR_FOUR;
        int index = 0;
        for (int i = 0; i < this.mPointArray.length; ++i) {
            int num = this.mPointArray[i];
            Bitmap bitmap = this.getNumberBitmap(num);
            this.mRect.set(left, this.height - this.mNumHeight[i], left + this.mNumWidth[i], this.height);
            canvas.drawBitmap(bitmap, null, this.mRect, null);
            if (index + 1 < scaleFactors.length) {
                ++index;
            }
            left += this.mNumWidth[i];
        }
    }
}

