/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.executor;

import android.os.Process;
import android.util.Log;
import com.yy.mobile.perf.executor.Prioritized;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FifoPriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    static final int THREAD_PRIORITY_LOW = 14;
    static final int THREAD_PRIORITY_BACKGROUND = 10;
    static final int THREAD_WORK_PRIORITY = 5;
    static final int THREAD_PRIORITY_NORMAL = 5;
    static final int THREAD_PRIORITY_HIGH = 0;
    private static final String TAG = "PerfSDKFThreadPool";
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;

    public FifoPriorityThreadPoolExecutor(int poolSize) {
        this(poolSize, UncaughtThrowableStrategy.LOG);
    }

    public FifoPriorityThreadPoolExecutor(int poolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new DefaultThreadFactory(), uncaughtThrowableStrategy);
    }

    public FifoPriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(corePoolSize, maximumPoolSize, keepAlive, timeUnit, new PriorityBlockingQueue<Runnable>(), threadFactory);
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new LoadTask<T>(runnable, value, this.ordering.getAndIncrement());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
            catch (ExecutionException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
        }
    }

    static class LoadTask<T>
    extends FutureTask<T>
    implements Prioritized,
    Comparable<Prioritized> {
        private final int priority;
        private final int order;

        public LoadTask(Runnable runnable, T result, int order) {
            super(runnable, result);
            this.priority = runnable instanceof Prioritized ? ((Prioritized)((Object)runnable)).getPriority() : 10;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o instanceof LoadTask) {
                LoadTask other = (LoadTask)o;
                return this.order == other.order && this.priority == other.priority;
            }
            return false;
        }

        public int hashCode() {
            int result = this.priority;
            result = 31 * result + this.order;
            return result;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            int result = loadTask.getPriority() - this.priority;
            if (result == 0 && loadTask instanceof LoadTask) {
                result = this.order - ((LoadTask)loadTask).order;
            }
            return result;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        int threadNum = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable, "YY_PerfSDK-thread-" + this.threadNum){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    super.run();
                }
            };
            ++this.threadNum;
            return result;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                Log.e((String)"SDKThreadPoolExecutor", (String)"Request threw uncaught throwable", (Throwable)t);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }
}

