/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.mobile.perf.NetworkState;
import com.yy.mobile.perf.collect.Collecter;
import com.yy.mobile.perf.log.ILog;
import com.yy.mobile.perf.log.Log;
import com.yy.mobile.perf.loggable.LogReporter;
import com.yy.mobile.perf.loggable.model.CommonLogData;
import com.yy.mobile.perf.loggable.model.LogData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PerfSDK {
    private static final String TAG = "PerfSDK";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final AtomicBoolean sInited = new AtomicBoolean(false);
    private static final PerfSDK sApi = new PerfSDK();
    private static Application sApplication;
    private static String sAppId;
    private static String sVersion;
    private int[] scodeArray;
    private static AtomicInteger idGenerator;
    private HandlerThread handlerThread;
    private Handler handler;
    private Map<String, TaskInfo> taskMap = new ConcurrentHashMap<String, TaskInfo>();
    private LogReporter logReporter;
    private Map<String, String> debugMap = new ConcurrentHashMap<String, String>();
    private static final Object LOCK;
    private NetworkState.Callback networkChangedCallback = new NetworkState.Callback(){

        @Override
        public void notifyChanged(String networkType) {
            PerfSDK.this.handler.removeCallbacksAndMessages(null);
        }
    };
    private static volatile Collecter sCollecter;

    private PerfSDK() {
    }

    public void init(Application application, String appId, String appVersion) {
        this.init(application, appId, appVersion, null);
    }

    public void init(Application application, String appId, String appVersion, ILog log) {
        if (sInited.getAndSet(true)) {
            return;
        }
        sApplication = application;
        sAppId = appId;
        sVersion = appVersion;
        Log.setLog(log);
        Log.i(TAG, "Performance report SDK init", new Object[0]);
        this.handlerThread = new HandlerThread("YYPerfSDK-report-thread", 10);
        this.handlerThread.start();
        this.handler = new TimeoutHandler(this.handlerThread.getLooper());
        NetworkState.registerNetworkChangeBroadcastReceiver((Context)application, this.networkChangedCallback);
    }

    public void destroy() {
        NetworkState.unregisterNetworkChangeBroadcastReceiver((Context)sApplication, this.networkChangedCallback);
        this.handlerThread.quit();
        this.debugMap.clear();
        this.taskMap.clear();
    }

    public static PerfSDK instance() {
        return sApi;
    }

    public int start(int scode, String taskName) {
        return this.start(scode, taskName, 60000);
    }

    public int start(int scode, String taskName, int timeoutMillis) {
        return this.startInternal(scode, taskName, timeoutMillis);
    }

    public void end(int scode, String taskName) {
        this.end(scode, taskName, "0");
    }

    public void end(final int scode, final String taskName, final String respCode) {
        final long endSysTime = System.currentTimeMillis();
        final long endThreadTime = SystemClock.currentThreadTimeMillis();
        final String endThreadInfo = Thread.currentThread().toString();
        Log.d(TAG, "end [%s]", taskName);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TaskInfo info = (TaskInfo)PerfSDK.this.taskMap.get(taskName);
                if (info == null) {
                    Log.w(PerfSDK.TAG, "task %s never started.", taskName);
                } else {
                    PerfSDK.this.handler.removeMessages(info.id);
                    PerfSDK.this.taskMap.remove(info.taskName);
                    info.endSysTime = endSysTime;
                    info.endThreadTime = endThreadTime;
                    info.scode = scode;
                    info.respCode = respCode;
                    info.endThreadInfo = endThreadInfo;
                    PerfSDK.this.report(info);
                }
            }
        });
    }

    public void end(int scode, int id) {
        this.end(scode, id, "0");
    }

    public void end(final int scode, final int id, final String respCode) {
        final long endSysTime = System.currentTimeMillis();
        final long endThreadTime = SystemClock.currentThreadTimeMillis();
        final String endThreadInfo = Thread.currentThread().toString();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (TaskInfo info : PerfSDK.this.taskMap.values()) {
                    if (info.id != id) continue;
                    PerfSDK.this.handler.removeMessages(info.id);
                    info.scode = scode;
                    info.endSysTime = endSysTime;
                    info.endThreadTime = endThreadTime;
                    info.respCode = respCode;
                    info.endThreadInfo = endThreadInfo;
                    PerfSDK.this.report(info);
                    return;
                }
                Log.w(PerfSDK.TAG, "not found taskId=%d, maybe had ended or timed out", id);
            }
        });
    }

    public void end(int scode, String taskName, long costTime) {
        this.end(scode, taskName, "0", costTime);
    }

    public void end(int scode, String taskName, String respCode, long costTime) {
        final TaskInfo info = new TaskInfo();
        info.id = PerfSDK.generateId();
        info.taskName = taskName;
        info.scode = scode;
        info.endSysTime = System.currentTimeMillis();
        info.startSysTime = info.endSysTime - costTime;
        info.respCode = respCode;
        info.endThreadInfo = Thread.currentThread().toString();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                PerfSDK.this.report(info);
            }
        });
    }

    private boolean checkTaskName(String taskName) {
        if (this.debugMap.containsKey(taskName)) {
            Log.d(TAG, "******repeat*******" + taskName, new Object[0]);
            return false;
        }
        this.debugMap.put(taskName, taskName);
        return true;
    }

    private int startInternal(int scode, final String taskName, final int timeoutMillis) {
        this.checkTaskName(taskName);
        final TaskInfo info = new TaskInfo();
        info.startThreadTime = SystemClock.currentThreadTimeMillis();
        info.startSysTime = System.currentTimeMillis();
        info.scode = scode;
        info.id = PerfSDK.generateId();
        info.taskName = taskName;
        info.startThreadInfo = Thread.currentThread().toString();
        info.timeoutMillis = timeoutMillis;
        TaskInfo cacheInfo = this.taskMap.get(taskName);
        if (cacheInfo != null) {
            Log.w(TAG, String.format("start [%s] again.", taskName), new Object[0]);
            this.handler.removeMessages(cacheInfo.id);
        }
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    PerfSDK.this.taskMap.put(taskName, info);
                    Message message = PerfSDK.this.handler.obtainMessage(info.id, (Object)info);
                    PerfSDK.this.handler.sendMessageDelayed(message, (long)timeoutMillis);
                }
            }
        });
        return info.id;
    }

    private void report(TaskInfo taskInfo) {
        Log.d(TAG, "report [%s:%s:ms]", taskInfo.taskName, taskInfo.endSysTime - taskInfo.startSysTime);
        HiidoSDK.instance().reportReturnCode(taskInfo.scode, taskInfo.taskName, taskInfo.endSysTime - taskInfo.startSysTime, taskInfo.respCode);
        if (taskInfo.endSysTime - taskInfo.startSysTime > 60000L) {
            Log.e(TAG, String.format("this task:%s cost more than 60s!!!!", taskInfo.taskName), new Object[0]);
        }
    }

    public void reportBucket() {
    }

    private static int generateId() {
        return idGenerator.getAndIncrement();
    }

    Application getApplication() {
        return sApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collecter getCollecter() {
        if (!sInited.get()) {
            throw new RuntimeException("PerfSdk must init first!");
        }
        if (sCollecter != null) return sCollecter;
        Class<Collecter> clazz = Collecter.class;
        synchronized (Collecter.class) {
            if (sCollecter != null) return sCollecter;
            sCollecter = new Collecter(sApplication, sAppId, sVersion);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCollecter;
        }
    }

    public void reportLog(LogData logData) {
        if (this.logReporter == null) {
            this.logReporter = new LogReporter();
        }
        this.logReporter.send(logData);
    }

    public void reportCommonLog(CommonLogData commonLogData, LogReporter.Callback callback) {
        if (this.logReporter == null) {
            this.logReporter = new LogReporter();
        }
        this.logReporter.sendCommonLog(commonLogData, callback);
    }

    static {
        idGenerator = new AtomicInteger();
        LOCK = new Object();
    }

    private static class TaskInfo {
        int scode;
        String respCode = "0";
        String taskName;
        String startThreadInfo;
        String endThreadInfo;
        int id;
        long startThreadTime;
        long startSysTime;
        long endSysTime;
        long endThreadTime;
        int timeoutMillis;

        private TaskInfo() {
        }

        public String toString() {
            return "TaskInfo{taskName='" + this.taskName + '\'' + ", threadTimeCost=" + (this.endThreadTime - this.startThreadTime) + ", sysTimeCost=" + (this.endSysTime - this.startSysTime) + ", startThreadInfo=" + this.startThreadInfo + ", endThreadInfo=" + this.endThreadInfo + ", respCode='" + this.respCode + '\'' + ", id=" + this.id + ", scode=" + this.scode + ", timeoutMillis=" + this.timeoutMillis + '}';
        }
    }

    private class TimeoutHandler
    extends Handler {
        TimeoutHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            int taskId = msg.what;
            TaskInfo taskInfo = (TaskInfo)msg.obj;
            if (taskInfo != null) {
                PerfSDK.this.taskMap.remove(taskInfo.taskName);
                Log.w(PerfSDK.TAG, "task %s (id:%d) %d millis timeout", taskInfo.taskName, taskId, taskInfo.timeoutMillis);
            } else {
                Log.d(PerfSDK.TAG, "handle timeout task, not found, null", new Object[0]);
            }
        }
    }
}

