/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.loggable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.yy.mobile.perf.executor.PerfTaskExecutor;
import com.yy.mobile.perf.log.Log;
import com.yy.mobile.perf.loggable.model.CommonLogData;
import com.yy.mobile.perf.loggable.model.LogData;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class LogReporter {
    private static final String TAG = "LogReporter";
    public static final String QOS_ERR_LOG_SERVER_URL = "http://log.sysop.duowan.com";
    public static final String COMMON_LOG_SERVER_URL = "http://log.sysop.duowan.com/normal/index.php";

    public void send(LogData logData) {
        Gson gson = new Gson();
        final String logJson = gson.toJson((Object)logData);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String result = LogReporter.postByUrlConn(LogReporter.QOS_ERR_LOG_SERVER_URL, "data=" + logJson, null);
                    Log.i(LogReporter.TAG, "Log post result:%s", result);
                }
                catch (IOException e) {
                    Log.e(LogReporter.TAG, e, "Log post error:%s", e.getMessage());
                }
            }
        };
        PerfTaskExecutor.instance().execute(runnable, 0L);
    }

    public void sendCommonLog(CommonLogData commonLogData, final Callback callback) {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<CommonLogData.InfoMap<String, String>>(){}.getType(), (Object)new CommonLogData.InfoMapTypeAdapter()).create();
        final String logJson = gson.toJson((Object)commonLogData);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String result = LogReporter.postByUrlConn(LogReporter.COMMON_LOG_SERVER_URL, "data=" + logJson, callback);
                    Log.i(LogReporter.TAG, "CommonLog post result:%s", result);
                }
                catch (IOException e) {
                    Log.e(LogReporter.TAG, e, "CommonLog post error:%s", e.getMessage());
                }
            }
        };
        PerfTaskExecutor.instance().execute(runnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postByUrlConn(String urlAddr, String content, Callback callback) throws IOException {
        HttpURLConnection urlConn = null;
        DeflaterOutputStream dos = null;
        InputStream is = null;
        String respMsg = null;
        URL url = null;
        try {
            url = new URL(urlAddr);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(30000);
            urlConn.setReadTimeout(60000);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestProperty("Accept-Charset", "text/html;charset=UTF-8");
            urlConn.setRequestProperty("Content-Type", "text/plain");
            urlConn.setRequestProperty("Content-Encoding", "gzip");
            urlConn.connect();
            dos = new GZIPOutputStream(new DataOutputStream(urlConn.getOutputStream()));
            dos.write(content.getBytes("UTF-8"));
            dos.flush();
            dos.close();
            respMsg = urlConn.getResponseMessage();
            if (urlConn.getResponseCode() == 200) {
                Log.d(TAG, "post url=[%s] is ok", url);
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                bao.close();
                if (callback != null) {
                    callback.onSuccess();
                }
            } else {
                if (callback != null) {
                    callback.onError(new Exception(String.valueOf(urlConn.getResponseCode())));
                }
                Log.w(TAG, "http post [%s] error! status:%d", url, urlConn.getResponseCode());
            }
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(e);
            }
            Log.e(TAG, "http post [%s] error: %s", url, e.getMessage());
        }
        finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
                if (dos != null) {
                    dos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return respMsg;
    }

    public static interface Callback {
        public void onError(Exception var1);

        public void onSuccess();
    }
}

