/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import android.net.TrafficStats;
import android.os.Process;
import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.collect.controllers.AbstractMonitorTask;
import com.yy.mobile.perf.collect.controllers.AbstractPerfController;
import com.yy.mobile.perf.executor.IQueueTaskExecutor;
import com.yy.mobile.perf.executor.PerfTaskExecutor;
import com.yy.mobile.perf.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

class FlowController
extends AbstractPerfController {
    public FlowController(AbstractPerfController.ICollectListener monitorListener) {
        super("flow", monitorListener);
    }

    @Override
    public AbstractMonitorTask createMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
        return new FlowMonitorTask(bussiness, perfMonitorConfig);
    }

    private static class FlowMonitorTask
    extends AbstractMonitorTask {
        private volatile IQueueTaskExecutor mQueueTaskExecutor;
        private volatile FlowInfo mStartFlowInfo;

        public FlowMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
            super(bussiness, perfMonitorConfig);
        }

        private IQueueTaskExecutor getQueueTaskExecutor() {
            if (this.mQueueTaskExecutor == null) {
                this.mQueueTaskExecutor = PerfTaskExecutor.instance().createAQueueExcuter();
            }
            return this.mQueueTaskExecutor;
        }

        @Override
        public void start() {
            this.mCancled = false;
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    FlowMonitorTask.this.mStartFlowInfo = FlowMonitorTask.this.getFlowInfo();
                }
            }, 0L);
        }

        @Override
        public void end() {
            if (this.mCancled) {
                return;
            }
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    if (FlowMonitorTask.this.mCancled) {
                        return;
                    }
                    HashMap<String, String> result = null;
                    if (FlowMonitorTask.this.mStartFlowInfo != null) {
                        FlowInfo endFlowInfo = FlowMonitorTask.this.getFlowInfo();
                        long totalAdd = endFlowInfo.rxBytes + endFlowInfo.txBytes - (((FlowMonitorTask)FlowMonitorTask.this).mStartFlowInfo.txBytes + ((FlowMonitorTask)FlowMonitorTask.this).mStartFlowInfo.rxBytes);
                        long txAdd = endFlowInfo.txBytes - ((FlowMonitorTask)FlowMonitorTask.this).mStartFlowInfo.txBytes;
                        long rxAdd = endFlowInfo.rxBytes - ((FlowMonitorTask)FlowMonitorTask.this).mStartFlowInfo.rxBytes;
                        if (totalAdd >= 0L) {
                            result = new HashMap<String, String>(5);
                            result.put("tlbytes", String.valueOf(totalAdd));
                            result.put("rxbytes", String.valueOf(rxAdd));
                            result.put("txbytes", String.valueOf(txAdd));
                        }
                    }
                    if (FlowMonitorTask.this.mListener != null && !FlowMonitorTask.this.mCancled) {
                        FlowMonitorTask.this.mListener.onTaskEnded(FlowMonitorTask.this.mBussiness, FlowMonitorTask.this.mPerfMonitorConfig, result);
                    }
                }
            }, 0L);
        }

        @Override
        public void watch() {
            if (this.mWatchListener != null) {
                this.mWatchListener.onWatchEnded(this.mBussiness, this.mPerfMonitorConfig, null);
            }
        }

        public FlowInfo getFlowInfo() {
            FlowInfo info = new FlowInfo();
            int uid = Process.myUid();
            info.txBytes = TrafficStats.getUidTxBytes((int)uid);
            info.rxBytes = TrafficStats.getUidRxBytes((int)uid);
            if (info.rxBytes < 0L) {
                info = this.getFlowInfoByReadFile(uid);
            }
            if (Utils.isApkDebugable()) {
                Log.d("FlowController", "txBytes:" + info.txBytes + " rxBytes:" + info.rxBytes, new Object[0]);
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FlowInfo getFlowInfoByReadFile(int localUid) {
            FlowInfo info = new FlowInfo();
            File dir = new File("/proc/uid_stat/");
            String[] children = dir.list();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < children.length; ++i) {
                stringBuffer.append(children[i]);
                stringBuffer.append("   ");
            }
            if (!Arrays.asList(children).contains(String.valueOf(localUid))) {
                return info;
            }
            File uidFileDir = new File("/proc/uid_stat/" + String.valueOf(localUid));
            File uidActualFileReceived = new File(uidFileDir, "tcp_rcv");
            File uidActualFileSent = new File(uidFileDir, "tcp_snd");
            String textReceived = "0";
            String textSent = "0";
            BufferedReader brReceived = null;
            BufferedReader brSent = null;
            try {
                String sentLine;
                brReceived = new BufferedReader(new FileReader(uidActualFileReceived));
                brSent = new BufferedReader(new FileReader(uidActualFileSent));
                String receivedLine = brReceived.readLine();
                if (receivedLine != null) {
                    textReceived = receivedLine;
                }
                if ((sentLine = brSent.readLine()) != null) {
                    textSent = sentLine;
                }
            }
            catch (IOException e) {
                Log.d("FlowController", e, "", new Object[0]);
            }
            finally {
                try {
                    brReceived.close();
                }
                catch (IOException e) {}
                try {
                    brSent.close();
                }
                catch (IOException e) {}
            }
            try {
                info.rxBytes = Long.valueOf(textReceived) / 1024L;
                info.txBytes = Long.valueOf(textSent) / 1024L;
            }
            catch (Throwable e) {
                Log.d("FlowController", e, "data error textReceived:" + textReceived, new Object[0]);
            }
            return info;
        }

        private static class FlowInfo {
            long txBytes;
            long rxBytes;

            private FlowInfo() {
            }
        }
    }
}

