/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.collect.controllers.AbstractMonitorTask;
import com.yy.mobile.perf.collect.controllers.AbstractPerfController;
import com.yy.mobile.perf.executor.IQueueTaskExecutor;
import com.yy.mobile.perf.executor.PerfTaskExecutor;
import com.yy.mobile.perf.log.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

class ThreadsController
extends AbstractPerfController {
    private static final String TAG = "ThreadsController";

    public ThreadsController(AbstractPerfController.ICollectListener monitorListener) {
        super("threads", monitorListener);
    }

    @Override
    public AbstractMonitorTask createMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
        return new ThreadsMonitorTask(bussiness, perfMonitorConfig);
    }

    private static class ThreadsMonitorTask
    extends AbstractMonitorTask {
        private static final int THREADS_EXCEED_VALUE = 300;
        private volatile IQueueTaskExecutor mQueueTaskExecutor;
        private volatile ThreadInfo mStartThreadInfo;
        private PerfTaskExecutor.RunnableEx mWatchOverFlow = new PerfTaskExecutor.RunnableEx(){

            @Override
            public void run() {
                if (!ThreadsMonitorTask.this.mCancled && !ThreadsMonitorTask.this.watchOverflowInner()) {
                    ThreadsMonitorTask.this.getQueueTaskExecutor().execute(ThreadsMonitorTask.this.mWatchOverFlow, 20000L);
                }
            }
        };

        public ThreadsMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
            super(bussiness, perfMonitorConfig);
        }

        private IQueueTaskExecutor getQueueTaskExecutor() {
            if (this.mQueueTaskExecutor == null) {
                this.mQueueTaskExecutor = PerfTaskExecutor.instance().createAQueueExcuter();
            }
            return this.mQueueTaskExecutor;
        }

        @Override
        public void start() {
            this.mCancled = false;
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    ThreadsMonitorTask.this.mStartThreadInfo = ThreadsMonitorTask.getThreadInfo();
                }
            }, 0L);
        }

        @Override
        public void end() {
            if (this.mCancled) {
                return;
            }
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    if (ThreadsMonitorTask.this.mCancled) {
                        return;
                    }
                    ThreadInfo endThreadInfo = ThreadsMonitorTask.getThreadInfo();
                    HashMap<String, String> result = null;
                    if (endThreadInfo != null) {
                        result = new HashMap<String, String>();
                        result.put("num", String.valueOf(endThreadInfo.totalNum));
                        result.put("dnum", String.valueOf(endThreadInfo.dalvikNum));
                        result.put("nnum", String.valueOf(endThreadInfo.nativeNum));
                        if (ThreadsMonitorTask.this.mStartThreadInfo != null) {
                            result.put("numa", String.valueOf(endThreadInfo.totalNum - ((ThreadsMonitorTask)ThreadsMonitorTask.this).mStartThreadInfo.totalNum));
                            result.put("dnuma", String.valueOf(endThreadInfo.dalvikNum - ((ThreadsMonitorTask)ThreadsMonitorTask.this).mStartThreadInfo.dalvikNum));
                            result.put("nnuma", String.valueOf(endThreadInfo.nativeNum - ((ThreadsMonitorTask)ThreadsMonitorTask.this).mStartThreadInfo.nativeNum));
                        }
                    }
                    if (ThreadsMonitorTask.this.mListener != null && !ThreadsMonitorTask.this.mCancled) {
                        ThreadsMonitorTask.this.mListener.onTaskEnded(ThreadsMonitorTask.this.mBussiness, ThreadsMonitorTask.this.mPerfMonitorConfig, result);
                    }
                }
            }, 0L);
        }

        @Override
        public void watch() {
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    ThreadInfo endThreadInfo = ThreadsMonitorTask.getThreadInfo();
                    if (endThreadInfo == null) {
                        if (ThreadsMonitorTask.this.mWatchListener != null) {
                            ThreadsMonitorTask.this.mWatchListener.onWatchEnded(ThreadsMonitorTask.this.mBussiness, ThreadsMonitorTask.this.mPerfMonitorConfig, null);
                        }
                    } else {
                        HashMap<String, String> result = new HashMap<String, String>(5);
                        result.put("num", String.valueOf(endThreadInfo.totalNum));
                        result.put("dnum", String.valueOf(endThreadInfo.dalvikNum));
                        result.put("nnum", String.valueOf(endThreadInfo.nativeNum));
                        if (ThreadsMonitorTask.this.mWatchListener != null) {
                            ThreadsMonitorTask.this.mWatchListener.onWatchEnded(ThreadsMonitorTask.this.mBussiness, ThreadsMonitorTask.this.mPerfMonitorConfig, result);
                        }
                    }
                }
            }, 0L);
        }

        @Override
        public void cancle() {
            this.getQueueTaskExecutor().removeTask(this.mWatchOverFlow);
            super.cancle();
        }

        @Override
        public void watchOverFlow() {
            super.watchOverFlow();
            this.getQueueTaskExecutor().removeTask(this.mWatchOverFlow);
            this.getQueueTaskExecutor().execute(this.mWatchOverFlow, 0L);
        }

        public boolean watchOverflowInner() {
            if (this.mWatchOverFlowListener == null) {
                return false;
            }
            ThreadInfo info = ThreadsMonitorTask.getThreadInfo();
            if (info != null) {
                HashMap<String, String> result = null;
                int overFlowValue = 0;
                if (this.mPerfMonitorConfig != null) {
                    overFlowValue = Utils.strToInt((String)this.mPerfMonitorConfig.get("overflownum"));
                }
                if (overFlowValue <= 0) {
                    overFlowValue = 300;
                }
                if (info.totalNum > overFlowValue) {
                    result = new HashMap<String, String>();
                    result.put("num", String.valueOf(info.totalNum));
                    result.put("dnum", String.valueOf(info.dalvikNum));
                    result.put("nnum", String.valueOf(info.nativeNum));
                    result.put("otdi", ThreadsMonitorTask.getThreadsDetailInfoStr(ThreadsMonitorTask.getThreadsDetailInfo()));
                    if (this.mWatchOverFlowListener != null) {
                        this.mWatchOverFlowListener.onWatchOverFlowEnded(this.mBussiness, this.mPerfMonitorConfig, result);
                    }
                    if (Utils.isApkDebugable()) {
                        Log.d(ThreadsController.TAG, "overflow : " + result.toString(), new Object[0]);
                    }
                    return true;
                }
            }
            return false;
        }

        private static File getTasksParent() {
            String path = "/proc/" + PerfTaskExecutor.getPid() + "/task";
            File file = new File(path);
            if (file.exists() && file.canRead()) {
                return file;
            }
            return null;
        }

        private static ThreadInfo getThreadInfo() {
            ThreadInfo info = new ThreadInfo();
            info.dalvikNum = Thread.activeCount();
            File tasksParent = ThreadsMonitorTask.getTasksParent();
            if (tasksParent != null) {
                try {
                    info.totalNum = tasksParent.list().length;
                }
                catch (Exception e) {
                    Log.e(ThreadsController.TAG, "", e);
                }
            }
            info.nativeNum = info.totalNum - info.dalvikNum;
            if (Utils.isApkDebugable()) {
                Log.d("ThreadController", "totalNum:" + info.totalNum + " dalvikNum:" + info.dalvikNum + " nativeNum:" + info.nativeNum, new Object[0]);
            }
            return info;
        }

        private static HashMap<String, Integer> getThreadsDetailInfo() {
            HashMap<String, Integer> threads = new HashMap<String, Integer>();
            File[] tasks = null;
            File tasksParent = ThreadsMonitorTask.getTasksParent();
            if (tasksParent != null) {
                try {
                    tasks = tasksParent.listFiles();
                }
                catch (Exception e) {
                    Log.e(ThreadsController.TAG, "", e);
                }
            }
            if (tasks != null && tasks.length > 0) {
                File taskItem = null;
                String taskName = null;
                int num = 0;
                for (File item : tasks) {
                    try {
                        if (!item.exists()) continue;
                        taskItem = new File(item.getAbsolutePath(), "comm");
                        taskName = Utils.readFirstLine(taskItem);
                        if (taskName != null && taskName.length() > 2) {
                            taskName = taskName.substring(0, taskName.length() - 2);
                        }
                        if (taskName == null) continue;
                        if (threads.containsKey(taskName)) {
                            num = threads.get(taskName) + 1;
                            if (num <= 0) {
                                num = 1;
                            }
                            threads.put(taskName, num);
                            continue;
                        }
                        threads.put(taskName, 1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return threads;
        }

        private static String getThreadsDetailInfoStr(HashMap<String, Integer> threads) {
            if (threads == null || threads.size() <= 0) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Set<String> keys = threads.keySet();
            for (String key : keys) {
                if (key == null || key.length() == 0) continue;
                result.append(key);
                result.append(":");
                result.append(String.valueOf(threads.get(key)));
                result.append("\n");
            }
            return result.toString();
        }

        private static class ThreadInfo {
            int totalNum;
            int dalvikNum;
            int nativeNum;

            private ThreadInfo() {
            }
        }
    }
}

