/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.executor;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.executor.FifoPriorityThreadPoolExecutor;
import com.yy.mobile.perf.executor.HandlEx;
import com.yy.mobile.perf.executor.IQueueTaskExecutor;
import com.yy.mobile.perf.executor.IYYTaskExecutor;
import com.yy.mobile.perf.executor.Prioritized;
import com.yy.mobile.perf.executor.ReflectionHelper;
import com.yy.mobile.perf.log.Log;
import java.util.ArrayList;
import java.util.HashMap;

public class PerfTaskExecutor
implements IYYTaskExecutor {
    public static final int THREAD_PRIORITY_LOW = 14;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_WORK_PRIORITY = 5;
    public static final int THREAD_PRIORITY_NORMAL = 5;
    public static final int THREAD_PRIORITY_HIGH = 0;
    private static final int sThreadPoolSize = 8;
    private static volatile IYYTaskExecutor sInst;
    private static FifoPriorityThreadPoolExecutor sThreadPool;
    private final HashMap<Runnable, Runnable> sDelayExecutorRunnableCache = new HashMap();
    private final HashMap<Runnable, Runnable> sExecutorRunnableCache = new HashMap();
    private static Thread sMainThread;
    private static int sPid;
    private static volatile HandlEx sMainThreadHandler;
    private static final HashMap<Runnable, CustomIdelHandler> sMainThreadIdelRunnableCache;

    private PerfTaskExecutor() {
        Log.d("", "", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IYYTaskExecutor instance() {
        if (sInst != null) return sInst;
        Class<PerfTaskExecutor> clazz = PerfTaskExecutor.class;
        synchronized (PerfTaskExecutor.class) {
            if (sInst != null) return sInst;
            sInst = new PerfTaskExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setTaskExecutor(IYYTaskExecutor taskExecutor) {
        if (sInst != null) {
            Class<PerfTaskExecutor> clazz = PerfTaskExecutor.class;
            // MONITORENTER : com.yy.mobile.perf.executor.PerfTaskExecutor.class
            if (sInst instanceof PerfTaskExecutor) {
                ((PerfTaskExecutor)sInst).destroy();
            }
            // MONITOREXIT : clazz
        }
        sInst = taskExecutor;
    }

    public void execute(Runnable task) {
        this.execute(task, 0L);
    }

    @Override
    public void execute(Runnable task, long delayMillis) {
        this.execute(task, null, delayMillis, 10);
    }

    @Override
    public void execute(Runnable task, long delayMillis, int priority) {
        this.execute(task, null, delayMillis, priority);
    }

    @Override
    public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
        this.execute(task, callbackInMainThread, delayMillis, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable task, Runnable callbackInMainThread, long delayMillis, int thePriority) {
        if (task == null) {
            return;
        }
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        if (thePriority < 0) {
            thePriority = 10;
        } else if (thePriority > 0) {
            thePriority = 0;
        }
        int priority = thePriority;
        ExecutorRunnable theExecutorRunnable = ExecutorRunnable.obtain();
        if (theExecutorRunnable == null) {
            theExecutorRunnable = new ExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (this.priority != 10) {
                            Process.setThreadPriority((int)this.priority);
                        }
                        HashMap hashMap = PerfTaskExecutor.this.sExecutorRunnableCache;
                        synchronized (hashMap) {
                            PerfTaskExecutor.this.sExecutorRunnableCache.remove(this.task);
                        }
                        this.task.run();
                        if (this.callBack != null) {
                            PerfTaskExecutor.getMainThreadHandler().post(this.callBack);
                        }
                    }
                    catch (Throwable t) {
                        HashMap hashMap = PerfTaskExecutor.this.sExecutorRunnableCache;
                        synchronized (hashMap) {
                            PerfTaskExecutor.this.sExecutorRunnableCache.remove(this.task);
                        }
                        Log.e("PerfTaskExecutor execute error one:", t, "", new Object[0]);
                        if (Utils.isApkDebugable()) {
                            PerfTaskExecutor.getMainThreadHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    throw new RuntimeException(PerfTaskExecutor.getStackTraceString(t), t);
                                }
                            });
                        }
                    }
                    finally {
                        if (this.priority != 10) {
                            try {
                                Process.setThreadPriority((int)10);
                            }
                            catch (Throwable throwable) {}
                        }
                        this.recycle();
                    }
                }
            };
        }
        final ExecutorRunnable executorRunnable = theExecutorRunnable;
        executorRunnable.task = task;
        executorRunnable.callBack = callbackInMainThread;
        executorRunnable.priority = priority;
        if (delayMillis > 0L) {
            Runnable delayDelayExecutorRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap hashMap = PerfTaskExecutor.this.sDelayExecutorRunnableCache;
                    synchronized (hashMap) {
                        PerfTaskExecutor.this.sDelayExecutorRunnableCache.remove(task);
                    }
                    PerfTaskExecutor.this.execute(executorRunnable);
                }
            };
            HashMap<Runnable, Runnable> hashMap = this.sDelayExecutorRunnableCache;
            synchronized (hashMap) {
                this.sDelayExecutorRunnableCache.put(task, delayDelayExecutorRunnable);
            }
            this.postToMainThread(delayDelayExecutorRunnable, delayMillis);
        } else {
            this.execute(executorRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ExecutorRunnable task) {
        block7: {
            if (task == null || task.task == null) {
                return;
            }
            try {
                if (sThreadPool.isShutdown()) break block7;
                HashMap<Runnable, Runnable> hashMap = this.sExecutorRunnableCache;
                synchronized (hashMap) {
                    this.sExecutorRunnableCache.put(task.task, task);
                }
                sThreadPool.execute(task);
            }
            catch (Throwable e) {
                if (Utils.isApkDebugable()) {
                    PerfTaskExecutor.getMainThreadHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(PerfTaskExecutor.getStackTraceString(e), e);
                        }
                    });
                }
                Log.e("PerfTaskExecutor execute error two:", e, "", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTask(Runnable task) {
        Runnable executorRunnable;
        Runnable delayExecutorRunnable;
        if (task == null) {
            return;
        }
        HashMap<Runnable, Runnable> hashMap = this.sDelayExecutorRunnableCache;
        synchronized (hashMap) {
            delayExecutorRunnable = this.sDelayExecutorRunnableCache.remove(task);
        }
        if (delayExecutorRunnable != null) {
            PerfTaskExecutor.getMainThreadHandler().removeCallbacks(delayExecutorRunnable);
        }
        HashMap<Runnable, Runnable> hashMap2 = this.sExecutorRunnableCache;
        synchronized (hashMap2) {
            executorRunnable = this.sExecutorRunnableCache.remove(task);
        }
        this.removeRunnableFromMainThread(task);
        if (executorRunnable != null) {
            try {
                if (sThreadPool != null) {
                    sThreadPool.remove(executorRunnable);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public IQueueTaskExecutor createAQueueExcuter() {
        return new QueueRunnableExcuter();
    }

    public void postToMainThread(Runnable task, long delayMillis) {
        if (task == null) {
            return;
        }
        PerfTaskExecutor.getMainThreadHandler().postDelayed(task, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postIdleRunnableToMainThread(Runnable runnable) {
        CustomIdelHandler idelHandler = new CustomIdelHandler(runnable);
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            sMainThreadIdelRunnableCache.put(runnable, idelHandler);
        }
        idelHandler.post();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunnableFromMainThread(Runnable task) {
        if (task == null) {
            return;
        }
        PerfTaskExecutor.getMainThreadHandler().removeCallbacks(task);
        CustomIdelHandler idelHandler = null;
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            idelHandler = sMainThreadIdelRunnableCache.remove(task);
        }
        if (idelHandler != null) {
            idelHandler.stop();
        }
    }

    public boolean isMainThread() {
        Looper looper;
        Thread current = Thread.currentThread();
        if (sMainThread == null && (looper = Looper.getMainLooper()) != null) {
            sMainThread = looper.getThread();
        }
        return sMainThread == current;
    }

    public synchronized void destroy() {
        if (sThreadPool != null) {
            try {
                sThreadPool.shutdown();
            }
            catch (Throwable t) {
                Log.e("PerfTaskExecutor", "Empty Catch on destroy", t);
            }
            sThreadPool = null;
        }
    }

    public static int getPid() {
        if (sPid == -1) {
            sPid = Process.myPid();
        }
        return sPid;
    }

    private static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private static HandlEx getMainThreadHandler() {
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new HandlEx("MainThreadHandler + 8", Looper.getMainLooper());
        }
        return sMainThreadHandler;
    }

    static {
        sThreadPool = new FifoPriorityThreadPoolExecutor(8, FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.LOG);
        sMainThread = null;
        sPid = -1;
        sMainThreadIdelRunnableCache = new HashMap();
    }

    private static class CustomIdelHandler
    implements MessageQueue.IdleHandler {
        private static final MessageQueue mMainThreadQueue = (MessageQueue)ReflectionHelper.getFieldValue(Looper.getMainLooper(), "mQueue");
        private static final Handler mHandler = new HandlEx("IdleHandler", Looper.getMainLooper());
        private static final long mRunnableDelayTime = 10000L;
        private Runnable mRunnable;
        private final Runnable mPostRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (mMainThreadQueue != null) {
                    mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)CustomIdelHandler.this);
                }
                CustomIdelHandler.this.mRunnable.run();
                HashMap hashMap = sMainThreadIdelRunnableCache;
                synchronized (hashMap) {
                    sMainThreadIdelRunnableCache.remove(CustomIdelHandler.this.mRunnable);
                }
            }
        };

        public CustomIdelHandler(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueIdle() {
            mHandler.removeCallbacks(this.mPostRunnable);
            this.mRunnable.run();
            HashMap hashMap = sMainThreadIdelRunnableCache;
            synchronized (hashMap) {
                sMainThreadIdelRunnableCache.remove(this.mRunnable);
            }
            return false;
        }

        public void post() {
            if (mMainThreadQueue == null) {
                throw new Error("CustomIdelHandler main thread queue is null!");
            }
            mHandler.postDelayed(this.mPostRunnable, 10000L);
            mMainThreadQueue.addIdleHandler((MessageQueue.IdleHandler)this);
        }

        public void stop() {
            if (mMainThreadQueue != null) {
                mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)this);
                mHandler.removeCallbacks(this.mPostRunnable);
            }
        }
    }

    private static abstract class ExecutorRunnable
    implements Runnable,
    Prioritized,
    Comparable<Prioritized> {
        Runnable task;
        Runnable callBack;
        int priority;
        private ExecutorRunnable mNext;
        private static int sPoolSize = 0;
        private static final int MAX_POOL_SIZE = 100;
        private static final Object sPoolSync = new Object();
        private static ExecutorRunnable sPool;

        private ExecutorRunnable() {
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.priority;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            return loadTask.getPriority() - this.priority;
        }

        private void reset() {
            this.task = null;
            this.callBack = null;
            this.priority = 10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExecutorRunnable obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    ExecutorRunnable m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    return m;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 100) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }
    }

    private static abstract class QueueExecutorRunnable
    extends ExecutorRunnable {
        long delayMills;

        private QueueExecutorRunnable() {
        }
    }

    private static class QueueRunnableExcuter
    implements IQueueTaskExecutor {
        private ArrayList<Runnable> mTasks = new ArrayList();
        private HashMap<Runnable, QueueExecutorRunnable> mQueueExecutorRunnables = new HashMap();
        private boolean mRunning = false;

        private QueueRunnableExcuter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNext() {
            QueueExecutorRunnable runnableToRun = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mRunning) {
                    return;
                }
                if (!this.mRunning && this.mTasks.size() > 0) {
                    runnableToRun = this.mQueueExecutorRunnables.get(this.mTasks.get(0));
                    this.mRunning = true;
                }
            }
            if (runnableToRun != null) {
                PerfTaskExecutor.instance().execute(runnableToRun, null, runnableToRun.delayMills, runnableToRun.priority);
            }
        }

        @Override
        public void execute(Runnable task, long delayMillis) {
            this.execute(task, delayMillis, 10);
        }

        @Override
        public void execute(Runnable task, long delayMillis, int priority) {
            this.execute(task, null, delayMillis, priority);
        }

        @Override
        public void execute(Runnable task, Runnable callback, long delayMillis) {
            this.execute(task, callback, delayMillis, 10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable task, Runnable callBack, long delayMills, int priority) {
            if (task == null) {
                return;
            }
            QueueExecutorRunnable executorRunnable = new QueueExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.task.run();
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        QueueRunnableExcuter.this.mTasks.remove(this.task);
                        QueueRunnableExcuter.this.mQueueExecutorRunnables.remove(this.task);
                    }
                    if (this.callBack != null) {
                        PerfTaskExecutor.getMainThreadHandler().post(this.callBack);
                    }
                    QueueRunnableExcuter.this.mRunning = false;
                    QueueRunnableExcuter.this.executeNext();
                }
            };
            executorRunnable.task = task;
            executorRunnable.callBack = callBack;
            executorRunnable.delayMills = delayMills;
            executorRunnable.priority = priority;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                this.mTasks.remove(task);
                this.mTasks.add(task);
                this.mQueueExecutorRunnables.put(task, executorRunnable);
            }
            this.executeNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTask(Runnable task) {
            if (task == null) {
                return;
            }
            ExecutorRunnable executorRunnable = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                this.mTasks.remove(task);
                executorRunnable = this.mQueueExecutorRunnables.remove(task);
            }
            if (executorRunnable != null) {
                PerfTaskExecutor.instance().removeTask(executorRunnable);
            }
        }
    }

    public static abstract class RunnableEx
    implements Runnable {
        private Object mArg;

        public void setArg(Object arg) {
            this.mArg = arg;
        }

        public Object getArg() {
            return this.mArg;
        }
    }
}

