/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import android.os.Build;
import android.os.Debug;
import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.collect.controllers.AbstractMonitorTask;
import com.yy.mobile.perf.collect.controllers.AbstractPerfController;
import com.yy.mobile.perf.executor.IQueueTaskExecutor;
import com.yy.mobile.perf.executor.PerfTaskExecutor;
import com.yy.mobile.perf.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class MemoryController
extends AbstractPerfController {
    private static final String TAG = "MemoryController";

    public MemoryController(AbstractPerfController.ICollectListener monitorListener) {
        super("memory", monitorListener);
    }

    @Override
    public AbstractMonitorTask createMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
        return new MemoryMonitorTask(bussiness, perfMonitorConfig);
    }

    private static class MemoryMonitorTask
    extends AbstractMonitorTask {
        private static final int MEMORY_EXCEED_VALUE = 1024;
        private static final int DALVIK_MEMORY_EXCEED_VALUE = 350;
        private static final String DIR_NAME = "memory";
        private static final int COLLECT_TIME_GAP = 10000;
        private volatile IQueueTaskExecutor mQueueTaskExecutor;
        private ArrayList<MemoryInfo> mMemoryInfos = new ArrayList();
        private volatile boolean mEnded = false;
        private PerfTaskExecutor.RunnableEx mAddMemoryInfo = new PerfTaskExecutor.RunnableEx(){

            @Override
            public void run() {
                MemoryMonitorTask.this.addMemoryInfo();
            }
        };
        private PerfTaskExecutor.RunnableEx mWatchMemoryOverFlow = new PerfTaskExecutor.RunnableEx(){

            @Override
            public void run() {
                if (!MemoryMonitorTask.this.mCancled && !MemoryMonitorTask.this.watchOverflowInner()) {
                    MemoryMonitorTask.this.getQueueTaskExecutor().execute(MemoryMonitorTask.this.mWatchMemoryOverFlow, 30000L);
                }
            }
        };

        public MemoryMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
            super(bussiness, perfMonitorConfig);
        }

        private IQueueTaskExecutor getQueueTaskExecutor() {
            if (this.mQueueTaskExecutor == null) {
                this.mQueueTaskExecutor = PerfTaskExecutor.instance().createAQueueExcuter();
            }
            return this.mQueueTaskExecutor;
        }

        private void addMemoryInfo() {
            MemoryInfo info = this.getMemoryBaseInfo();
            if (info != null) {
                this.mMemoryInfos.add(info);
            }
            if (!this.mEnded && !this.mCancled) {
                this.getQueueTaskExecutor().execute(this.mAddMemoryInfo, 10000L);
            }
        }

        @Override
        public void start() {
            this.mCancled = false;
            this.mEnded = false;
            this.getQueueTaskExecutor().execute(this.mAddMemoryInfo, 0L);
        }

        @Override
        public void cancle() {
            this.getQueueTaskExecutor().removeTask(this.mAddMemoryInfo);
            this.getQueueTaskExecutor().removeTask(this.mWatchMemoryOverFlow);
            super.cancle();
        }

        @Override
        public void end() {
            this.mEnded = true;
            this.getQueueTaskExecutor().removeTask(this.mAddMemoryInfo);
            this.getQueueTaskExecutor().execute(this.mAddMemoryInfo, 10000L);
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    if (MemoryMonitorTask.this.mCancled) {
                        return;
                    }
                    HashMap<String, String> result = null;
                    int totalPss = 0;
                    int nativePss = 0;
                    int dalvikPss = 0;
                    if (MemoryMonitorTask.this.mMemoryInfos != null && MemoryMonitorTask.this.mMemoryInfos.size() > 0) {
                        for (MemoryInfo info : MemoryMonitorTask.this.mMemoryInfos) {
                            totalPss += info.totalPss;
                            nativePss += info.nativePss;
                            dalvikPss += info.dalvikPss;
                        }
                        result = new HashMap<String, String>();
                        result.put("num", String.valueOf(totalPss / MemoryMonitorTask.this.mMemoryInfos.size()));
                        result.put("nnum", String.valueOf(nativePss / MemoryMonitorTask.this.mMemoryInfos.size()));
                        result.put("dnum", String.valueOf(dalvikPss / MemoryMonitorTask.this.mMemoryInfos.size()));
                    }
                    if (MemoryMonitorTask.this.mListener != null && !MemoryMonitorTask.this.mCancled) {
                        MemoryMonitorTask.this.mListener.onTaskEnded(MemoryMonitorTask.this.mBussiness, MemoryMonitorTask.this.mPerfMonitorConfig, result);
                    }
                }
            }, 0L);
        }

        @Override
        public void watch() {
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    HashMap<String, String> result = null;
                    int totalPss = 0;
                    int nativePss = 0;
                    int dalvikPss = 0;
                    MemoryInfo info = MemoryMonitorTask.this.getMemoryBaseInfo();
                    if (info != null) {
                        dalvikPss += info.dalvikPss;
                        result = new HashMap<String, String>();
                        result.put("num", String.valueOf(totalPss += info.totalPss));
                        result.put("nnum", String.valueOf(nativePss += info.nativePss));
                        result.put("dnum", String.valueOf(dalvikPss));
                    }
                    if (MemoryMonitorTask.this.mWatchListener != null) {
                        MemoryMonitorTask.this.mWatchListener.onWatchEnded(MemoryMonitorTask.this.mBussiness, MemoryMonitorTask.this.mPerfMonitorConfig, result);
                    }
                }
            }, 0L);
        }

        @Override
        public void watchOverFlow() {
            super.watchOverFlow();
            this.getQueueTaskExecutor().removeTask(this.mWatchMemoryOverFlow);
            this.getQueueTaskExecutor().execute(this.mWatchMemoryOverFlow, 0L);
        }

        public boolean watchOverflowInner() {
            if (this.mWatchOverFlowListener == null) {
                return false;
            }
            MemoryInfo info = this.getMemoryInfo(true);
            if (info != null) {
                String hporfFile = "";
                HashMap<String, String> result = null;
                int overFlowValue = 0;
                int dalvikOverFlowValue = 0;
                if (this.mPerfMonitorConfig != null) {
                    overFlowValue = Utils.strToInt((String)this.mPerfMonitorConfig.get("overflownum"));
                    dalvikOverFlowValue = Utils.strToInt((String)this.mPerfMonitorConfig.get("doverflownum"));
                }
                if (overFlowValue <= 0) {
                    overFlowValue = 1024;
                }
                if (dalvikOverFlowValue <= 0) {
                    dalvikOverFlowValue = 350;
                }
                if (info.totalPss > overFlowValue) {
                    if (info.dalvikPss > dalvikOverFlowValue) {
                        // empty if block
                    }
                    result = new HashMap<String, String>();
                    result.put("num", String.valueOf(info.totalPss));
                    result.put("nnum", String.valueOf(info.nativePss));
                    result.put("dnum", String.valueOf(info.dalvikPss));
                    result.put("hprofpath", String.valueOf(hporfFile));
                    String allInfoStr = null;
                    if (info.memoryInfo != null) {
                        if (Build.VERSION.SDK_INT >= 23) {
                            Map allInfo = info.memoryInfo.getMemoryStats();
                            if (allInfo != null) {
                                allInfoStr = allInfo.toString();
                            }
                        } else {
                            allInfoStr = "other: " + info.memoryInfo.otherPss;
                        }
                    }
                    if (allInfoStr != null && allInfoStr.length() > 0) {
                        result.put("allinfo", allInfoStr);
                    }
                    if (Utils.isApkDebugable()) {
                        Log.d(MemoryController.TAG, "overflow : " + result.toString(), new Object[0]);
                    }
                    if (this.mWatchOverFlowListener != null) {
                        this.mWatchOverFlowListener.onWatchOverFlowEnded(this.mBussiness, this.mPerfMonitorConfig, result);
                    }
                    return true;
                }
            }
            return false;
        }

        public MemoryInfo getMemoryInfo(boolean all) {
            Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
            if (memoryInfo.dalvikPss > 0 && memoryInfo.getTotalPss() > 0 && memoryInfo.nativePss >= 0) {
                MemoryInfo info = new MemoryInfo();
                info.dalvikPss = memoryInfo.dalvikPss / 1024;
                info.totalPss = memoryInfo.getTotalPss() / 1024;
                info.nativePss = memoryInfo.nativePss / 1024;
                if (Utils.isApkDebugable()) {
                    Log.d("CpuController", "totalPss:" + info.totalPss + " nativePss:" + info.nativePss + " dalvikPss:" + info.dalvikPss, new Object[0]);
                }
                if (all) {
                    info.memoryInfo = memoryInfo;
                }
                return info;
            }
            return null;
        }

        public MemoryInfo getMemoryBaseInfo() {
            return this.getMemoryInfo(false);
        }

        public void deleteDumpHprofFiles() {
            long curTime = System.currentTimeMillis();
            String path = Utils.getLocalPerfPath();
            File dir = new File(path, DIR_NAME);
            if (dir.isDirectory()) {
                try {
                    for (File file : dir.listFiles()) {
                        if (file == null || file.getName() == null || !file.getName().contains(".hprof") || file.lastModified() > 0L && curTime - file.lastModified() <= 259200L) continue;
                        file.delete();
                    }
                }
                catch (Throwable e) {
                    Log.e(MemoryController.TAG, "deleteDumpHprofFile", e);
                }
            }
        }

        public String dumpHprof() {
            long curTime = System.currentTimeMillis();
            String path = Utils.getLocalPerfPath();
            String hprofName = Utils.getDateAndTime(curTime) + ".hprof";
            File dir = new File(path, DIR_NAME);
            if (!dir.exists() || !dir.isDirectory()) {
                dir.mkdirs();
            }
            File hprofFile = new File(dir, hprofName);
            try {
                Debug.dumpHprofData((String)hprofFile.getAbsolutePath());
                Log.d(MemoryController.TAG, "dump hprof file done!", new Object[0]);
            }
            catch (IOException e) {
                Log.d(MemoryController.TAG, "dump hprof file error " + e, new Object[0]);
                return "";
            }
            return hprofFile.getAbsolutePath();
        }

        private static class MemoryInfo {
            int totalPss;
            int nativePss;
            int dalvikPss;
            Debug.MemoryInfo memoryInfo;

            private MemoryInfo() {
            }
        }
    }
}

