/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import com.yy.mobile.perf.PerfSDK;

class NetworkState {
    public static final String TYPE_2G = "2g";
    public static final String TYPE_3G = "3g";
    public static final String TYPE_4G = "4g";
    public static final String TYPE_WIFI = "wifi";
    public static final String TYPE_NONE = "unknown";
    private static String currNetworkType = null;
    private static Callback networkChangedCallback;
    private static BroadcastReceiver sNetworkBroadcastReceiver;

    NetworkState() {
    }

    public static void registerNetworkChangeBroadcastReceiver(Context context, Callback callback) {
        networkChangedCallback = callback;
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(sNetworkBroadcastReceiver, filter);
    }

    public static void unregisterNetworkChangeBroadcastReceiver(Context context, Callback callback) {
        if (callback == networkChangedCallback) {
            networkChangedCallback = null;
        }
        context.unregisterReceiver(sNetworkBroadcastReceiver);
    }

    public static boolean isNetworkAvailable() {
        return TYPE_WIFI.equals(currNetworkType) || TYPE_4G.equals(currNetworkType) || TYPE_3G.equals(currNetworkType) || TYPE_2G.equals(currNetworkType);
    }

    public static String getCurrNetworkType(Context context) {
        if (currNetworkType != null) {
            return currNetworkType;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return TYPE_NONE;
        }
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo == null) {
            return TYPE_NONE;
        }
        String nwtype = TYPE_NONE;
        int type = netInfo.getType();
        if (type == 1 || type == 6) {
            nwtype = TYPE_WIFI;
        } else if (type == 0) {
            int subType = netInfo.getSubtype();
            if (subType == 7 || subType == 3 || subType == 14 || subType == 5 || subType == 6 || subType == 12 || subType == 8 || subType == 10 || subType == 15 || subType == 9) {
                nwtype = TYPE_3G;
            } else if (subType == 1 || subType == 4 || subType == 2 || subType == 11) {
                nwtype = TYPE_2G;
            } else if (subType == 13) {
                nwtype = TYPE_4G;
            } else {
                return TYPE_NONE;
            }
        }
        currNetworkType = nwtype;
        return currNetworkType;
    }

    static {
        sNetworkBroadcastReceiver = new BroadcastReceiver(){
            private AsyncTask lastTask;

            public void onReceive(Context context, Intent intent) {
                if (this.lastTask != null) {
                    this.lastTask.cancel(true);
                }
                this.lastTask = new AsyncTask<Void, Void, String>(){

                    protected String doInBackground(Void ... params) {
                        return NetworkState.getCurrNetworkType((Context)PerfSDK.instance().getApplication());
                    }

                    protected void onPostExecute(String networkType) {
                        currNetworkType = networkType;
                        lastTask = null;
                        if (networkChangedCallback != null) {
                            networkChangedCallback.notifyChanged(currNetworkType);
                        }
                    }
                }.execute((Object[])new Void[0]);
            }
        };
    }

    static interface Callback {
        public void notifyChanged(String var1);
    }
}

