/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.collect.controllers.AbstractMonitorTask;
import com.yy.mobile.perf.collect.controllers.AbstractPerfController;
import com.yy.mobile.perf.executor.IQueueTaskExecutor;
import com.yy.mobile.perf.executor.PerfTaskExecutor;
import com.yy.mobile.perf.log.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;

class CPUController
extends AbstractPerfController {
    private static final String TAG = "CPUController";

    public CPUController(AbstractPerfController.ICollectListener monitorListener) {
        super("cpu", monitorListener);
    }

    @Override
    public AbstractMonitorTask createMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
        return new CPUMonitorTask(bussiness, perfMonitorConfig);
    }

    private static class CPUMonitorTask
    extends AbstractMonitorTask {
        private volatile IQueueTaskExecutor mQueueTaskExecutor;
        private volatile CPUInfo mStartCpuInfo;

        public CPUMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
            super(bussiness, perfMonitorConfig);
        }

        private IQueueTaskExecutor getQueueTaskExecutor() {
            if (this.mQueueTaskExecutor == null) {
                this.mQueueTaskExecutor = PerfTaskExecutor.instance().createAQueueExcuter();
            }
            return this.mQueueTaskExecutor;
        }

        @Override
        public void start() {
            this.mCancled = false;
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    CPUMonitorTask.this.mStartCpuInfo = CPUMonitorTask.this.getCPUInfo();
                }
            }, 0L);
        }

        @Override
        public void end() {
            if (this.mCancled) {
                return;
            }
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    if (CPUMonitorTask.this.mCancled) {
                        return;
                    }
                    CPUInfo endCpuinfo = CPUMonitorTask.this.getCPUInfo();
                    HashMap<String, String> result = null;
                    if (CPUMonitorTask.this.mStartCpuInfo != null && endCpuinfo != null) {
                        int percent = -1;
                        if (((CPUMonitorTask)CPUMonitorTask.this).mStartCpuInfo.totalJiffies > 0 && endCpuinfo.totalJiffies > 0 && endCpuinfo.totalJiffies != ((CPUMonitorTask)CPUMonitorTask.this).mStartCpuInfo.totalJiffies) {
                            percent = 100 * (endCpuinfo.totalJiffies - endCpuinfo.totalIdle - (((CPUMonitorTask)CPUMonitorTask.this).mStartCpuInfo.totalJiffies - ((CPUMonitorTask)CPUMonitorTask.this).mStartCpuInfo.totalIdle)) / (endCpuinfo.totalJiffies - ((CPUMonitorTask)CPUMonitorTask.this).mStartCpuInfo.totalJiffies);
                        }
                        result = new HashMap<String, String>(5);
                        result.put("usp", String.valueOf(percent));
                    }
                    if (CPUMonitorTask.this.mListener != null && !CPUMonitorTask.this.mCancled) {
                        CPUMonitorTask.this.mListener.onTaskEnded(CPUMonitorTask.this.mBussiness, CPUMonitorTask.this.mPerfMonitorConfig, result);
                    }
                }
            }, 0L);
        }

        @Override
        public void watch() {
            this.getQueueTaskExecutor().execute(new PerfTaskExecutor.RunnableEx(){

                @Override
                public void run() {
                    CPUInfo endCpuinfo = CPUMonitorTask.this.getCPUInfo();
                    if (endCpuinfo == null) {
                        if (CPUMonitorTask.this.mWatchListener != null) {
                            CPUMonitorTask.this.mWatchListener.onWatchEnded(CPUMonitorTask.this.mBussiness, CPUMonitorTask.this.mPerfMonitorConfig, null);
                        }
                    } else {
                        int percent = -1;
                        if (endCpuinfo.totalJiffies > 0) {
                            percent = 100 * (endCpuinfo.totalJiffies - endCpuinfo.totalIdle) / endCpuinfo.totalJiffies;
                        }
                        HashMap<String, String> result = new HashMap<String, String>(5);
                        result.put("usp", String.valueOf(percent));
                        if (CPUMonitorTask.this.mWatchListener != null) {
                            CPUMonitorTask.this.mWatchListener.onWatchEnded(CPUMonitorTask.this.mBussiness, CPUMonitorTask.this.mPerfMonitorConfig, result);
                        }
                    }
                }
            }, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public CPUInfo getCPUInfo() {
            info = new CPUInfo();
            path = "/proc/stat";
            idleIndex = 3;
            fileReader = null;
            bufferedReader = null;
            pattern = Pattern.compile(" [0-9]+");
            try {
                fileReader = new FileReader("/proc/stat");
                bufferedReader = new BufferedReader(fileReader, 8192);
                while ((str = bufferedReader.readLine()) != null) {
                    if (this.mCancled) {
                        info = null;
                        break;
                    }
                    if (!str.toLowerCase().startsWith("cpu")) continue;
                    ++info.cpuNum;
                    index = 0;
                    matcher = pattern.matcher(str);
                    while (matcher.find()) {
                        try {
                            tempJiffies = Long.parseLong(matcher.group(0).trim());
                            info.totalJiffies = (int)((long)info.totalJiffies + tempJiffies);
                            if (index == 3) {
                                info.totalIdle = (int)((long)info.totalIdle + tempJiffies);
                            }
                            ++index;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ** if (bufferedReader == null) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    Log.d("CPUController", "get CPU info error:", new Object[]{e});
                    ** if (bufferedReader == null) goto lbl-1000
                }
                catch (Throwable var12_15) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            Log.d("CPUController", "get CPU info error2:", new Object[]{e});
                        }
                    }
                    throw var12_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        Log.d("CPUController", "get CPU info error2:", new Object[]{e});
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    Log.d("CPUController", "get CPU info error2:", new Object[]{e});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            if (Utils.isApkDebugable() && info != null) {
                Log.d("CpuController", "totalJiffies:" + info.totalJiffies + " totalIdle:" + info.totalIdle + " cpunum:" + info.cpuNum, new Object[0]);
            }
            return info;
        }

        private static class CPUInfo {
            int totalJiffies;
            int totalIdle;
            int cpuNum;

            private CPUInfo() {
            }
        }
    }
}

