/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.log.Log;
import java.util.HashMap;

abstract class AbstractMonitorTask {
    public String mBussiness;
    protected final HashMap<String, String> mPerfMonitorConfig = new HashMap();
    protected IMonitorListener mListener;
    protected IWatchListener mWatchListener;
    protected IWatchOverFlowListener mWatchOverFlowListener;
    protected volatile boolean mCancled = false;

    public AbstractMonitorTask(String bussiness, HashMap<String, String> perfMonitorConfig) {
        this.mBussiness = bussiness;
        if (perfMonitorConfig != null && perfMonitorConfig.size() > 0) {
            this.mPerfMonitorConfig.putAll(perfMonitorConfig);
        }
    }

    public void setMonitorTaskListener(IMonitorListener listener) {
        this.mListener = listener;
    }

    public void setWatchListener(IWatchListener listener) {
        this.mWatchListener = listener;
    }

    public void setWatchOverFlowListener(IWatchOverFlowListener listener) {
        this.mWatchOverFlowListener = listener;
    }

    protected String getConfigValue(String key) {
        return this.mPerfMonitorConfig.get(key);
    }

    public abstract void start();

    public abstract void end();

    public void cancle() {
        this.mCancled = true;
        if (this.mListener != null) {
            this.mListener.onTaskCancled(this.mBussiness, this.mPerfMonitorConfig, null);
        }
    }

    public abstract void watch();

    public void watchOverFlow() {
        if (Utils.isApkDebugable() && this.mPerfMonitorConfig != null) {
            Log.d("mPerfMonitorConfig", "mPerfMonitorConfig:" + this.mPerfMonitorConfig.toString(), new Object[0]);
        }
    }

    public static interface IWatchOverFlowListener {
        public void onWatchOverFlowEnded(String var1, HashMap<String, String> var2, HashMap<String, String> var3);
    }

    public static interface IWatchListener {
        public void onWatchEnded(String var1, HashMap<String, String> var2, HashMap<String, String> var3);
    }

    public static interface IMonitorListener {
        public void onTaskEnded(String var1, HashMap<String, String> var2, HashMap<String, String> var3);

        public void onTaskCancled(String var1, HashMap<String, String> var2, HashMap<String, String> var3);
    }
}

