/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect.controllers;

import com.yy.mobile.perf.collect.controllers.AbstractMonitorTask;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPerfController {
    protected String mPerfType;
    protected ICollectListener mMonitorListener;
    protected ConcurrentHashMap<String, AbstractMonitorTask> mTasks = new ConcurrentHashMap();
    protected AbstractMonitorTask mOverFlowTask;

    public AbstractPerfController(String type, ICollectListener monitorListener) {
        this.mPerfType = type;
        this.mMonitorListener = monitorListener;
    }

    public void setListener(ICollectListener monitorListener) {
        this.mMonitorListener = monitorListener;
    }

    public void startMonitor(String bussiness, HashMap<String, String> perfMonitorConfig) {
        AbstractMonitorTask monitorTask = this.mTasks.get(bussiness);
        if (monitorTask != null) {
            monitorTask.cancle();
            this.mTasks.remove(bussiness);
        }
        monitorTask = this.createMonitorTask(bussiness, perfMonitorConfig);
        if (monitorTask.mListener == null) {
            monitorTask.setMonitorTaskListener(new AbstractMonitorTask.IMonitorListener(){

                @Override
                public void onTaskEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
                    AbstractPerfController.this.onMonitorTaskEnded(bussiness, perfMonitorConfig, results);
                }

                @Override
                public void onTaskCancled(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
                    AbstractPerfController.this.onMonitorTaskCancled(bussiness, perfMonitorConfig, results);
                }
            });
        }
        this.mTasks.put(bussiness, monitorTask);
        monitorTask.start();
        if (this.mMonitorListener != null) {
            this.mMonitorListener.onMonitorStarted(this.mPerfType, bussiness, perfMonitorConfig);
        }
    }

    public void endMonitor(String bussiness) {
        AbstractMonitorTask monitorTask = this.mTasks.get(bussiness);
        if (monitorTask != null) {
            monitorTask.end();
            this.mTasks.remove(bussiness);
        }
    }

    public void cancleMonitor(String bussiness) {
        AbstractMonitorTask monitorTask = this.mTasks.get(bussiness);
        if (monitorTask != null) {
            monitorTask.cancle();
            this.mTasks.remove(bussiness);
        }
    }

    public void watch(String bussiness, HashMap<String, String> perfMonitorConfig) {
        AbstractMonitorTask monitorTask = this.createMonitorTask(bussiness, perfMonitorConfig);
        if (monitorTask.mWatchListener == null) {
            monitorTask.setWatchListener(new AbstractMonitorTask.IWatchListener(){

                @Override
                public void onWatchEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
                    AbstractPerfController.this.onWatchTaskEnded(bussiness, perfMonitorConfig, results);
                }
            });
        }
        monitorTask.watch();
    }

    public void monitorOverFlow(HashMap<String, String> perfMonitorConfig) {
        this.cancleMonitorOverFlow();
        AbstractMonitorTask monitorTask = this.createMonitorTask("overflow", perfMonitorConfig);
        if (monitorTask.mWatchOverFlowListener == null) {
            monitorTask.setWatchOverFlowListener(new AbstractMonitorTask.IWatchOverFlowListener(){

                @Override
                public void onWatchOverFlowEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
                    AbstractPerfController.this.onWatchOverFlowTaskEnded(bussiness, perfMonitorConfig, results);
                }
            });
        }
        this.mOverFlowTask = monitorTask;
        monitorTask.watchOverFlow();
    }

    public void cancleMonitorOverFlow() {
        AbstractMonitorTask monitorTask = this.mOverFlowTask;
        if (monitorTask != null) {
            monitorTask.cancle();
        }
        this.mOverFlowTask = null;
    }

    public void handleCommand(int commandID, String bussiness, Object data) {
    }

    public String getType() {
        return this.mPerfType;
    }

    public abstract AbstractMonitorTask createMonitorTask(String var1, HashMap<String, String> var2);

    public void onMonitorTaskCancled(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
        if (this.mMonitorListener != null) {
            this.mMonitorListener.onMonitorCancled(this.mPerfType, bussiness, perfMonitorConfig);
        }
    }

    public void onMonitorTaskEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
        if (this.mMonitorListener != null) {
            this.mMonitorListener.onMonitorEnded(this.mPerfType, bussiness, perfMonitorConfig, results);
        }
    }

    public void onWatchTaskEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
        if (this.mMonitorListener != null) {
            this.mMonitorListener.onWatchEnded(this.mPerfType, bussiness, perfMonitorConfig, results);
        }
    }

    public void onWatchOverFlowTaskEnded(String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
        this.mOverFlowTask = null;
        if (this.mMonitorListener != null) {
            this.mMonitorListener.onOverFlowCatched(this.mPerfType, perfMonitorConfig, results);
        }
    }

    public static interface ICollectListener {
        public void onMonitorStarted(String var1, String var2, HashMap<String, String> var3);

        public void onMonitorCancled(String var1, String var2, HashMap<String, String> var3);

        public void onMonitorEnded(String var1, String var2, HashMap<String, String> var3, HashMap<String, String> var4);

        public void onOverFlowCatched(String var1, HashMap<String, String> var2, HashMap<String, String> var3);

        public void onWatchEnded(String var1, String var2, HashMap<String, String> var3, HashMap<String, String> var4);
    }
}

