/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect;

import android.app.Application;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.mobile.perf.collect.EnvSettings;
import com.yy.mobile.perf.collect.Utils;
import com.yy.mobile.perf.collect.controllers.AbstractPerfController;
import com.yy.mobile.perf.collect.controllers.Factory;
import com.yy.mobile.perf.log.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class Collecter {
    private NormalCollecter mNormalCollecter;

    public Collecter(Application application, String appId, String version) {
        EnvSettings.sAppId = appId;
        EnvSettings.sVersion = version;
        EnvSettings.sApplication = application;
        this.mNormalCollecter = new NormalCollecter();
    }

    public void startMonitor(int scode, String bussiness, HashMap<String, HashMap<String, String>> perfConfigs, HashMap<String, String> statMap) {
        this.mNormalCollecter.startMonitor(scode, bussiness, perfConfigs, statMap);
    }

    public void endMonitor(String bussiness) {
        this.mNormalCollecter.endMonitor(bussiness);
    }

    public void cancleMonitor(String bussiness) {
        this.mNormalCollecter.cancleMonitor(bussiness);
    }

    public void watch(int scode, String bussiness, HashMap<String, HashMap<String, String>> perfMonitorConfig, HashMap<String, String> statMap) {
        this.mNormalCollecter.watch(scode, bussiness, perfMonitorConfig, statMap);
    }

    public void catchOverFlow(IOverFlowListener listener, HashMap<String, HashMap<String, String>> perfConfigs) {
        this.mNormalCollecter.monitorOverFlow(listener, perfConfigs);
    }

    public void cancleCatchOverFlow() {
        this.mNormalCollecter.cancleMonitorOverFlow();
    }

    private static class NormalCollecter
    implements AbstractPerfController.ICollectListener {
        private static final String TAG = "NormalCollecter";
        private final ArrayList<AbstractPerfController> mControllers = new ArrayList();
        private HashMap<String, Item> mWatchBussinessStats = new HashMap();
        private HashMap<String, Item> mMonitorBussinessStats = new HashMap();
        private HashMap<String, Item> mMonitorEndedBussinessStats = new HashMap();
        private volatile IOverFlowListener mOverFlowListener;

        private NormalCollecter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startMonitor(int scode, String bussiness, HashMap<String, HashMap<String, String>> perfConfigs, HashMap<String, String> statMap) {
            if (bussiness == null || bussiness.length() == 0 || perfConfigs == null || perfConfigs.size() == 0) {
                return;
            }
            Item item = new Item(scode, bussiness, perfConfigs, statMap);
            this.cancleMonitor(bussiness);
            HashMap<String, Item> hashMap = this.mMonitorBussinessStats;
            synchronized (hashMap) {
                this.mMonitorBussinessStats.put(bussiness, item);
            }
            Set<String> perfKeys = perfConfigs.keySet();
            AbstractPerfController controller = null;
            for (String key : perfKeys) {
                controller = this.getController(key);
                if (controller == null) continue;
                controller.startMonitor(bussiness, perfConfigs.get(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AbstractPerfController getController(String perfKey) {
            if (perfKey == null) {
                return null;
            }
            AbstractPerfController result = null;
            ArrayList<AbstractPerfController> arrayList = this.mControllers;
            synchronized (arrayList) {
                if (this.mControllers.size() > 0) {
                    for (AbstractPerfController controller : this.mControllers) {
                        if (!Utils.equal(controller.getType(), perfKey)) continue;
                        result = controller;
                        break;
                    }
                }
            }
            if (result == null && (result = Factory.createController(perfKey, this)) != null) {
                arrayList = this.mControllers;
                synchronized (arrayList) {
                    this.mControllers.add(result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endMonitor(String bussiness) {
            Item item = this.mMonitorBussinessStats.get(bussiness);
            Cloneable cloneable = this.mMonitorBussinessStats;
            synchronized (cloneable) {
                this.mMonitorBussinessStats.remove(bussiness);
            }
            if (item != null) {
                cloneable = this.mMonitorEndedBussinessStats;
                synchronized (cloneable) {
                    this.mMonitorEndedBussinessStats.put(bussiness, item);
                }
            }
            cloneable = this.mControllers;
            synchronized (cloneable) {
                if (bussiness != null && this.mControllers.size() > 0) {
                    for (AbstractPerfController controller : this.mControllers) {
                        controller.endMonitor(bussiness);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancleMonitor(String bussiness) {
            Cloneable cloneable = this.mMonitorBussinessStats;
            synchronized (cloneable) {
                this.mMonitorBussinessStats.remove(bussiness);
            }
            cloneable = this.mControllers;
            synchronized (cloneable) {
                if (bussiness != null && this.mControllers.size() > 0) {
                    for (AbstractPerfController controller : this.mControllers) {
                        controller.cancleMonitor(bussiness);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void watch(int scode, String bussiness, HashMap<String, HashMap<String, String>> perfConfigs, HashMap<String, String> statMap) {
            if (bussiness == null || bussiness.length() == 0 || perfConfigs == null || perfConfigs.size() == 0) {
                return;
            }
            Item item = new Item(scode, bussiness, perfConfigs, statMap);
            HashMap<String, Item> hashMap = this.mWatchBussinessStats;
            synchronized (hashMap) {
                this.mWatchBussinessStats.put(bussiness, item);
            }
            Set<String> perfKeys = perfConfigs.keySet();
            AbstractPerfController controller = null;
            for (String key : perfKeys) {
                controller = this.getController(key);
                if (controller == null) continue;
                controller.watch(bussiness, perfConfigs.get(key));
            }
        }

        public void monitorOverFlow(IOverFlowListener listener, HashMap<String, HashMap<String, String>> perfConfigs) {
            if (perfConfigs == null || perfConfigs.size() == 0 || listener == null) {
                return;
            }
            this.mOverFlowListener = listener;
            Set<String> perfKeys = perfConfigs.keySet();
            AbstractPerfController controller = null;
            for (String key : perfKeys) {
                controller = this.getController(key);
                if (controller == null) continue;
                controller.monitorOverFlow(perfConfigs.get(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancleMonitorOverFlow() {
            ArrayList<AbstractPerfController> arrayList = this.mControllers;
            synchronized (arrayList) {
                if (this.mControllers.size() > 0) {
                    for (AbstractPerfController controller : this.mControllers) {
                        controller.cancleMonitorOverFlow();
                    }
                }
            }
        }

        @Override
        public void onMonitorStarted(String perfType, String bussiness, HashMap<String, String> perfMonitorConfig) {
            if (Utils.isApkDebugable()) {
                Log.d(TAG, "onMonitorStarted perfType:" + perfType + " bussiness:" + bussiness + " perfMonitorConfig:" + (perfMonitorConfig != null ? perfMonitorConfig.toString() : "null"), new Object[0]);
            }
        }

        @Override
        public void onMonitorCancled(String perfType, String bussiness, HashMap<String, String> perfMonitorConfig) {
            if (Utils.isApkDebugable()) {
                Log.d(TAG, "onMonitorCancled perfType:" + perfType + " bussiness:" + bussiness + " perfMonitorConfig:" + (perfMonitorConfig != null ? perfMonitorConfig.toString() : "null"), new Object[0]);
            }
        }

        @Override
        public void onMonitorEnded(String perfType, String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
            Item item;
            if (Utils.isApkDebugable()) {
                Log.d(TAG, "onMonitorEnded perfType:" + perfType + " bussiness:" + bussiness + " results:" + (results != null ? results.toString() : "null") + " perfMonitorConfig:" + (perfMonitorConfig != null ? perfMonitorConfig.toString() : "null"), new Object[0]);
            }
            if ((item = this.mMonitorEndedBussinessStats.get(bussiness)) != null) {
                MetricsStatHelper.addMonitorStat(item.scode, perfType, bussiness, perfMonitorConfig, results, item.statMap);
            }
        }

        @Override
        public void onOverFlowCatched(String perfType, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
            if (this.mOverFlowListener != null) {
                this.mOverFlowListener.onOverFlowCatched(perfType, perfMonitorConfig, results);
            }
        }

        @Override
        public void onWatchEnded(String perfType, String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results) {
            if (Utils.isApkDebugable()) {
                Log.d(TAG, "onWatchEnded perfType:" + perfType + " bussiness:" + bussiness + " results:" + (results != null ? results.toString() : "null") + " perfMonitorConfig:" + (perfMonitorConfig != null ? perfMonitorConfig.toString() : "null"), new Object[0]);
            }
            Item item = this.mWatchBussinessStats.get(bussiness);
            MetricsStatHelper.addWatchStat(item.scode, perfType, bussiness, perfMonitorConfig, results, item != null ? item.statMap : null);
        }

        private static class MetricsStatHelper {
            private MetricsStatHelper() {
            }

            public static void addMonitorStat(int scode, String perfType, String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results, HashMap<String, String> statMap) {
                MetricsStatHelper.addStat(scode, perfType, bussiness, perfMonitorConfig, results, statMap);
            }

            public static void addWatchStat(int scode, String perfType, String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results, HashMap<String, String> statMap) {
                MetricsStatHelper.addStat(scode, perfType, bussiness, perfMonitorConfig, results, statMap);
            }

            private static void addStat(int scode, String perfType, String bussiness, HashMap<String, String> perfMonitorConfig, HashMap<String, String> results, HashMap<String, String> statMap) {
                if (results == null || results.size() <= 0) {
                    return;
                }
                long value = -1L;
                String resultStr = null;
                if (Utils.equal(perfType, "cpu")) {
                    resultStr = results.get("usp");
                } else if (Utils.equal(perfType, "flow")) {
                    resultStr = results.get("tlbytes");
                } else if (Utils.equal(perfType, "memory")) {
                    resultStr = results.get("num");
                } else if (Utils.equal(perfType, "threads")) {
                    resultStr = results.get("num");
                }
                if (resultStr != null && resultStr.length() > 0) {
                    try {
                        value = Long.valueOf(resultStr);
                    }
                    catch (Exception e) {
                        Log.e("MetricsStatHelper", e, "data error!", new Object[0]);
                    }
                }
                if (value == -1L) {
                    return;
                }
                Log.d("MetricsStatHelper", "scode:" + scode + " addStat business:" + bussiness + " perfType:" + perfType + " value:" + value, new Object[0]);
                HiidoSDK.instance().reportSrcData(scode, bussiness, perfType, value, null);
            }
        }

        private static class Item {
            public String bussiness;
            public int scode;
            public HashMap<String, HashMap<String, String>> perfConfigs;
            public HashMap<String, String> statMap;

            public Item(int theScode, String theBussiness, HashMap<String, HashMap<String, String>> thePerfConfigs, HashMap<String, String> theStatMap) {
                this.scode = theScode;
                this.bussiness = theBussiness;
                this.perfConfigs = thePerfConfigs;
                this.statMap = theStatMap;
            }
        }
    }

    public static interface IOverFlowListener {
        public void onOverFlowCatched(String var1, HashMap<String, String> var2, HashMap<String, String> var3);
    }
}

