/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.perf.collect;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Environment;
import android.os.Process;
import com.yy.mobile.perf.collect.EnvSettings;
import com.yy.mobile.perf.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Utils {
    private static volatile boolean sIsDebugable = false;
    private static volatile boolean sIsDebugableInited = false;
    private static Date mDate;
    private static SimpleDateFormat mDateFormat;
    private static volatile String sLocalPerfPath;
    private static volatile String appName;

    public static boolean equal(String s1, String s2) {
        return Utils.equal(s1, s2, false);
    }

    public static boolean equal(String s1, String s2, boolean ignoreCase) {
        if (s1 != null && s2 != null) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static boolean isApkDebugable() {
        if (sIsDebugableInited) {
            return sIsDebugable;
        }
        if (EnvSettings.sApplication == null) {
            return false;
        }
        try {
            ApplicationInfo info = EnvSettings.sApplication.getApplicationInfo();
            sIsDebugable = (info.flags & 2) != 0;
            sIsDebugableInited = true;
            return sIsDebugable;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized String getDateAndTime(long time) {
        if (mDateFormat == null) {
            mDate = new Date();
            mDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS", Locale.SIMPLIFIED_CHINESE);
        }
        mDate.setTime(time);
        String result = mDateFormat.format(mDate);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getLocalPerfPath() {
        if (sLocalPerfPath != null) {
            return sLocalPerfPath;
        }
        String path = Utils.getAppName((Context)EnvSettings.getApplication()) + File.separator + "localPerf" + File.separator;
        String state = Environment.getExternalStorageState();
        File dir = null;
        dir = "mounted".equals(state) ? new File(Environment.getExternalStorageDirectory().getPath()) : EnvSettings.getApplication().getCacheDir();
        if (dir != null) {
            File localPerfPath = new File(dir.getAbsolutePath(), path);
            localPerfPath.mkdirs();
            sLocalPerfPath = localPerfPath.getAbsolutePath();
        }
        return sLocalPerfPath == null ? "" : sLocalPerfPath;
    }

    public static String getAppName(Context context) {
        if (appName != null) {
            return appName;
        }
        int pid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.pid != pid) continue;
            appName = info.processName;
        }
        return appName;
    }

    public static Integer strToInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            Log.e("Utils", "strToInt error", e);
            return -1;
        }
    }

    public static String readFirstLine(File file) {
        String result = null;
        BufferedReader buffreader = null;
        try {
            FileInputStream instream = new FileInputStream(file);
            if (instream != null) {
                InputStreamReader inputreader = new InputStreamReader(instream);
                buffreader = new BufferedReader(inputreader);
                String line = buffreader.readLine();
                if (line != null) {
                    result = line;
                }
                buffreader.close();
            }
        }
        catch (FileNotFoundException e) {
            try {
                if (buffreader != null) {
                    buffreader.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            try {
                if (buffreader != null) {
                    buffreader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

