/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.profile.anchor;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.extras_view.DynamicHeightImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homeapi.ui.home.LivingClientConstant;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.ui.utils.FontUtils;
import com.yy.mobile.util.FP;
import com.yymobile.core.profile.RePlayMergeWorksInfo;
import com.yymobile.core.profile.RePlayWorksInfo;
import com.yymobile.core.profile.SmallVideoWorksInfo;
import com.yymobile.core.profile.WorksInfo;
import java.util.ArrayList;
import java.util.List;

public class DetailAnchorWorksAdapter
extends BaseAdapter {
    private static final int TYPE_REPLAY_MERGE = 0;
    private static final int TYPE_OTHER = 1;
    private static final int TYPE_ITEM_COUNT = 2;
    private List<WorksInfo> worksList = new ArrayList<WorksInfo>();
    private Activity mContext;
    private boolean isFormAnchorWorksDetail = false;

    public DetailAnchorWorksAdapter(Activity context) {
        this.mContext = context;
    }

    public DetailAnchorWorksAdapter(Activity mContext, boolean isFormAnchorWorksDetail) {
        this.mContext = mContext;
        this.isFormAnchorWorksDetail = isFormAnchorWorksDetail;
    }

    public static Integer getImageResIdByVideoLayoutType(String videoLabelType) {
        if ("1".equals(videoLabelType)) {
            return R.drawable.personal_page_smallvideo_label_type_guess;
        }
        if ("2".equals(videoLabelType)) {
            return R.drawable.personal_page_smallvideo_label_type_co_play;
        }
        if ("3".equals(videoLabelType)) {
            return R.drawable.personal_page_smallvideo_label_type_joyscript;
        }
        if ("4".equals(videoLabelType)) {
            return R.drawable.personal_page_smallvideo_label_type_basketball;
        }
        if ("7".equals(videoLabelType)) {
            return R.drawable.main_small_video_talk_song_label;
        }
        return 0;
    }

    public void addData(List<WorksInfo> data) {
        if (!FP.empty(data)) {
            this.worksList.addAll(data);
            this.notifyDataSetChanged();
        }
    }

    public void clearData() {
        this.worksList.clear();
        this.notifyDataSetChanged();
    }

    public List<WorksInfo> getData() {
        return this.worksList;
    }

    public void setData(List<WorksInfo> data) {
        this.worksList.clear();
        if (!FP.empty(data)) {
            this.worksList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public List<WorksInfo> getBeanList() {
        return this.worksList;
    }

    public int getCount() {
        return this.worksList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getItemViewType(int position) {
        WorksInfo worksInfo = this.worksList.get(position);
        if (worksInfo instanceof RePlayMergeWorksInfo) {
            return 0;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.worksList.size() <= 0) {
            return null;
        }
        WorksInfo worksInfo = this.worksList.get(position);
        if (this.getItemViewType(position) == 0) {
            RePlayMergeWorksInfo rePlayMergeWorksInfo = (RePlayMergeWorksInfo)worksInfo;
            if (convertView == null) {
                convertView = this.initRePlayMergeViewHolder();
            }
            RePlayMergeViewHolder holder = (RePlayMergeViewHolder)convertView.getTag();
            ImageLoader.loadBitmap((RecycleImageView)holder.ivTypeIcon, (String)rePlayMergeWorksInfo.imageUrl, (int)R.drawable.shenqu_stagger_gray_bg);
            int storeReason = Integer.parseInt(rePlayMergeWorksInfo.storeReason);
            String text = null;
            if (storeReason == 1024 || storeReason == 512 || storeReason == 2048) {
                text = "\u6700\u9ad8\u5206 " + rePlayMergeWorksInfo.maxScore;
            }
            holder.tvScore.setText(text);
            holder.tvScore.setTypeface(FontUtils.getTypeFace((Context)this.mContext, (FontUtils.FontType)FontUtils.FontType.DIN_MITTELSCHRIFT_ALTERNATE));
            holder.tvTitle.setText((CharSequence)RePlayMergeWorksInfo.getWorksTypeString((String)rePlayMergeWorksInfo.storeReason));
        } else {
            if (convertView == null) {
                convertView = this.initViewHolder();
            }
            VideoViewHolder holder = (VideoViewHolder)convertView.getTag();
            if (worksInfo instanceof RePlayWorksInfo) {
                RePlayWorksInfo rePlayWorksInfo = (RePlayWorksInfo)worksInfo;
                ImageLoader.loadBitmap((RecycleImageView)holder.videoPic, (String)rePlayWorksInfo.snapshot, (int)R.drawable.shenqu_stagger_gray_bg);
                holder.videoLabelLeft.setVisibility(8);
                holder.videoLabelRight.setVisibility(this.isFormAnchorWorksDetail ? 8 : 0);
                if (rePlayWorksInfo.storeReason != null && rePlayWorksInfo.storeReason.length() > 0) {
                    Integer storeReason = Integer.valueOf(rePlayWorksInfo.storeReason);
                    if (rePlayWorksInfo.storeReason != null && storeReason != null && (0x100 & storeReason) == 256) {
                        holder.videoLabelRight.setText((CharSequence)"\u966a\u6211");
                    } else if (rePlayWorksInfo.storeReason != null && storeReason != null && (0x400 & storeReason) == 1024) {
                        holder.videoLabelRight.setText((CharSequence)"\u5403\u8d27\u8138\u840c");
                    } else if (rePlayWorksInfo.vr.equals("1")) {
                        holder.videoLabelRight.setText((CharSequence)"VR\u56de\u653e");
                    } else {
                        holder.videoLabelRight.setText((CharSequence)"\u56de\u653e");
                    }
                } else if (rePlayWorksInfo.vr.equals("1")) {
                    holder.videoLabelRight.setText((CharSequence)"VR\u56de\u653e");
                } else {
                    holder.videoLabelRight.setText((CharSequence)"\u56de\u653e");
                }
                holder.videoLikeCounts.setText((CharSequence)String.valueOf(rePlayWorksInfo.count));
                holder.titleInfo.setText((CharSequence)rePlayWorksInfo.title);
            } else if (worksInfo instanceof SmallVideoWorksInfo) {
                SmallVideoWorksInfo smallVideoWorksInfo = (SmallVideoWorksInfo)worksInfo;
                ImageLoader.loadBitmap((RecycleImageView)holder.videoPic, (String)smallVideoWorksInfo.snapshoturl, (int)R.drawable.shenqu_stagger_gray_bg);
                if (smallVideoWorksInfo.worksType.equals("1")) {
                    holder.videoLabelLeft.setVisibility(8);
                    holder.videoLabelRight.setText((CharSequence)"\u795e\u66f2");
                    holder.titleInfo.setText((CharSequence)smallVideoWorksInfo.songname);
                } else if (smallVideoWorksInfo.worksType.equals("2")) {
                    int resID = DetailAnchorWorksAdapter.getImageResIdByVideoLayoutType(smallVideoWorksInfo.resourcetype);
                    if (resID != 0) {
                        holder.videoLabelLeft.setVisibility(0);
                        holder.videoLabelLeft.setBackgroundResource(resID);
                    } else {
                        holder.videoLabelLeft.setVisibility(8);
                    }
                    holder.videoLabelRight.setText((CharSequence)"\u5c0f\u89c6\u9891");
                    holder.titleInfo.setText((CharSequence)smallVideoWorksInfo.resdesc);
                } else {
                    holder.videoLabelLeft.setVisibility(8);
                }
                holder.videoLikeCounts.setText((CharSequence)smallVideoWorksInfo.watchcount);
            }
            holder.videoPic.setHeightRatio((double)worksInfo.dpi);
        }
        return convertView;
    }

    private View initViewHolder() {
        View view = View.inflate((Context)this.mContext, (int)R.layout.anchor_works_item_view, null);
        VideoViewHolder holder = new VideoViewHolder();
        holder.videoPic = (DynamicHeightImageView)view.findViewById(R.id.videoPic);
        holder.videoLabelLeft = (ImageView)view.findViewById(R.id.video_label_left);
        holder.videoLabelRight = (TextView)view.findViewById(R.id.video_label_right);
        holder.videoLikeCounts = (TextView)view.findViewById(R.id.video_like_counts);
        LivingClientConstant.setFontTypeForPeople((Context)this.mContext, (TextView)holder.videoLikeCounts);
        holder.titleInfo = (TextView)view.findViewById(R.id.title_info);
        view.setTag((Object)holder);
        return view;
    }

    private View initRePlayMergeViewHolder() {
        View view = View.inflate((Context)this.mContext, (int)R.layout.view_anchor_merge_works, null);
        RePlayMergeViewHolder holder = new RePlayMergeViewHolder();
        holder.ivTypeIcon = (RecycleImageView)view.findViewById(R.id.iv_type_icon);
        holder.tvScore = (TextView)view.findViewById(R.id.tv_score);
        holder.tvTitle = (TextView)view.findViewById(R.id.tv_title);
        view.setTag((Object)holder);
        return view;
    }

    private static class RePlayMergeViewHolder {
        RecycleImageView ivTypeIcon;
        TextView tvScore;
        TextView tvTitle;

        private RePlayMergeViewHolder() {
        }
    }

    private static class VideoViewHolder {
        DynamicHeightImageView videoPic;
        ImageView videoLabelLeft;
        TextView videoLabelRight;
        TextView videoLikeCounts;
        TextView titleInfo;

        private VideoViewHolder() {
        }
    }
}

