/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.view.View;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseFragment;
import com.yy.mobile.ui.common.LoadingFragment;
import com.yy.mobile.ui.common.NetworkErrorFragment;
import com.yy.mobile.ui.common.NoDataFragment;
import com.yy.mobile.ui.common.ReloadFragment;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;

public class StatusUiHelper {
    private static final String TAG = "StatusUiHelper";
    private static final String STATUS_TAG = "STATUS_TAG";

    public static void showActivityLoading(BaseActivity context) {
        StatusUiHelper.showActivityLoading(context, 0, 0);
    }

    public static void showActivityLoading(BaseActivity context, View view) {
        StatusUiHelper.showActivityLoading(context, view, 0, 0);
    }

    public static void showActivityReload(BaseActivity context) {
        StatusUiHelper.showActivityReload(context, 0, 0);
    }

    public static void showActivityNoData(BaseActivity context) {
        StatusUiHelper.showActivityNoData(context, 0, 0);
    }

    public static void showActivityLoading(BaseActivity context, int drawable2, int tips) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View status = context.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable2, (int)tips);
        context.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showActivityLoading(BaseActivity context, View view, int drawable2, int tips) {
    }

    public static void showActivityReload(BaseActivity context, int drawable2, int tips) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View status = context.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable2, (int)tips);
        fragment.setListener(context.getLoadListener());
        context.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showActivityReload(BaseActivity context, View view, int drawable2, int tips) {
    }

    public static void showActivityNoData(BaseActivity context, int drawable2, int tips) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View status = context.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = NoDataFragment.newInstance((int)drawable2, (CharSequence)CoreManager.getContext().getString(tips));
        fragment.setListener(context.getLoadListener());
        context.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showActivityNoData(BaseActivity context, View view, int drawable2, int tips) {
    }

    public static void showActivityNetworkErr(BaseActivity context) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View status = context.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(context.getLoadListener());
        context.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void hideActivityStatus(BaseActivity context) {
        Fragment fragment = context.getSupportFragmentManager().findFragmentByTag(STATUS_TAG);
        if (fragment != null) {
            context.getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    public static void showActivityPageError(BaseActivity context, int tips) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View more = context.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showErrorPage(tips, context.getLoadMoreListener());
    }

    public static void showActivityPageError(BaseActivity context, View view, int tips) {
    }

    public static void showActivityPageLoading(BaseActivity context) {
        if (!StatusUiHelper.checkActivityValid((Activity)context)) {
            return;
        }
        View more = context.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)((Object)((Object)context)).toString(), (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showLoadMore();
    }

    public static boolean checkActivityValid(Activity context) {
        if (context == null) {
            return false;
        }
        if (context.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !context.isDestroyed();
    }

    public static void showFragmentLoading(BaseFragment f) {
        StatusUiHelper.showFragmentLoading(f, 0, 0);
    }

    public static void showFragmentLoading(BaseFragment f, View view) {
        StatusUiHelper.showFragmentLoading(f, view, 0, 0);
    }

    public static void showFragmentReload(BaseFragment f) {
        StatusUiHelper.showFragmentReload(f, 0, 0);
    }

    public static void showFragmentNoData(BaseFragment f) {
        StatusUiHelper.showFragmentNoData(f, 0, 0);
    }

    public static void showFragmentLoading(BaseFragment f, int drawable2, int tips) {
        StatusUiHelper.showFragmentLoading(f, f.getView(), drawable2, tips);
    }

    public static void showFragmentLoading(BaseFragment f, View view, int drawable2, int tips) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (view == null) {
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable2, (int)tips);
        f.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showFragmentReload(BaseFragment f, int drawable2, int tips) {
        StatusUiHelper.showFragmentReload(f, f.getView(), drawable2, tips);
    }

    public static void showFragmentReload(BaseFragment f, View view, int drawable2, int tips) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (view == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)f.toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable2, (int)tips);
        fragment.setListener(f.getLoadListener());
        f.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showFragmentNoData(BaseFragment f, int drawable2, int tips) {
        StatusUiHelper.showFragmentNoData(f, f.getView(), drawable2, tips);
    }

    public static void showFragmentNoData(BaseFragment f, View view, int drawable2, int tips) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (view == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showNoData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status.getId() <= 0) {
            MLog.error((Object)f.toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = NoDataFragment.newInstance((int)drawable2, (CharSequence)CoreManager.getContext().getString(tips));
        fragment.setListener(f.getLoadListener());
        f.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void showFragmentNetworkErr(BaseFragment f) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (f.getView() == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showNetworkErr view is NULL", (Object[])new Object[0]);
            return;
        }
        View view = f.getView().findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((Object)f.toString(), (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(f.getLoadListener());
        f.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public static void hideFragmentStatus(BaseFragment f) {
        Fragment fragment = f.getChildFragmentManager().findFragmentByTag(STATUS_TAG);
        if (fragment != null) {
            f.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        } else {
            MLog.warn((Object)f.toString(), (String)"xuwakao, status fragment is NULL", (Object[])new Object[0]);
        }
    }

    public static void showFragmentPageError(BaseFragment f, int tips) {
        StatusUiHelper.showFragmentPageError(f, f.getView(), tips);
    }

    public static void showFragmentPageError(BaseFragment f, View view, int tips) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (view == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = view.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showErrorPage(tips, f.getLoadMoreListener());
    }

    public static void showFragmentPageLoading(BaseFragment f) {
        if (!StatusUiHelper.checkFragmentValid(f)) {
            return;
        }
        if (f.getView() == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = f.getView().findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)f.toString(), (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showLoadMore();
    }

    public static boolean checkFragmentValid(BaseFragment f) {
        if (f == null) {
            return false;
        }
        return StatusUiHelper.checkActivityValid((Activity)f.getActivity());
    }
}

