/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.shenqu.tanmu;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.yy.mobile.YYMobileApp;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.ui.shenqu.tanmu.GunPowder;
import com.yy.mobile.ui.shenqu.tanmu.IconAnimationView;
import com.yy.mobile.ui.shenqu.tanmu.ShellBuilder;
import com.yy.mobile.ui.shenqu.tanmu.ShellQueue;
import com.yy.mobile.util.DimenConverter;
import java.lang.ref.WeakReference;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class BarrageView
extends IconAnimationView {
    private static final String TAG = "BarrageView";
    private int kShellLineCount = 8;
    private static final int DEFAULT_TOP_MARGIN = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)4.0f);
    private int kTopMargin = DEFAULT_TOP_MARGIN;
    private static final int KShellSpace = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)10.0f);
    private static final float KInValid = -1.0f;
    private static final int KMaxTextLength = 20;
    private int mShellGap;
    private int mPowerTextSize = 18;
    private boolean mAvatarMode = false;
    private boolean mGiftMode = false;
    private ShellQueue mShells = null;
    private ShellBuilder mShellBuilder = null;
    private ShellAnimation mShellCache = null;
    private AnimationListenerImpl[] mAnimationListenerImpl = new AnimationListenerImpl[this.kShellLineCount];
    private AtomicBoolean[] mLockers = new AtomicBoolean[this.kShellLineCount];
    private AtomicBoolean mOnOff = new AtomicBoolean(false);
    private int mShellOrder = 1;
    public static final int SHELL_ORDER_ASC = 1;
    public static final int SHELL_ORDER_DESC = 2;
    private Context mContext;

    public void setCurruntDanmuType(ShellBuilder.DanmuType curruntDanmuType) {
        if (this.mShellBuilder != null) {
            this.mShellBuilder.setCurruntDanmuType(curruntDanmuType);
        }
    }

    public BarrageView(Context context) {
        super(context);
        this.mContext = context;
        this.init(context);
    }

    public BarrageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(context);
    }

    public void setLines(int num) {
        this.kShellLineCount = num;
        this.mAnimationListenerImpl = new AnimationListenerImpl[this.kShellLineCount];
        this.mLockers = new AtomicBoolean[this.kShellLineCount];
        this.init(this.mContext);
    }

    public void setPowerTextSize(int powerTextSize) {
        this.mPowerTextSize = powerTextSize;
    }

    public void setShellGap(int shellGap) {
        this.mShellGap = DimenConverter.dip2px((Context)this.getContext(), (float)shellGap);
    }

    public void setShellOrder(int order) {
        if (order != 1 && order != 2) {
            return;
        }
        this.mShellOrder = order;
    }

    public void setTopMargin(int topMargin) {
        this.kTopMargin = DimenConverter.dip2px((Context)this.getContext(), (float)topMargin);
    }

    public void setAvatarMode(boolean avatarMode) {
        this.mAvatarMode = avatarMode;
    }

    public void setGiftMode(boolean giftMode) {
        this.mGiftMode = giftMode;
    }

    public void clear() {
        if (this.mShells != null) {
            this.mShells.clear();
        }
    }

    public void fire() {
        this.ceaseFire();
        this.mOnOff.set(true);
        this.fireReal();
    }

    public void ceaseFire() {
        this.mOnOff.set(false);
        this.endAllAnimation();
        this.resetLockers();
    }

    @Override
    public IconAnimationView.IconAnimation createAnimation(Bitmap target) {
        return new ShellAnimation(target);
    }

    @Override
    protected void frameDrew(IconAnimationView.IconAnimation animation, IconAnimationView.IconFrameHolds currentFrame) {
        ShellAnimation an;
        if (animation instanceof ShellAnimation && null != (an = (ShellAnimation)animation) && null != an.target && (float)(this.mShellBuilder.getRange() - an.target.getWidth()) > currentFrame.x + (float)KShellSpace) {
            GunPowder ammo;
            if (an.mWholeDraw) {
                return;
            }
            if (null == this.mShellCache && null != (ammo = this.mShells.poll())) {
                ShellBuilder.Shell shell = this.mShellBuilder.gunPowderToShell(ammo);
                this.mShellCache = this.createShellAnimation(shell, -1.0f);
            }
            if (null == this.mShellCache) {
                return;
            }
            for (int i = 0; i < this.mLockers.length; ++i) {
                int n = this.mShellOrder == 1 ? i : this.mLockers.length - i - 1;
                if (this.mLockers[n].get()) continue;
                this.mShellCache.y((this.mShellCache.target.getHeight() + this.mShellGap) * n + this.kTopMargin).setListener(this.mAnimationListenerImpl[n]).start();
                this.mShellCache = null;
                return;
            }
            if (1.0f * (float)an.duration * (float)(an.frameCount - an.frameIndex) / (float)an.frameCount < 1.0f * (float)this.mShellCache.duration * (float)(this.mShellBuilder.getRange() - KShellSpace) / (float)(this.mShellBuilder.getRange() + this.mShellCache.target.getWidth())) {
                int line = this.shellLineIndex((int)((double)currentFrame.y + 0.5), an.target.getHeight());
                this.mShellCache.y(currentFrame.y).setListener(this.mAnimationListenerImpl[line]).start();
                this.mShellCache = null;
                an.mWholeDraw = true;
            }
        }
    }

    private void init(Context context) {
        this.setZOrderOnTop(true);
        this.setUpdateModel(1);
        for (int i = 0; i < this.kShellLineCount; ++i) {
            this.mLockers[i] = new AtomicBoolean(false);
            this.mAnimationListenerImpl[i] = new AnimationListenerImpl();
        }
        this.mShells = new ShellQueue();
        this.mShellBuilder = new ShellBuilder(this.getResources().getDisplayMetrics().widthPixels);
        this.initBarrage();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (null != this.mShellBuilder) {
            this.mShellBuilder.setRange(this.getResources().getDisplayMetrics().widthPixels);
        }
    }

    public void setBarrageViewLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Layout parameters cannot be null");
        }
        super.setLayoutParams(params);
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Layout parameters cannot be null");
        }
        if (null != this.mShellBuilder) {
            GunPowder gunPowder = this.mAvatarMode ? new GunPowder(GunPowder.EXPLOSIVE_LOW, "A", 4000, this.mPowerTextSize, -1, this.mAvatarMode, null) : (this.mGiftMode ? new GunPowder(GunPowder.EXPLOSIVE_LOW, "A", 4000, this.mPowerTextSize, -1, this.mGiftMode, null, null) : new GunPowder(GunPowder.EXPLOSIVE_LOW, "A", 4000, (float)this.mPowerTextSize, -1, (Vector<Bitmap>)null));
            ShellBuilder.Shell shell = this.mShellBuilder.gunPowderToShell(gunPowder);
            params.height = null != shell && null != shell.mBitmap ? (shell.mBitmap.getHeight() + this.mShellGap) * this.kShellLineCount + this.kTopMargin : (45 + this.mShellGap) * this.kShellLineCount + this.kTopMargin;
        }
        super.setLayoutParams(params);
    }

    private int shellLineIndex(int yPos, int shellHeight) {
        return (yPos - this.kTopMargin) / (shellHeight + this.mShellGap);
    }

    private void fireReal() {
        for (int i = 0; i < this.mLockers.length; ++i) {
            int position;
            ShellAnimation an;
            GunPowder ammo;
            int n = this.mShellOrder == 1 ? i : this.mLockers.length - i - 1;
            if (this.mLockers[n].get() || null == (ammo = this.mShells.poll())) continue;
            ShellBuilder.Shell shell = this.mShellBuilder.gunPowderToShell(ammo);
            if (null == shell.mBitmap || null == (an = this.createShellAnimation(shell, position = (shell.mBitmap.getHeight() + this.mShellGap) * n + this.kTopMargin))) continue;
            an.setListener(this.mAnimationListenerImpl[n]).start();
        }
    }

    private ShellAnimation createShellAnimation(ShellBuilder.Shell shell, float y) {
        if (shell.mBitmap == null) {
            return null;
        }
        ShellAnimation an = (ShellAnimation)this.createAnimation(shell.mBitmap);
        if (an == null) {
            return null;
        }
        an.mIsSelf = shell.mIsMySelf;
        an.x(this.mShellBuilder.getRange(), -shell.mBitmap.getWidth()).duration(shell.mDuration);
        if (-1.0f != y) {
            an.y(y);
        }
        return an;
    }

    private void resetLockers() {
        for (AtomicBoolean lock : this.mLockers) {
            lock.set(false);
        }
    }

    private void initBarrage() {
        int orientation = this.getResources().getConfiguration().orientation;
        if (2 == orientation) {
            this.fire();
        }
    }

    public void onPubText(String pubText, int time) {
        this.mShells.offer(new GunPowder(GunPowder.EXPLOSIVE_NORMAL, pubText, time));
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onPubText(String pubText, int time, int backgroundColor, Bitmap avatar) {
        this.mShells.offer(new GunPowder(GunPowder.EXPLOSIVE_NORMAL, pubText, time, this.mPowerTextSize, backgroundColor, avatar));
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onPubText(String pubText, int time, int backgroundColor, Bitmap avatar, int type, boolean isMySelf) {
        if (null == pubText) {
            return;
        }
        if (time <= 0) {
            time = 4000;
        }
        String text = "";
        text = EmoticonFilter.isContainSmile((String)pubText, (Context)YYMobileApp.gContext) ? EmoticonFilter.replaceEmoticonWithLimited2((String)pubText, (int)20, (int)1) : (pubText.length() <= this.getResources().getInteger(R.integer.shenqu_maxtextlength) ? pubText : pubText.substring(0, this.getResources().getInteger(R.integer.shenqu_maxtextlength)) + "...");
        GunPowder ammo = new GunPowder(GunPowder.EXPLOSIVE_NORMAL, text, time, this.mPowerTextSize, backgroundColor, avatar);
        ammo.mTextSize = 10.0f;
        ammo.mType = type;
        if (isMySelf) {
            ammo.mExplosive = GunPowder.EXPLOSIVE_HIGH;
            ammo.mIsMyself = isMySelf;
            ammo.mColor = -30464;
        }
        this.mShells.offer(ammo);
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onPubText(String pubText, int time, int backgroundColor, Bitmap avatar, int type) {
        GunPowder ammo = new GunPowder(GunPowder.EXPLOSIVE_NORMAL, pubText, time, this.mPowerTextSize, backgroundColor, avatar);
        ammo.mType = type;
        this.mShells.offer(ammo);
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onPubText(String pubText, int time, int backgroundColor, Bitmap avatar, Bitmap giftIcon) {
        this.mShells.offer(new GunPowder(GunPowder.EXPLOSIVE_NORMAL, pubText, time, this.mPowerTextSize, backgroundColor, avatar, giftIcon));
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onPubText(String pubText, int time, int color2, Vector<Bitmap> iconList) {
        this.mShells.offer(new GunPowder(GunPowder.EXPLOSIVE_HIGH, pubText, time, (float)this.mPowerTextSize, color2, iconList));
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onTextCommentToSend(String content, int time, boolean isTrueLove, boolean isGod, String count) {
        if (null == content) {
            return;
        }
        if ((time = time / 10 * 1000) <= 0) {
            time = 4000;
        }
        String text = "";
        text = EmoticonFilter.isContainSmile((String)content, (Context)YYMobileApp.gContext) ? EmoticonFilter.replaceEmoticonWithLimited2((String)content, (int)20, (int)2) : (content.length() <= this.getResources().getInteger(R.integer.shenqu_maxtextlength) ? content : content.substring(0, this.getResources().getInteger(R.integer.shenqu_maxtextlength)) + "...");
        GunPowder ammo = new GunPowder(GunPowder.EXPLOSIVE_NORMAL, text, time);
        if (isGod) {
            ammo.mColor = -256;
        }
        if (isTrueLove) {
            ammo.mColor = -30464;
        }
        if (count != null && count.length() > 0) {
            ammo.setCount(count);
        }
        this.mShells.offer(ammo);
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onTextAboutToSend(String content, int time, boolean isTrueLoveUser) {
        if (null == content) {
            return;
        }
        String text = "";
        text = EmoticonFilter.isContainSmile((String)content, (Context)this.getContext()) ? EmoticonFilter.replaceEmoticonWithLimited2((String)content, (int)20, (int)2) : (content.length() <= this.getResources().getInteger(R.integer.shenqu_maxtextlength) ? content : content.substring(0, this.getResources().getInteger(R.integer.shenqu_maxtextlength)) + "...");
        GunPowder ammo = new GunPowder(GunPowder.EXPLOSIVE_HIGH, text, time);
        ammo.mColor = -65536;
        ammo.mIsMyself = true;
        if (isTrueLoveUser) {
            ammo.mColor = -30464;
        }
        this.mShells.offer(ammo);
        if (this.mOnOff.get()) {
            if (this.isThreadStopped()) {
                this.endAllAnimation();
                this.resetLockers();
            }
            this.fireReal();
        }
    }

    public void onBarrageSwitch(Boolean on) {
        if (on.booleanValue()) {
            this.fire();
        } else {
            this.ceaseFire();
        }
    }

    public class AnimationListenerImpl
    implements IconAnimationView.OnAnimationListener {
        private WeakReference<IconAnimationView.IconAnimation> mTarget = null;

        public void setTarget(IconAnimationView.IconAnimation target) {
            IconAnimationView.IconAnimation iconAnimation;
            if (this.mTarget != null && (iconAnimation = (IconAnimationView.IconAnimation)this.mTarget.get()) != null) {
                iconAnimation.setListener(null);
            }
            this.mTarget = new WeakReference<IconAnimationView.IconAnimation>(target);
        }

        @Override
        public void onAnimationEnd(IconAnimationView.IconAnimation animation) {
            IconAnimationView.IconAnimation tg;
            if (null != animation && null != animation.target && !animation.target.isRecycled()) {
                animation.target.recycle();
            }
            if (null == (tg = (IconAnimationView.IconAnimation)this.mTarget.get())) {
                return;
            }
            int line = BarrageView.this.shellLineIndex((int)((double)tg.getY()[0] + 0.5), tg.target.getHeight());
            GunPowder ammo = BarrageView.this.mShells.poll();
            if (null != ammo) {
                ShellBuilder.Shell shell = BarrageView.this.mShellBuilder.gunPowderToShell(ammo);
                ShellAnimation an = BarrageView.this.createShellAnimation(shell, tg.getY()[0]);
                if (null != an) {
                    an.setListener(BarrageView.this.mAnimationListenerImpl[line]).start();
                }
            } else {
                BarrageView.this.mLockers[line].set(false);
            }
        }
    }

    public class ShellAnimation
    extends IconAnimationView.IconAnimation {
        private boolean mWholeDraw;
        private Boolean mIsSelf;
        private String mPower;

        @Override
        public IconAnimationView.IconAnimation setListener(IconAnimationView.OnAnimationListener listener2) {
            IconAnimationView.IconAnimation an = super.setListener(listener2);
            if (listener2 instanceof AnimationListenerImpl) {
                AnimationListenerImpl impl = (AnimationListenerImpl)listener2;
                impl.setTarget(an);
            }
            return an;
        }

        @Override
        public void start() {
            super.start();
            int line = BarrageView.this.shellLineIndex((int)((double)this.getY()[0] + 0.5), this.target.getHeight());
            BarrageView.this.mLockers[line].set(true);
        }

        private ShellAnimation(Bitmap target) {
            super(BarrageView.this, target);
            this.mWholeDraw = false;
            this.mIsSelf = false;
            this.mPower = "";
        }
    }
}

