/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channeltemplate.template.mobilelive.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.yy.mobile.ui.channeltemplate.template.mobilelive.adapter.BaseHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter<T, VH extends BaseHolder>
extends RecyclerView.Adapter<VH> {
    protected List<T> mDataList;
    protected Context mContext;
    private SparseArray<View.OnClickListener> clickListenerSparseArray = new SparseArray();
    private SparseArray<View.OnLongClickListener> longClickListenerSparseArray = new SparseArray();

    public BaseAdapter(Context context) {
        this.mContext = context;
    }

    public void onBindViewHolder(VH holder, int position) {
        this.onBindViewHolder(holder, position, this.mDataList.get(position));
    }

    public void setOnLongClickListener(int id2, View.OnLongClickListener onLongClickListener) {
        this.longClickListenerSparseArray.put(id2, (Object)onLongClickListener);
    }

    public void setOnClickListener(int id2, View.OnClickListener onClickListener2) {
        this.clickListenerSparseArray.put(id2, (Object)onClickListener2);
    }

    protected View.OnClickListener getClickListener(int id2) {
        return (View.OnClickListener)this.clickListenerSparseArray.get(id2);
    }

    public abstract void onBindViewHolder(VH var1, int var2, T var3);

    public void addItem(T item2) {
        if (this.mDataList == null) {
            this.mDataList = new ArrayList<T>();
        }
        this.mDataList.add(item2);
        this.notifyItemChanged(this.mDataList.size() - 1);
    }

    public void addItem(T item2, int position) {
        if (this.mDataList == null) {
            this.mDataList = new ArrayList<T>();
        }
        this.mDataList.add(position, item2);
        this.notifyItemChanged(position);
    }

    public void addAll(List<T> list2) {
        if (this.mDataList == null) {
            this.mDataList = new ArrayList<T>();
        } else {
            this.mDataList.clear();
        }
        this.mDataList.addAll(list2);
        this.notifyDataSetChanged();
    }

    public void removeItem(T item2) {
        if (this.mDataList == null) {
            return;
        }
        int position = this.mDataList.indexOf(item2);
        if (position == -1 || position > this.mDataList.size()) {
            return;
        }
        this.mDataList.remove(item2);
        this.notifyItemRemoved(position);
    }

    public void removeItem(int position) {
        if (this.mDataList == null) {
            return;
        }
        if (position == -1 || position > this.mDataList.size()) {
            return;
        }
        this.mDataList.remove(position);
        this.notifyItemRemoved(position);
    }

    public void clear() {
        if (this.mDataList == null) {
            return;
        }
        this.mDataList.clear();
        this.notifyDataSetChanged();
    }

    public int getTotalCount() {
        return this.mDataList == null ? 0 : this.mDataList.size();
    }

    public T getItem(int position) {
        return this.mDataList.get(position);
    }

    public int getItemCount() {
        return this.mDataList == null ? 0 : this.mDataList.size();
    }
}

