/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.webactivity;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.live.basic.ELAbsBehaviorComponent;
import com.yy.live.basic.module.management.ELModuleContext;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.webview.WebViewController;
import com.yy.mobile.util.log.MLog;

public class WebActivityModule
extends ELAbsBehaviorComponent {
    private Activity mActivity;
    private ELModuleContext elModudleContext;
    protected RelativeLayout view;
    protected WebViewController webViewController;

    @Override
    public void init(ELModuleContext moduleContext, String extend) {
        super.init(moduleContext, extend);
        this.elModudleContext = moduleContext;
        this.mActivity = moduleContext.getComponent().getActivity();
        this.initView();
        this.initController();
    }

    protected void initView() {
        ViewGroup webViewGroup = this.modudleContext.getView(0);
        this.view = new RelativeLayout((Context)this.mContext);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.bottomMargin = DensityUtil.dip2px((Context)this.mContext, (float)7.0f);
        webViewGroup.addView((View)this.view, (ViewGroup.LayoutParams)params);
    }

    protected void initController() {
        this.webViewController = new WebViewController();
        MLog.info((Object)"WebActivityModule", (String)"initController", (Object[])new Object[0]);
        if (this.mComponent != null) {
            this.webViewController.init((Context)this.mContext, this.view, this.mComponent.getChildFragmentManager());
        } else {
            this.webViewController.init((Context)this.mContext, this.view);
        }
    }

    @Override
    public void onOrientationChanges(boolean isLandscape) {
        if (this.webViewController != null) {
            this.webViewController.onOrientationChange(isLandscape);
        }
        this.view.setVisibility(isLandscape ? 8 : 0);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.webViewController != null) {
            this.webViewController.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.webViewController != null) {
            this.webViewController.onPause();
        }
    }

    @Override
    public void onDispose() {
        super.onDispose();
        if (this.webViewController != null) {
            this.webViewController.destory();
        }
    }

    @Override
    public void setComponentVisibility(int context, int visibility) {
        MLog.info((Object)"WebActivityModule", (String)("[setComponentVisibility] context=" + context + ", visibility=" + visibility), (Object[])new Object[0]);
        if (this.webViewController != null && this.mActivity != null && context != 0 && this.mActivity.hashCode() == context) {
            this.webViewController.setComponentVisibility(visibility);
        }
    }
}

