/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.itemanimator;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseItemAnimator<T>
extends SimpleItemAnimator {
    private static final boolean DEBUG = false;
    private static TimeInterpolator sDefaultInterpolator;
    Interpolator mInterpolator;
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();

    public T withInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return (T)((Object)this);
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean changesPending = !this.mPendingChanges.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending || changesPending)) {
            return;
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder);
        }
        this.mPendingRemovals.clear();
        if (movesPending) {
            final ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>();
            moves.addAll(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : moves) {
                        BaseItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                    BaseItemAnimator.this.mMovesList.remove(moves);
                }
            };
            if (removalsPending) {
                View view = ((MoveInfo)moves.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)0L);
            } else {
                mover.run();
            }
        }
        if (changesPending) {
            final ArrayList<ChangeInfo> changes = new ArrayList<ChangeInfo>();
            changes.addAll(this.mPendingChanges);
            this.mChangesList.add(changes);
            this.mPendingChanges.clear();
            Runnable changer = new Runnable(){

                @Override
                public void run() {
                    for (ChangeInfo change : changes) {
                        BaseItemAnimator.this.animateChangeImpl(change);
                    }
                    changes.clear();
                    BaseItemAnimator.this.mChangesList.remove(changes);
                }
            };
            if (removalsPending) {
                RecyclerView.ViewHolder holder = ((ChangeInfo)changes.get((int)0)).oldHolder;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                ViewCompat.postOnAnimationDelayed((View)holder.itemView, (Runnable)changer, (long)this.getRemoveDelay(this.getRemoveDuration(), moveDuration, this.getChangeDuration()));
            } else {
                changer.run();
            }
        }
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>();
            additions.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    for (RecyclerView.ViewHolder holder : additions) {
                        BaseItemAnimator.this.animateAddImpl(holder);
                    }
                    additions.clear();
                    BaseItemAnimator.this.mAdditionsList.remove(additions);
                }
            };
            if (removalsPending || movesPending || changesPending) {
                long removeDuration = removalsPending ? this.getRemoveDuration() : 0L;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                long changeDuration = changesPending ? this.getChangeDuration() : 0L;
                View view = ((RecyclerView.ViewHolder)additions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)this.getAddDelay(removeDuration, moveDuration, changeDuration));
            } else {
                adder.run();
            }
        }
    }

    public long getRemoveDelay(long remove, long move, long change) {
        return remove + Math.max(move, change);
    }

    public long getAddDelay(long remove, long move, long change) {
        return remove + Math.max(move, change);
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        this.mPendingRemovals.add(holder);
        return true;
    }

    private void animateRemoveImpl(final RecyclerView.ViewHolder holder) {
        final ViewPropertyAnimatorCompat animation = this.removeAnimation(holder);
        this.mRemoveAnimations.add(holder);
        animation.setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                BaseItemAnimator.this.dispatchRemoveStarting(holder);
            }

            @Override
            public void onAnimationEnd(View view) {
                animation.setListener(null);
                BaseItemAnimator.this.removeAnimationCleanup(holder);
                BaseItemAnimator.this.dispatchRemoveFinished(holder);
                BaseItemAnimator.this.mRemoveAnimations.remove(holder);
                BaseItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public abstract ViewPropertyAnimatorCompat removeAnimation(RecyclerView.ViewHolder var1);

    public abstract void removeAnimationCleanup(RecyclerView.ViewHolder var1);

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        this.addAnimationPrepare(holder);
        this.mPendingAdditions.add(holder);
        return true;
    }

    private void animateAddImpl(final RecyclerView.ViewHolder holder) {
        final ViewPropertyAnimatorCompat animation = this.addAnimation(holder);
        this.mAddAnimations.add(holder);
        animation.setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                BaseItemAnimator.this.dispatchAddStarting(holder);
            }

            @Override
            public void onAnimationCancel(View view) {
                BaseItemAnimator.this.addAnimationCleanup(holder);
            }

            @Override
            public void onAnimationEnd(View view) {
                animation.setListener(null);
                BaseItemAnimator.this.dispatchAddFinished(holder);
                BaseItemAnimator.this.mAddAnimations.remove(holder);
                BaseItemAnimator.this.dispatchFinishedWhenDone();
                BaseItemAnimator.this.addAnimationCleanup(holder);
            }
        }).start();
    }

    public abstract void addAnimationPrepare(RecyclerView.ViewHolder var1);

    public abstract ViewPropertyAnimatorCompat addAnimation(RecyclerView.ViewHolder var1);

    abstract void addAnimationCleanup(RecyclerView.ViewHolder var1);

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        fromX = (int)((float)fromX + ViewCompat.getTranslationX((View)holder.itemView));
        fromY = (int)((float)fromY + ViewCompat.getTranslationY((View)holder.itemView));
        this.resetAnimation(holder);
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            ViewCompat.setTranslationX((View)view, (float)(-deltaX));
        }
        if (deltaY != 0) {
            ViewCompat.setTranslationY((View)view, (float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (deltaY != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        final ViewPropertyAnimatorCompat animation = ViewCompat.animate((View)view);
        this.mMoveAnimations.add(holder);
        animation.setDuration(this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                BaseItemAnimator.this.dispatchMoveStarting(holder);
            }

            @Override
            public void onAnimationCancel(View view) {
                if (deltaX != 0) {
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                }
                if (deltaY != 0) {
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                animation.setListener(null);
                BaseItemAnimator.this.dispatchMoveFinished(holder);
                BaseItemAnimator.this.mMoveAnimations.remove(holder);
                BaseItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        if (oldHolder == newHolder) {
            return this.animateMove(oldHolder, fromX, fromY, toX, toY);
        }
        this.changeAnimation(oldHolder, newHolder, fromX, fromY, toX, toY);
        this.mPendingChanges.add(new ChangeInfo(oldHolder, newHolder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateChangeImpl(final ChangeInfo changeInfo) {
        View newView;
        final RecyclerView.ViewHolder holder = changeInfo.oldHolder;
        View view = holder == null ? null : holder.itemView;
        final RecyclerView.ViewHolder newHolder = changeInfo.newHolder;
        View view2 = newView = newHolder != null ? newHolder.itemView : null;
        if (view != null) {
            final ViewPropertyAnimatorCompat oldViewAnim = this.changeOldAnimation(holder, changeInfo);
            this.mChangeAnimations.add(changeInfo.oldHolder);
            oldViewAnim.setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                @Override
                public void onAnimationEnd(View view) {
                    oldViewAnim.setListener(null);
                    BaseItemAnimator.this.changeAnimationCleanup(holder);
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (newView != null) {
            final ViewPropertyAnimatorCompat newViewAnimation = this.changeNewAnimation(newHolder);
            this.mChangeAnimations.add(changeInfo.newHolder);
            newViewAnimation.setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                @Override
                public void onAnimationEnd(View view) {
                    newViewAnimation.setListener(null);
                    BaseItemAnimator.this.changeAnimationCleanup(newHolder);
                    ViewCompat.setTranslationX((View)newView, (float)0.0f);
                    ViewCompat.setTranslationY((View)newView, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    public void changeAnimation(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        float prevTranslationX = ViewCompat.getTranslationX((View)oldHolder.itemView);
        float prevTranslationY = ViewCompat.getTranslationY((View)oldHolder.itemView);
        float prevValue = ViewCompat.getAlpha((View)oldHolder.itemView);
        this.resetAnimation(oldHolder);
        int deltaX = (int)((float)(toX - fromX) - prevTranslationX);
        int deltaY = (int)((float)(toY - fromY) - prevTranslationY);
        ViewCompat.setTranslationX((View)oldHolder.itemView, (float)prevTranslationX);
        ViewCompat.setTranslationY((View)oldHolder.itemView, (float)prevTranslationY);
        ViewCompat.setAlpha((View)oldHolder.itemView, (float)prevValue);
        if (newHolder != null) {
            this.resetAnimation(newHolder);
            ViewCompat.setTranslationX((View)newHolder.itemView, (float)(-deltaX));
            ViewCompat.setTranslationY((View)newHolder.itemView, (float)(-deltaY));
            ViewCompat.setAlpha((View)newHolder.itemView, (float)0.0f);
        }
    }

    public abstract ViewPropertyAnimatorCompat changeOldAnimation(RecyclerView.ViewHolder var1, ChangeInfo var2);

    public abstract ViewPropertyAnimatorCompat changeNewAnimation(RecyclerView.ViewHolder var1);

    public abstract void changeAnimationCleanup(RecyclerView.ViewHolder var1);

    private void endChangeAnimation(List<ChangeInfo> infoList, RecyclerView.ViewHolder item2) {
        for (int i = infoList.size() - 1; i >= 0; --i) {
            ChangeInfo changeInfo = infoList.get(i);
            if (!this.endChangeAnimationIfNecessary(changeInfo, item2) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            infoList.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder item2) {
        boolean oldItem = false;
        if (changeInfo.newHolder == item2) {
            changeInfo.newHolder = null;
        } else if (changeInfo.oldHolder == item2) {
            changeInfo.oldHolder = null;
            oldItem = true;
        } else {
            return false;
        }
        this.changeAnimationCleanup(item2);
        ViewCompat.setTranslationX((View)item2.itemView, (float)0.0f);
        ViewCompat.setTranslationY((View)item2.itemView, (float)0.0f);
        this.dispatchChangeFinished(item2, oldItem);
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder item2) {
        int i;
        View view = item2.itemView;
        ViewCompat.animate((View)view).cancel();
        for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
            MoveInfo moveInfo = this.mPendingMoves.get(i);
            if (moveInfo.holder != item2) continue;
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item2);
            this.mPendingMoves.remove(i);
        }
        this.endChangeAnimation(this.mPendingChanges, item2);
        if (this.mPendingRemovals.remove(item2)) {
            this.removeAnimationCleanup(item2);
            this.dispatchRemoveFinished(item2);
        }
        if (this.mPendingAdditions.remove(item2)) {
            this.addAnimationCleanup(item2);
            this.dispatchAddFinished(item2);
        }
        for (i = this.mChangesList.size() - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            this.endChangeAnimation(changes, item2);
            if (!changes.isEmpty()) continue;
            this.mChangesList.remove(i);
        }
        block2: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                if (moveInfo.holder != item2) continue;
                ViewCompat.setTranslationY((View)view, (float)0.0f);
                ViewCompat.setTranslationX((View)view, (float)0.0f);
                this.dispatchMoveFinished(item2);
                moves.remove(j);
                if (!moves.isEmpty()) continue block2;
                this.mMovesList.remove(i);
                continue block2;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            if (!additions.remove(item2)) continue;
            this.addAnimationCleanup(item2);
            this.dispatchAddFinished(item2);
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        if (this.mRemoveAnimations.remove(item2)) {
            // empty if block
        }
        if (this.mAddAnimations.remove(item2)) {
            // empty if block
        }
        if (this.mChangeAnimations.remove(item2)) {
            // empty if block
        }
        if (this.mMoveAnimations.remove(item2)) {
            // empty if block
        }
        this.dispatchFinishedWhenDone();
    }

    public void resetAnimation(RecyclerView.ViewHolder holder) {
        if (sDefaultInterpolator == null) {
            sDefaultInterpolator = new ValueAnimator().getInterpolator();
        }
        holder.itemView.animate().setInterpolator(sDefaultInterpolator);
        this.endAnimation(holder);
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int j;
        int i;
        View view;
        MoveInfo item2;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item2 = this.mPendingMoves.get(i2);
            view = item2.holder.itemView;
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item2.holder);
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item2 = this.mPendingRemovals.get(i2);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item2);
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item2 = this.mPendingAdditions.get(i2);
            view = ((RecyclerView.ViewHolder)item2).itemView;
            this.addAnimationCleanup((RecyclerView.ViewHolder)item2);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item2);
            this.mPendingAdditions.remove(i2);
        }
        count = this.mPendingChanges.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(i2));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (j = count - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                RecyclerView.ViewHolder item3 = moveInfo.holder;
                View view2 = item3.itemView;
                ViewCompat.setTranslationY((View)view2, (float)0.0f);
                ViewCompat.setTranslationX((View)view2, (float)0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (j = count - 1; j >= 0; --j) {
                RecyclerView.ViewHolder item4 = additions.get(j);
                View view3 = item4.itemView;
                this.addAnimationCleanup(item4);
                this.dispatchAddFinished(item4);
                additions.remove(j);
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        listCount = this.mChangesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            count = changes.size();
            for (j = count - 1; j >= 0; --j) {
                this.endChangeAnimationIfNecessary(changes.get(j));
                if (!changes.isEmpty()) continue;
                this.mChangesList.remove(changes);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            ViewCompat.animate((View)viewHolders.get((int)i).itemView).cancel();
        }
    }

    private static class VpaListenerAdapter
    implements ViewPropertyAnimatorListener {
        private VpaListenerAdapter() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    protected static class ChangeInfo {
        public RecyclerView.ViewHolder oldHolder;
        public RecyclerView.ViewHolder newHolder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder) {
            this.oldHolder = oldHolder;
            this.newHolder = newHolder;
        }

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            this(oldHolder, newHolder);
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

