/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectItemLayout
extends YYLinearLayout {
    private static final String TAG = "SelectItemLayout";
    private List<Item> mSubItems;
    private Map<View, Integer> mSubLayoutIndexMap;
    private int mSelectLayoutId;
    private boolean mHasInit = false;
    private ItemClickListener mItemClickListener;

    public SelectItemLayout(Context context) {
        super(context);
    }

    public SelectItemLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SelectItemLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        try {
            int itemsCount = this.getChildCount();
            this.mSubItems = new ArrayList<Item>(itemsCount);
            this.mSubLayoutIndexMap = new HashMap<View, Integer>();
            for (int i = 0; i < itemsCount; ++i) {
                final View subLayout = this.getChildAt(i);
                Item item2 = new Item();
                if (subLayout instanceof ViewGroup) {
                    for (int j = 0; j < ((ViewGroup)subLayout).getChildCount(); ++j) {
                        View child = ((ViewGroup)subLayout).getChildAt(j);
                        item2.addView(child);
                    }
                } else {
                    item2.addView(subLayout);
                }
                item2.layoutId = subLayout.getId();
                this.mSubItems.add(item2);
                this.mSubLayoutIndexMap.put(subLayout, subLayout.getId());
                subLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SelectItemLayout.this.setSelect(subLayout);
                        if (SelectItemLayout.this.mItemClickListener != null) {
                            SelectItemLayout.this.mItemClickListener.onItemClicked((Integer)SelectItemLayout.this.mSubLayoutIndexMap.get(subLayout));
                        }
                    }
                });
            }
            this.mHasInit = true;
        }
        catch (Exception e) {
            this.mHasInit = false;
            MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHasInit = false;
    }

    public void setItemClickListener(ItemClickListener listener2) {
        this.mItemClickListener = listener2;
    }

    public void setAllItemUnselected() {
        if (!this.mHasInit) {
            MLog.info((Object)TAG, (String)"mHasInit is false", (Object[])new Object[0]);
            return;
        }
        this.mSelectLayoutId = 0;
        for (int i = 0; i < this.mSubItems.size(); ++i) {
            Item item2 = this.mSubItems.get(i);
            for (int k = 0; k < item2.views.size(); ++k) {
                item2.views.get(k).setSelected(false);
            }
        }
    }

    public void setSelect(View subLayout) {
        if (!this.mHasInit) {
            MLog.info((Object)TAG, (String)"mHasInit is false", (Object[])new Object[0]);
            return;
        }
        Integer layoutId = this.mSubLayoutIndexMap.get(subLayout);
        if (layoutId == null || layoutId == -1) {
            MLog.error((Object)TAG, (String)"setSelected subLayout layoutId is invalid, layoutId:%d", (Object[])new Object[]{layoutId});
            return;
        }
        this.mSelectLayoutId = layoutId;
        for (int i = 0; i < this.mSubItems.size(); ++i) {
            int k;
            Item item2 = this.mSubItems.get(i);
            if (item2.layoutId == layoutId) {
                for (k = 0; k < item2.views.size(); ++k) {
                    item2.views.get(k).setSelected(true);
                }
                continue;
            }
            for (k = 0; k < item2.views.size(); ++k) {
                item2.views.get(k).setSelected(false);
            }
        }
    }

    public void setSelect(int layoutId) {
        if (!this.mHasInit) {
            MLog.info((Object)TAG, (String)"mHasInit is false", (Object[])new Object[0]);
            return;
        }
        if (layoutId == -1) {
            MLog.error((Object)TAG, (String)"setSelect layoutId is View.NO_ID", (Object[])new Object[0]);
            return;
        }
        this.mSelectLayoutId = layoutId;
        for (int i = 0; i < this.mSubItems.size(); ++i) {
            int k;
            Item item2 = this.mSubItems.get(i);
            if (item2.layoutId == layoutId) {
                for (k = 0; k < item2.views.size(); ++k) {
                    item2.views.get(k).setSelected(true);
                }
                continue;
            }
            for (k = 0; k < item2.views.size(); ++k) {
                item2.views.get(k).setSelected(false);
            }
        }
    }

    public int getSelectIndex() {
        return this.mSelectLayoutId;
    }

    private static class Item {
        int layoutId;
        ArrayList<View> views = new ArrayList();

        Item() {
        }

        public void addView(View view) {
            if (view != null) {
                this.views.add(view);
            }
        }
    }

    public static interface ItemClickListener {
        public void onItemClicked(int var1);
    }
}

