/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;

public class RoundedRelativeLayout
extends YYRelativeLayout {
    private Path mPath;
    private float cornerRadius;
    private int width;
    private int height;

    public RoundedRelativeLayout(Context context) {
        super(context);
        this.init();
    }

    public RoundedRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RoundedRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        this.cornerRadius = this.dpToPx(this.getContext(), 10);
    }

    private void createPath() {
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        this.mPath.reset();
        this.mPath.moveTo(this.cornerRadius, 0.0f);
        this.mPath.lineTo((float)this.width - this.cornerRadius, 0.0f);
        this.mPath.arcTo(new RectF((float)this.width - 2.0f * this.cornerRadius, 0.0f, (float)this.width, 2.0f * this.cornerRadius), 270.0f, 90.0f);
        this.mPath.lineTo((float)this.width, (float)this.height - this.cornerRadius);
        this.mPath.arcTo(new RectF((float)this.width - 2.0f * this.cornerRadius, (float)this.height - 2.0f * this.cornerRadius, (float)this.width, (float)this.height), 0.0f, 90.0f);
        this.mPath.lineTo(this.cornerRadius, (float)this.height);
        this.mPath.arcTo(new RectF(0.0f, (float)this.height - 2.0f * this.cornerRadius, 2.0f * this.cornerRadius, (float)this.height), 90.0f, 90.0f);
        this.mPath.lineTo(0.0f, this.cornerRadius);
        this.mPath.arcTo(new RectF(0.0f, 0.0f, 2.0f * this.cornerRadius, 2.0f * this.cornerRadius), 180.0f, 90.0f);
        this.mPath.close();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            this.width = this.getMeasuredWidth();
            this.height = this.getMeasuredHeight();
            this.createPath();
        }
    }

    public void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.clipPath(this.mPath);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    public void setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    private float dpToPx(Context context, int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }
}

