/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.vacancy.ui;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import com.yy.mobile.ui.vacancy.ui.AutoScrollViewPagerHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper;", "", "()V", "handler", "Landroid/os/Handler;", "observer", "Landroid/arch/lifecycle/LifecycleObserver;", "autoScroll", "", "owner", "Landroid/arch/lifecycle/LifecycleOwner;", "vp", "Landroid/support/v4/view/ViewPager;", "interval", "", "strategy", "Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$AutoScrollStrategy;", "onDestroy", "AutoScrollStrategy", "LoopStrategy", "PageChangeListener", "ReverseStrategy", "pluginunionlive_release"})
public final class AutoScrollViewPagerHelper {
    private static final Handler handler;
    private static LifecycleObserver observer;
    public static final AutoScrollViewPagerHelper INSTANCE;

    public final void autoScroll(@NotNull LifecycleOwner owner, @NotNull ViewPager vp, long interval, @NotNull AutoScrollStrategy strategy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)vp, (String)"vp");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        Runnable autoScrollRunnable2 = new Runnable(vp, strategy, interval){
            final /* synthetic */ ViewPager $vp;
            final /* synthetic */ AutoScrollStrategy $strategy;
            final /* synthetic */ long $interval;

            public void run() {
                int size;
                int curIdx = this.$vp.getCurrentItem();
                PagerAdapter pagerAdapter = this.$vp.getAdapter();
                int n = size = pagerAdapter != null ? pagerAdapter.getCount() : 0;
                if (size > 1) {
                    int nextIdx = this.$strategy.nextIndex(curIdx, size);
                    this.$vp.setCurrentItem(nextIdx, true);
                    AutoScrollViewPagerHelper.access$getHandler$p(AutoScrollViewPagerHelper.INSTANCE).postDelayed((Runnable)this, this.$interval);
                }
            }
            {
                this.$vp = $captured_local_variable$0;
                this.$strategy = $captured_local_variable$1;
                this.$interval = $captured_local_variable$2;
            }
        };
        PageChangeListener listener2 = new PageChangeListener(vp, autoScrollRunnable2, interval);
        vp.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)listener2);
        vp.addOnPageChangeListener((ViewPager.OnPageChangeListener)listener2);
        observer = new LifecycleObserver(autoScrollRunnable2, interval){
            final /* synthetic */ autoScroll.autoScrollRunnable.1 $autoScrollRunnable;
            final /* synthetic */ long $interval;

            @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
            public final void onFragmentDestroy() {
                AutoScrollViewPagerHelper.access$getHandler$p(AutoScrollViewPagerHelper.INSTANCE).removeCallbacks((Runnable)this.$autoScrollRunnable);
            }

            @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
            public final void onFragmentStart() {
                AutoScrollViewPagerHelper.access$getHandler$p(AutoScrollViewPagerHelper.INSTANCE).removeCallbacks((Runnable)this.$autoScrollRunnable);
                AutoScrollViewPagerHelper.access$getHandler$p(AutoScrollViewPagerHelper.INSTANCE).postDelayed((Runnable)this.$autoScrollRunnable, this.$interval);
            }
            {
                this.$autoScrollRunnable = $captured_local_variable$0;
                this.$interval = $captured_local_variable$1;
            }
        };
        Lifecycle lifecycle = owner.getLifecycle();
        LifecycleObserver lifecycleObserver = observer;
        if (lifecycleObserver == null) {
            Intrinsics.throwNpe();
        }
        lifecycle.addObserver(lifecycleObserver);
        PagerAdapter pagerAdapter = vp.getAdapter();
        if ((pagerAdapter != null ? pagerAdapter.getCount() : 0) > 1) {
            handler.postDelayed(autoScrollRunnable2, interval);
        }
    }

    public static /* synthetic */ void autoScroll$default(AutoScrollViewPagerHelper autoScrollViewPagerHelper, LifecycleOwner lifecycleOwner, ViewPager viewPager, long l, AutoScrollStrategy autoScrollStrategy, int n, Object object) {
        if ((n & 8) != 0) {
            autoScrollStrategy = new LoopStrategy();
        }
        autoScrollViewPagerHelper.autoScroll(lifecycleOwner, viewPager, l, autoScrollStrategy);
    }

    public final void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        LifecycleObserver lifecycleObserver = observer;
        if (lifecycleObserver != null) {
            LifecycleObserver lifecycleObserver2 = lifecycleObserver;
            boolean bl = false;
            boolean bl2 = false;
            LifecycleObserver it = lifecycleObserver2;
            boolean bl3 = false;
            owner.getLifecycle().removeObserver(it);
        }
        observer = null;
    }

    private AutoScrollViewPagerHelper() {
    }

    static {
        AutoScrollViewPagerHelper autoScrollViewPagerHelper;
        INSTANCE = autoScrollViewPagerHelper = new AutoScrollViewPagerHelper();
        handler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ Handler access$getHandler$p(AutoScrollViewPagerHelper $this) {
        AutoScrollViewPagerHelper autoScrollViewPagerHelper = $this;
        return handler;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\u0006"}, d2={"Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$AutoScrollStrategy;", "", "nextIndex", "", "curIdx", "size", "pluginunionlive_release"})
    public static interface AutoScrollStrategy {
        public int nextIndex(int var1, int var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$LoopStrategy;", "Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$AutoScrollStrategy;", "()V", "nextIndex", "", "curIdx", "size", "pluginunionlive_release"})
    public static final class LoopStrategy
    implements AutoScrollStrategy {
        @Override
        public int nextIndex(int curIdx, int size) {
            return (curIdx + 1) % size;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$ReverseStrategy;", "Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$AutoScrollStrategy;", "()V", "direction", "", "nextIndex", "curIdx", "size", "pluginunionlive_release"})
    public static final class ReverseStrategy
    implements AutoScrollStrategy {
        private int direction = 1;

        @Override
        public int nextIndex(int curIdx, int size) {
            int n;
            int nextIdx = curIdx + this.direction;
            int n2 = nextIdx;
            if (0 <= n2 && size > n2) {
                n = nextIdx;
            } else {
                this.direction *= -1;
                n = curIdx + this.direction;
            }
            return n;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/yy/mobile/ui/vacancy/ui/AutoScrollViewPagerHelper$PageChangeListener;", "Landroid/support/v4/view/ViewPager$OnPageChangeListener;", "Landroid/support/v4/view/ViewPager$OnAdapterChangeListener;", "vp", "Landroid/support/v4/view/ViewPager;", "autoScrollRunnable", "Ljava/lang/Runnable;", "interval", "", "(Landroid/support/v4/view/ViewPager;Ljava/lang/Runnable;J)V", "getAutoScrollRunnable", "()Ljava/lang/Runnable;", "getInterval", "()J", "getVp", "()Landroid/support/v4/view/ViewPager;", "onAdapterChanged", "", "viewPager", "oldAdapter", "Landroid/support/v4/view/PagerAdapter;", "newAdapter", "onPageScrollStateChanged", "state", "", "onPageScrolled", "position", "positionOffset", "", "positionOffsetPixels", "onPageSelected", "pluginunionlive_release"})
    private static final class PageChangeListener
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        @NotNull
        private final ViewPager vp;
        @NotNull
        private final Runnable autoScrollRunnable;
        private final long interval;

        public void onPageScrollStateChanged(int state) {
            AutoScrollViewPagerHelper.access$getHandler$p(INSTANCE).removeCallbacks(this.autoScrollRunnable);
            if (state == 0) {
                PagerAdapter pagerAdapter = this.vp.getAdapter();
                if ((pagerAdapter != null ? pagerAdapter.getCount() : 0) > 1) {
                    AutoScrollViewPagerHelper.access$getHandler$p(INSTANCE).postDelayed(this.autoScrollRunnable, this.interval);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onAdapterChanged(@NotNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            Intrinsics.checkParameterIsNotNull((Object)viewPager, (String)"viewPager");
            if (newAdapter == null) {
                this.vp.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this);
                AutoScrollViewPagerHelper.access$getHandler$p(INSTANCE).removeCallbacks(this.autoScrollRunnable);
            } else {
                AutoScrollViewPagerHelper.access$getHandler$p(INSTANCE).removeCallbacks(this.autoScrollRunnable);
                AutoScrollViewPagerHelper.access$getHandler$p(INSTANCE).postDelayed(this.autoScrollRunnable, this.interval);
            }
        }

        @NotNull
        public final ViewPager getVp() {
            return this.vp;
        }

        @NotNull
        public final Runnable getAutoScrollRunnable() {
            return this.autoScrollRunnable;
        }

        public final long getInterval() {
            return this.interval;
        }

        public PageChangeListener(@NotNull ViewPager vp, @NotNull Runnable autoScrollRunnable2, long interval) {
            Intrinsics.checkParameterIsNotNull((Object)vp, (String)"vp");
            Intrinsics.checkParameterIsNotNull((Object)autoScrollRunnable2, (String)"autoScrollRunnable");
            this.vp = vp;
            this.autoScrollRunnable = autoScrollRunnable2;
            this.interval = interval;
        }
    }
}

