/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.Window;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Method;

public class NavigationBarUtils {
    public static final String TAG = "NavigationBarUtils";

    public static boolean checkDeviceHasNavigationBar(Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("checkDeviceHasNavigationBar: e=" + e), (Object[])new Object[0]);
        }
        return hasNavigationBar;
    }

    public static void solveNavigationBar(Window window) {
        MLog.info((Object)TAG, (String)"solveNavigationBar:", (Object[])new Object[0]);
        int uiOptions = 1798;
        uiOptions = Build.VERSION.SDK_INT >= 19 ? (uiOptions |= 0x1000) : (uiOptions |= 1);
        window.getDecorView().setSystemUiVisibility(uiOptions);
    }
}

