/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.yy.mobile.plugin.pluginunionlive.R;

public class ItemClickSupport {
    private final RecyclerView mRecyclerView;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (ItemClickSupport.this.mOnItemClickListener != null) {
                RecyclerView.ViewHolder holder = ItemClickSupport.this.mRecyclerView.getChildViewHolder(v);
                ItemClickSupport.this.mOnItemClickListener.onItemClicked(ItemClickSupport.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
        }
    };
    private View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (ItemClickSupport.this.mOnItemLongClickListener != null) {
                RecyclerView.ViewHolder holder = ItemClickSupport.this.mRecyclerView.getChildViewHolder(v);
                return ItemClickSupport.this.mOnItemLongClickListener.onItemLongClicked(ItemClickSupport.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
            return false;
        }
    };
    private RecyclerView.OnChildAttachStateChangeListener mAttachListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (ItemClickSupport.this.mOnItemClickListener != null) {
                view.setOnClickListener(ItemClickSupport.this.mOnClickListener);
            }
            if (ItemClickSupport.this.mOnItemLongClickListener != null) {
                view.setOnLongClickListener(ItemClickSupport.this.mOnLongClickListener);
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
        }
    };

    private ItemClickSupport(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setTag(R.id.item_click_support, (Object)this);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mAttachListener);
    }

    public static ItemClickSupport addTo(RecyclerView view) {
        ItemClickSupport support = (ItemClickSupport)view.getTag(R.id.item_click_support);
        if (support == null) {
            support = new ItemClickSupport(view);
        }
        return support;
    }

    public static ItemClickSupport removeFrom(RecyclerView view) {
        ItemClickSupport support = (ItemClickSupport)view.getTag(R.id.item_click_support);
        if (support != null) {
            support.detach(view);
        }
        return support;
    }

    public ItemClickSupport setOnItemClickListener(OnItemClickListener listener2) {
        this.mOnItemClickListener = listener2;
        return this;
    }

    public ItemClickSupport setOnItemLongClickListener(OnItemLongClickListener listener2) {
        this.mOnItemLongClickListener = listener2;
        return this;
    }

    private void detach(RecyclerView view) {
        view.removeOnChildAttachStateChangeListener(this.mAttachListener);
        view.setTag(R.id.item_click_support, null);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClicked(RecyclerView var1, int var2, View var3);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(RecyclerView var1, int var2, View var3);
    }
}

