/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ViewFlipper;
import com.duowan.mobile.entlive.events.IChannelTurntableClient_onLottery_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onFastTimes_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onJsCallCloseWeb_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onLeaveTurnTable_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTablePropsList_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTableWinBroadcast_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onUpdateLottery_EventArgs;
import com.yy.mobile.plugin.main.events.IConnectivityClient_onConnectivityChange_EventArgs;
import com.yy.mobile.plugin.main.events.IPayClient_onQueryRedDiamondAmount_EventArgs;
import com.yy.mobile.plugin.main.events.IShortCutPayClient_refreshWebByShortCutPay_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.turntable.IFillterPage;
import com.yy.mobile.ui.turntable.ITurnTableCommon;
import com.yy.mobile.ui.turntable.TurnTableAttachedActivity;
import com.yy.mobile.ui.turntable.TurnTableCommonUi;
import com.yy.mobile.ui.turntable.TurnTableComponent$$EventBinder;
import com.yy.mobile.ui.turntable.TurntableLotteryView;
import com.yy.mobile.ui.turntable.TurntableView;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.core.TurnTableManager;
import com.yy.mobile.ui.turntable.info.TurnTableEntryInfo;
import com.yy.mobile.ui.turntable.info.TurnTableLotteryResult;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.utils.IConnectivityCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TurnTableComponent
extends BasePopupComponent
implements EventCompat {
    public static final int FROM_LIVING_PAGE = 0;
    public static final int FROM_TURNTABLE_PAGE = 1;
    private static final int SWIPE_MIN_DISTANCE = 120;
    private static final int SWIPE_THRESHOLD_VELOCITY = 200;
    public int fromPage;
    public int pageIndex;
    public String filePath;
    private TurnTableCommonUi commonUi;
    private ITurnTableCommon turnTableCommon;
    private View toolLayout;
    private View leftArrow;
    private View rightArrow;
    private ViewFlipper flipper;
    private GestureDetector detector;
    private int flipperIndex = 0;
    private TranslateAnimation leftInAnim;
    private TranslateAnimation leftOutAnim;
    private TranslateAnimation rightInAnim;
    private TranslateAnimation rightOutAnim;
    private ArrayList<IFillterPage> pages = new ArrayList();
    private TurntableView turntableView;
    private TurntableLotteryView turntableLotteryView;
    private IChannelTurntableCore turntableCore;
    private DialogLinkManager dialogLinkManager;
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!TurnTableComponent.this.checkActivityValid()) {
                return;
            }
            if (null != TurnTableComponent.this.turntableView) {
                TurnTableComponent.this.turntableView.hidePrizePanelTips();
            }
            if (null != TurnTableComponent.this.turntableLotteryView) {
                TurnTableComponent.this.turntableLotteryView.hidePrizePanelTips();
            }
            if (null != TurnTableComponent.this.commonUi) {
                TurnTableComponent.this.commonUi.hideAllTips();
            }
        }
    };
    private View.OnClickListener arrowClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == TurnTableComponent.this.leftArrow) {
                TurnTableComponent.this.showPrePage();
            } else if (v == TurnTableComponent.this.rightArrow) {
                TurnTableComponent.this.showNextPage();
            }
        }
    };
    private EventBinder mTurnTableComponentSniperEventBinder;

    public static void popuComponent(FragmentActivity activity, String filePath, int fromPage, int pageIndex) {
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putInt("fromPage", fromPage);
        bundle.putInt("pageIndex", pageIndex);
        ViewUtils.showPopupComponent((Activity)activity, (FragmentManager)activity.getSupportFragmentManager(), (Bundle)bundle, TurnTableComponent.class, (String)"turntablecomponent");
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.getActivity() instanceof TurnTableAttachedActivity) {
            this.getActivity().finish();
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.left_bottom_popup_scale_menu_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().setGravity(80);
        if (this.getContext().getResources().getConfiguration().orientation == 2) {
            dialog.getWindow().setLayout(-1, -1);
        } else {
            dialog.getWindow().setLayout(-1, (int)ResolutionUtils.convertDpToPixel((float)360.0f, (Context)this.getActivity()));
        }
        dialog.getWindow().clearFlags(2);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
        this.dialogLinkManager = new DialogLinkManager(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.turntable_fragment, container, false);
        this.initView(view);
        return view;
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.turntableView != null) {
            this.turntableView.onOrientationChanged(isLandscape);
        }
    }

    protected Handler getHandler() {
        return super.getHandler();
    }

    public boolean checkActivityEnable() {
        return this.checkActivityValid();
    }

    public void onDestroy() {
        if (null != this.commonUi) {
            this.commonUi.onDestroy();
        }
        this.dialogLinkManager.dismissDialog();
        if (this.turntableView != null) {
            this.turntableView.onDestroy();
            this.turntableView = null;
        }
        if (null != this.turntableLotteryView) {
            this.turntableLotteryView.onDestroy();
            this.turntableLotteryView = null;
        }
        if (this.checkActivityValid()) {
            this.dismissAllowingStateLoss();
        }
        super.onDestroy();
    }

    private void initView(View rootView) {
        Bundle bundle = this.getArguments();
        if (null != bundle) {
            this.filePath = bundle.getString("filePath", "");
            this.fromPage = bundle.getInt("fromPage", 0);
            this.pageIndex = bundle.getInt("pageIndex", 0);
        }
        this.toolLayout = rootView.findViewById(R.id.turntable_tool_layout);
        this.commonUi = new TurnTableCommonUi();
        this.commonUi.init(this, (ViewGroup)rootView, this.clickListener);
        this.leftArrow = rootView.findViewById(R.id.left_arrow);
        this.rightArrow = rootView.findViewById(R.id.right_arrow);
        this.leftArrow.setOnClickListener(this.arrowClickListener);
        this.rightArrow.setOnClickListener(this.arrowClickListener);
        this.flipper = (ViewFlipper)rootView.findViewById(R.id.turntable_flipper);
        this.detector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                if (null != TurnTableComponent.this.clickListener) {
                    TurnTableComponent.this.clickListener.onClick(null);
                }
                return super.onSingleTapUp(e);
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                try {
                    if (null != TurnTableComponent.this.turntableView && TurnTableComponent.this.turntableView.getIsTurning() || null != TurnTableComponent.this.turntableLotteryView && TurnTableComponent.this.turntableLotteryView.getIsTurning() || TurnTableManager.turnTableEntryInfo.pageCfgs.isEmpty() || TurnTableManager.turnTableEntryInfo.lotteryCfgs.isEmpty()) {
                        return true;
                    }
                    if (e1.getX() - e2.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                        TurnTableComponent.this.showNextPage();
                        return true;
                    }
                    if (e2.getX() - e1.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                        TurnTableComponent.this.showPrePage();
                        return true;
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)"TurnTableComponent", (String)"onFling error", (Object[])new Object[0]);
                }
                return false;
            }
        });
        this.flipper.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (null != TurnTableComponent.this.toolLayout) {
                    TurnTableComponent.this.toolLayout.dispatchTouchEvent(event);
                }
                TurnTableComponent.this.detector.onTouchEvent(event);
                return true;
            }
        });
        this.turnTableCommon = new ITurnTableCommon(){

            public void showURl(String url) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.showURl(url);
                }
            }

            public void onTurnState(boolean isTurn) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.onTurnState(isTurn);
                }
            }

            public void onLotteryEnd(int costType) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.onLotteryEnd(costType);
                }
            }

            public void showCommonToast(String text) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.showCommonToast(text);
                }
            }

            public void hideCommonToast() {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.hideCommonToast();
                }
            }

            public void hideAllTips() {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.hideAllTips();
                }
            }

            public void onCfgsSelected(int cfgIndex) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.onCfgsSelected(cfgIndex);
                }
            }

            public void onPageSelected(int consType, int pageIndex, ArrayList<TurnTableEntryInfo.PageCfg> cfgs) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.onPageSelected(consType, pageIndex, cfgs);
                }
            }

            public void delDiamodNum(long diamodNum) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.delDiamodNum(diamodNum);
                }
            }

            public void delLotteryCount(int count) {
                if (null != TurnTableComponent.this.commonUi) {
                    TurnTableComponent.this.commonUi.delLotteryCount(count);
                }
            }

            public boolean checkActivityValid() {
                return TurnTableComponent.this.checkActivityEnable();
            }
        };
        this.initFlipper();
    }

    private void initFlipper() {
        this.turntableView = new TurntableView((Context)this.getActivity());
        this.turntableView.setClickCallback(this.clickListener);
        this.turntableView.initView();
        this.turntableView.setTurnTableCommon(this.turnTableCommon);
        this.turntableLotteryView = new TurntableLotteryView((Context)this.getActivity());
        this.turntableLotteryView.setClickCallback(this.clickListener);
        int barIndex = 0;
        if (TurnTableManager.turnTableEntryInfo != null && TurnTableManager.turnTableEntryInfo.coupon_qty >= 10) {
            barIndex = 2;
        }
        this.turntableLotteryView.initView(barIndex);
        this.turntableLotteryView.setTurnTableCommon(this.turnTableCommon);
        this.pages.add((IFillterPage)this.turntableLotteryView);
        this.pages.add((IFillterPage)this.turntableView);
        this.flipper.addView((View)this.turntableLotteryView);
        this.flipper.addView((View)this.turntableView);
        this.turntableCore = (IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class);
        if (null != TurnTableManager.turnTableEntryInfo && FP.empty((Collection)TurnTableManager.turnTableEntryInfo.pageCfgs)) {
            this.pages.get(0).onSelected(0, true);
            this.leftArrow.setEnabled(false);
            this.rightArrow.setEnabled(false);
        } else if (null != TurnTableManager.turnTableEntryInfo && FP.empty((Collection)TurnTableManager.turnTableEntryInfo.lotteryCfgs)) {
            ++this.flipperIndex;
            this.pages.get(1).onSelected(1, true);
            this.flipper.showNext();
            this.rightArrow.setEnabled(false);
            this.leftArrow.setEnabled(false);
        } else if (this.pageIndex == 1) {
            this.pages.get(0).onSelected(0, true);
            this.leftArrow.setEnabled(false);
        } else if (this.pageIndex == 0) {
            ++this.flipperIndex;
            this.pages.get(1).onSelected(1, true);
            this.rightArrow.setEnabled(false);
            this.flipper.showNext();
        }
    }

    private void showNextPage() {
        if (!this.checkActivityValid() || null == this.flipper || this.flipperIndex + 1 >= this.pages.size()) {
            return;
        }
        if (this.flipperIndex < 1) {
            if (null == this.leftOutAnim) {
                this.leftOutAnim = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
                this.leftOutAnim.setDuration(500L);
            }
            if (null == this.rightInAnim) {
                this.rightInAnim = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                this.rightInAnim.setDuration(500L);
            }
            ++this.flipperIndex;
            this.flipper.setInAnimation((Animation)this.rightInAnim);
            this.flipper.setOutAnimation((Animation)this.leftOutAnim);
            this.flipper.showNext();
            this.pages.get(this.flipperIndex).onSelected(this.flipperIndex, true);
        }
        if (this.flipperIndex == 1) {
            this.leftArrow.setEnabled(true);
            this.rightArrow.setEnabled(false);
        }
    }

    private void showPrePage() {
        if (!this.checkActivityValid() || null == this.flipper || this.flipperIndex - 1 >= this.pages.size()) {
            return;
        }
        if (this.flipperIndex > 0) {
            if (null == this.rightOutAnim) {
                this.rightOutAnim = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
                this.rightOutAnim.setDuration(500L);
            }
            if (null == this.leftInAnim) {
                this.leftInAnim = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                this.leftInAnim.setDuration(500L);
            }
            --this.flipperIndex;
            this.flipper.setInAnimation((Animation)this.leftInAnim);
            this.flipper.setOutAnimation((Animation)this.rightOutAnim);
            this.flipper.showPrevious();
            this.pages.get(this.flipperIndex).onSelected(this.flipperIndex, true);
        }
        if (this.flipperIndex == 0) {
            this.leftArrow.setEnabled(false);
            this.rightArrow.setEnabled(true);
        }
    }

    @BusEvent
    public void onQueryTurnTablePropsList(IChannelTurntableClient_onQueryTurnTablePropsList_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        this.onQueryTurnTablePropsList(result, extendInfo, otherList);
    }

    public void onQueryTurnTablePropsList(long result, Map<String, String> extendInfo, List<Map<String, String>> otherList) {
        if (result == 0L && null != this.commonUi) {
            this.commonUi.onQueryTurnTablePropsList(result, extendInfo, otherList);
        }
    }

    @BusEvent(sync=true)
    public void onFastTimes(IChannelTurntableClient_onFastTimes_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        int fastTimes = busEventArgs.getFastTimes();
        int moneyNum = busEventArgs.getMoneyNum();
        int costType = busEventArgs.getCostType();
        this.onFastTimes(result, fastTimes, moneyNum, costType);
    }

    public void onFastTimes(int result, int fastTimes, int moneyNum, int costType) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"hsj", (String)("Turntable fast_times=" + fastTimes + ", money_num=" + moneyNum + ", costType=" + costType + ", resutl=" + result), (Object[])new Object[0]);
        }
        if (result == 0) {
            if (this.turntableCore != null) {
                this.turntableCore.queryLottery();
            }
            if (20 == costType) {
                TurnTableManager.turnTableEntryInfo.fast_times = fastTimes;
                TurnTableManager.turnTableEntryInfo.money_num = moneyNum;
            }
        } else {
            if (null != this.commonUi) {
                this.commonUi.showCommonToast("\u62bd\u5956\u5931\u8d25\uff0c\u518d\u8bd5\u8bd5\u5427\uff01");
            }
            if (20 == costType && null != this.turntableView) {
                this.turntableView.onFastTimes(result, fastTimes, moneyNum, costType);
            } else if (10 == costType && null != this.turntableLotteryView) {
                this.turntableLotteryView.onFastTimes(result, fastTimes, moneyNum, costType);
            }
            if (this.flipperIndex < this.pages.size()) {
                IFillterPage page = this.pages.get(this.flipperIndex);
                if (page instanceof TurntableView && null != this.turntableView) {
                    this.turntableView.onFastTimes(result, fastTimes, moneyNum, costType);
                } else if (page instanceof TurntableLotteryView && null != this.turntableLotteryView) {
                    this.turntableLotteryView.onFastTimes(result, fastTimes, moneyNum, costType);
                }
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onLottery(IChannelTurntableClient_onLottery_EventArgs busEventArgs) {
        TurnTableLotteryResult lotteryResult = busEventArgs.mResult;
        this.onLottery(lotteryResult);
    }

    public void onLottery(TurnTableLotteryResult lotteryResult) {
        if (lotteryResult != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"hsj", (String)("Turntable lotteryResult=" + lotteryResult.toString()), (Object[])new Object[0]);
            }
            if (lotteryResult.costType == 20 && null != this.turntableView) {
                this.turntableView.onLottery(lotteryResult);
            } else if (lotteryResult.costType == 10 && null != this.turntableLotteryView) {
                this.turntableLotteryView.onLottery(lotteryResult);
            } else if (this.flipperIndex < this.pages.size()) {
                IFillterPage page = this.pages.get(this.flipperIndex);
                if (page instanceof TurntableView && null != this.turntableView) {
                    this.turntableView.onLottery(lotteryResult);
                } else if (page instanceof TurntableLotteryView && null != this.turntableLotteryView) {
                    this.turntableLotteryView.onLottery(lotteryResult);
                }
            }
            if (null != this.commonUi) {
                this.commonUi.onLottery(lotteryResult);
            }
            if (lotteryResult.result != 0) {
                if (lotteryResult.result == 2) {
                    this.dialogLinkManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u60a8\u7684\u7ea2\u94bb\u4e0d\u8db3\uff0c\u8bf7\u5148\u5151\u6362", (CharSequence)"\u5151\u6362", (CharSequence)"\u53d6\u6d88", true, true, new OkCancelDialogListener(){

                        public void onCancel() {
                        }

                        public void onOk() {
                            if (null != TurnTableComponent.this.commonUi) {
                                TurnTableComponent.this.commonUi.showRechargeWeb();
                            }
                        }
                    }));
                } else if (lotteryResult.result == 12) {
                    this.dialogLinkManager.showContentOkDialog((CharSequence)"\u5bf9\u4e0d\u8d77\n\u60a8\u7684\u62bd\u5956\u5238\u4e0d\u8db3\uff01", (CharSequence)"\u786e\u5b9a", true, true, null);
                } else {
                    Toast toast;
                    switch (lotteryResult.result) {
                        case 1: 
                        case 3: 
                        case 4: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u62bd\u5956\u5931\u8d25!\u6362\u4e2a\u59ff\u52bf\uff0c\u518d\u6765\u4e00\u6b21~~", (int)0);
                            break;
                        }
                        case 2: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u60a8\u7684\u7ea2\u94bb\u5238\u4e0d\u8db3\uff0c\u8bf7\u5148\u5151\u6362\uff01", (int)0);
                            break;
                        }
                        case 5: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u6570\u636e\u5e93\u9519\u8bef", (int)0);
                            break;
                        }
                        case 6: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u8f6c\u76d8\u670d\u52a1\u6682\u65f6\u5173\u95ed\u54af\uff0c\u5148\u5230\u522b\u5904\u73a9\u4e00\u73a9\u5427~", (int)0);
                            break;
                        }
                        case 7: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u7f51\u7edc\u597d\u50cf\u6709\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u8bd5\u5427~", (int)0);
                            break;
                        }
                        case 8: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u9ea6\u5e8f\u9519\u8bef", (int)0);
                            break;
                        }
                        default: {
                            toast = Toast.makeText((Context)this.getContext(), (CharSequence)"\u670d\u52a1\u5668\u8bf7\u6c42\u8d85\u65f6", (int)0);
                        }
                    }
                    toast.show();
                }
            }
        }
    }

    @BusEvent
    public void onQueryRedDiamondAmount(IPayClient_onQueryRedDiamondAmount_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        long amount = busEventArgs.getAmount();
        this.onQueryRedDiamondAmount(result, amount);
    }

    public void onQueryRedDiamondAmount(boolean result, long amount) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != this.commonUi) {
            this.commonUi.onQueryRedDiamondAmount(result, amount);
        }
    }

    @BusEvent
    public void onJsCallCloseWeb(IChannelTurntableClient_onJsCallCloseWeb_EventArgs busEventArgs) {
        this.onJsCallCloseWeb();
    }

    public void onJsCallCloseWeb() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != this.commonUi) {
            this.commonUi.onJsCallCloseWeb();
        }
    }

    @BusEvent(sync=true)
    public void onLeaveTurnTable(IChannelTurntableClient_onLeaveTurnTable_EventArgs busEventArgs) {
        if (this.turntableView != null) {
            this.turntableView.onDestroy();
            this.turntableView = null;
            if (this.checkActivityValid()) {
                this.dismissAllowingStateLoss();
            }
        }
    }

    @BusEvent
    public void onUpdateLottery(IChannelTurntableClient_onUpdateLottery_EventArgs busEventArgs) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != this.commonUi && null != TurnTableManager.turnTableEntryInfo) {
            this.commonUi.setLotteryCout(TurnTableManager.turnTableEntryInfo.coupon_qty);
        }
    }

    @BusEvent
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        byte[] strReason = busEventArgs.getStrReason();
        int uReason = busEventArgs.getUReason();
        if (this.turntableView != null) {
            this.turntableView.onDestroy();
            this.turntableView = null;
            if (this.checkActivityValid()) {
                this.dismissAllowingStateLoss();
            }
        }
    }

    @BusEvent(sync=true)
    public void onQueryTurnTableWinBroadcast(IChannelTurntableClient_onQueryTurnTableWinBroadcast_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        this.onQueryTurnTableWinBroadcast(result, extendInfo, otherList);
    }

    public void onQueryTurnTableWinBroadcast(long result, Map<String, String> extendInfo, List<Map<String, String>> otherList) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != this.commonUi) {
            this.commonUi.onQueryTurnTableWinBroadcast(result, extendInfo, otherList);
        }
    }

    @BusEvent
    public void onConnectivityChange(IConnectivityClient_onConnectivityChange_EventArgs busEventArgs) {
        IConnectivityCore.ConnectivityState previousState = busEventArgs.getPreviousState();
        IConnectivityCore.ConnectivityState currentState = busEventArgs.getCurrentState();
        this.onConnectivityChange(previousState, currentState);
    }

    public void onConnectivityChange(IConnectivityCore.ConnectivityState previousState, IConnectivityCore.ConnectivityState currentState) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.turntableView != null) {
            this.turntableView.onConnectivityChange(previousState, currentState);
        }
    }

    @BusEvent(sync=true)
    public void refreshWebByShortCutPay(IShortCutPayClient_refreshWebByShortCutPay_EventArgs busEventArgs) {
        this.refreshWebByShortCutPay();
    }

    public void refreshWebByShortCutPay() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (null != this.commonUi) {
            this.commonUi.refreshWebByShortCutPay();
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mTurnTableComponentSniperEventBinder == null) {
            this.mTurnTableComponentSniperEventBinder = new TurnTableComponent$$EventBinder();
        }
        this.mTurnTableComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mTurnTableComponentSniperEventBinder != null) {
            this.mTurnTableComponentSniperEventBinder.unBindEvent();
        }
    }
}

