/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.touch;

import android.content.res.Configuration;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import com.duowan.mobile.basemedia.swipe.SwipeDirection;
import com.duowan.mobile.basemedia.swipe.SwipeViewDelegate;
import com.duowan.mobile.entlive.events.ITouchClearScreen_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.game.ui.videobusiness.VolumeBrightnessView;
import com.yy.mobile.RxBus;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onHideScreenElementsView_EventArgs;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onShowScreenElementsView_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.BasicFuncitonComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicfunction.behavior.IBasicFunctionBehavior;
import com.yy.mobile.ui.touch.TouchComponent$$EventBinder;
import com.yy.mobile.ui.widget.swipeloadingview.SwipeContentView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.uicore.ITouchCore;

public class TouchComponent
extends Component
implements SwipeViewDelegate,
MvpView {
    private static final String TAG = "TouchComponent";
    private View mRootView = null;
    protected View view;
    protected View content;
    protected SwipeContentView swipeView;
    private boolean enable;
    private VolumeBrightnessView mBrightnessView;
    protected SwipeViewDelegate mSwipeListener;
    private EventBinder mTouchComponentSniperEventBinder;

    public static TouchComponent newInstance() {
        TouchComponent fragment = new TouchComponent();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"onCreatesetSwipeEnable true", (Object[])new Object[0]);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (container != null) {
            this.mRootView = inflater.inflate(R.layout.fragment_basic_touch, container, false);
        }
        this.content = this.getActivity().findViewById(R.id.channel_content);
        this.swipeView = (SwipeContentView)this.mRootView.findViewById(R.id.swipe_loading);
        this.swipeView.setSwipeViewDelegate(this);
        this.mBrightnessView = (VolumeBrightnessView)this.mRootView.findViewById(R.id.volumeBrightness);
        this.mBrightnessView.setEnable(this.isLandScapeMode());
        this.initSwipeTipLayout();
        ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
        return this.mRootView;
    }

    public void disableSwipeToRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
        }
    }

    public void disableSwipeToLeftAndRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.RIGHT);
            this.swipeView.disableDirection(SwipeDirection.CENTER);
        }
    }

    public void enableSwipeToLeftAndRight() {
        if (this.swipeView != null) {
            this.swipeView.enableDirection(SwipeDirection.LEFT);
            this.swipeView.enableDirection(SwipeDirection.RIGHT);
            this.swipeView.enableDirection(SwipeDirection.CENTER);
        }
    }

    public void disableSwipeAll() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.RIGHT);
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.TOP);
            this.swipeView.disableDirection(SwipeDirection.BOTTOM);
        }
    }

    public void onleSwipeToRight() {
        if (this.swipeView != null) {
            this.swipeView.disableDirection(SwipeDirection.LEFT);
            this.swipeView.disableDirection(SwipeDirection.TOP);
            this.swipeView.disableDirection(SwipeDirection.BOTTOM);
        }
    }

    public View getDragView(SwipeDirection direction) {
        switch (direction) {
            case CENTER: {
                return this.content;
            }
            case BOTTOM: {
                return this.getSlideChannelMask();
            }
            case RIGHT: {
                return this.content;
            }
            case LEFT: {
                return this.content;
            }
            case TOP: {
                return this.getSlideChannelMask();
            }
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.getDragView(direction);
        }
        return null;
    }

    public void onFling(SwipeDirection fromDirection, SwipeDirection toDirection) {
        MLog.info((Object)TAG, (String)("liveTemplateActivity.onFling  fromDirection:" + fromDirection + " toDirection\uff1a" + toDirection), (Object[])new Object[0]);
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onFling(fromDirection, toDirection);
        }
    }

    public void onScroll(SwipeDirection fromPosition, SwipeDirection toPosition, int x, int y, float percent, boolean isVerticalScroll) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (fromPosition == SwipeDirection.LEFT || toPosition == SwipeDirection.LEFT) {
            IBasicFunctionBehavior basicFunctionBehavior;
            View view = this.getDragView(SwipeDirection.CENTER);
            if (view != null) {
                view.setTranslationX((float)(-x));
            }
            if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                basicFunctionBehavior.transformSwipeAlpha(percent);
            }
        } else if (fromPosition == SwipeDirection.TOP || toPosition == SwipeDirection.TOP) {
            View view = this.getDragView(SwipeDirection.TOP);
            if (view != null) {
                this.switchMask(toPosition, view);
                view.setTranslationY((float)(-view.getMeasuredHeight() - y));
            }
        } else if (fromPosition == SwipeDirection.BOTTOM || toPosition == SwipeDirection.BOTTOM) {
            View view = this.getDragView(SwipeDirection.BOTTOM);
            if (view != null) {
                this.switchMask(toPosition, view);
                view.setTranslationY((float)(view.getMeasuredHeight() - y));
            }
        } else if (toPosition != SwipeDirection.CENTER || fromPosition != SwipeDirection.RIGHT) {
            if (toPosition == SwipeDirection.RIGHT) {
                IBasicFunctionBehavior basicFunctionBehavior;
                View view = this.getDragView(SwipeDirection.CENTER);
                if (view != null) {
                    view.setTranslationX(0.0f);
                }
                if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                    basicFunctionBehavior.transformSwipeAlpha(0.0f);
                }
            } else if (fromPosition == SwipeDirection.CENTER && toPosition == SwipeDirection.CENTER) {
                if (isVerticalScroll) {
                    View view = this.getDragView(SwipeDirection.BOTTOM);
                    if (view != null) {
                        int delta = y > 0 ? view.getMeasuredHeight() - y : -view.getMeasuredHeight() - y;
                        view.setTranslationY((float)delta);
                    }
                } else {
                    IBasicFunctionBehavior basicFunctionBehavior;
                    View view = this.getDragView(SwipeDirection.CENTER);
                    if (view != null) {
                        view.setTranslationX((float)(-x));
                    }
                    if (this.getRoot() != null && (basicFunctionBehavior = this.getBasicFunctionBehavior()) != null) {
                        basicFunctionBehavior.transformSwipeAlpha(percent);
                    }
                }
            }
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onScroll(fromPosition, toPosition, x, y, percent, isVerticalScroll);
        }
    }

    public void onScrollFinish(SwipeDirection fromDirection, SwipeDirection toDirection) {
        MLog.info((Object)TAG, (String)("liveTemplateActivity.onScrollFinish  fromDirection:" + fromDirection + " toDirection\uff1a" + toDirection), (Object[])new Object[0]);
        if (fromDirection == null) {
            return;
        }
        if (fromDirection != toDirection) {
            if (toDirection == SwipeDirection.TOP || toDirection == SwipeDirection.BOTTOM) {
                if (this.swipeView != null) {
                    this.swipeView.flingToDirection(toDirection, SwipeDirection.CENTER, 0, false);
                }
                MLog.info((Object)TAG, (String)"onScrollFinish: hide loading view", (Object[])new Object[0]);
                if (this.view != null) {
                    this.view.setVisibility(4);
                }
            } else if (toDirection == SwipeDirection.RIGHT) {
                if (this.swipeView != null) {
                    this.swipeView.flingToDirection(toDirection, SwipeDirection.CENTER, 0, false);
                }
            } else if (toDirection == SwipeDirection.LEFT) {
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(true);
                RxBus.getDefault().post((Object)new ITouchClearScreen_EventArgs(true));
            } else if (fromDirection == SwipeDirection.LEFT && toDirection == SwipeDirection.CENTER) {
                ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
                RxBus.getDefault().post((Object)new ITouchClearScreen_EventArgs(false));
            }
        }
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onScrollFinish(fromDirection, toDirection);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.view != null) {
            this.view.setVisibility(4);
        }
        ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).setClearScreenSate(false);
        Object var2_1 = null;
        if (this.mTouchComponentSniperEventBinder != null) {
            this.mTouchComponentSniperEventBinder.unBindEvent();
        }
    }

    protected View getSlideChannelMask() {
        if (!this.checkActivityValid()) {
            return null;
        }
        ViewStub stub = (ViewStub)this.getActivity().findViewById(R.id.viewstud_loading);
        if (stub != null) {
            stub.inflate();
        }
        if (this.view == null) {
            this.view = this.getActivity().findViewById(R.id.view_change_channel_mask);
        }
        return this.view;
    }

    private void initSwipeTipLayout() {
        ViewStub viewStub = (ViewStub)this.getActivity().findViewById(R.id.swipe_control_tip);
        if (viewStub != null) {
            viewStub.inflate();
        }
        if (this.mBrightnessView != null) {
            this.mBrightnessView.setTipContainer(this.getActivity().findViewById(R.id.swipe_control_tip_container));
        }
    }

    private void switchMask(SwipeDirection viewDirection, View maskView) {
        if (maskView == null) {
            return;
        }
        View bottomHint = maskView.findViewById(R.id.iv_hint_bottom);
        View topHint = maskView.findViewById(R.id.iv_hint_top);
        if (bottomHint == null || topHint == null) {
            return;
        }
        if (maskView.getVisibility() != 0) {
            maskView.setVisibility(0);
        }
        if (viewDirection == SwipeDirection.TOP && bottomHint.getVisibility() != 0) {
            ImageView imageView = (ImageView)maskView.findViewById(R.id.iv_hint_bottom);
            imageView.setVisibility(0);
            this.startHintAnimation(imageView);
            maskView.findViewById(R.id.iv_hint_bottom_text).setVisibility(0);
            maskView.findViewById(R.id.iv_hint_top).setVisibility(4);
            maskView.findViewById(R.id.iv_hint_top_text).setVisibility(4);
        } else if (viewDirection == SwipeDirection.BOTTOM && topHint.getVisibility() != 0) {
            ImageView imageView = (ImageView)maskView.findViewById(R.id.iv_hint_top);
            imageView.setVisibility(0);
            this.startHintAnimation(imageView);
            maskView.findViewById(R.id.iv_hint_top_text).setVisibility(0);
            maskView.findViewById(R.id.iv_hint_bottom).setVisibility(4);
            maskView.findViewById(R.id.iv_hint_bottom_text).setVisibility(4);
        }
    }

    private void startHintAnimation(ImageView imageView) {
        imageView.setImageResource(R.drawable.anim_ylink_swipe);
        AnimationDrawable animationDrawable = (AnimationDrawable)imageView.getDrawable();
        if (animationDrawable != null && !animationDrawable.isRunning()) {
            animationDrawable.start();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        MLog.info((Object)TAG, (String)"onConfigurationChanged", (Object[])new Object[0]);
        if (this.swipeView != null) {
            if (newConfig.orientation == 2) {
                this.swipeView.disableDirection(SwipeDirection.BOTTOM);
                this.swipeView.disableDirection(SwipeDirection.TOP);
            } else {
                this.swipeView.enableDirection(SwipeDirection.BOTTOM);
                this.swipeView.enableDirection(SwipeDirection.TOP);
            }
        }
        if (this.view != null) {
            this.view.setVisibility(4);
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mBrightnessView != null) {
            this.mBrightnessView.setEnable(isLandscape);
        }
    }

    public void smoothScrollTo(SwipeDirection fromDirection, SwipeDirection toDirection) {
        if (toDirection != null && fromDirection != null && this.swipeView != null) {
            this.swipeView.flingToDirection(fromDirection, toDirection, 0, true);
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSwipeListener(SwipeViewDelegate mSwipeListener) {
        this.mSwipeListener = mSwipeListener;
    }

    @BusEvent
    public void onShowScreenElementsView(IBasicFunctionClient_onShowScreenElementsView_EventArgs busEventArgs) {
        this.smoothScrollTo(SwipeDirection.LEFT, SwipeDirection.CENTER);
    }

    @BusEvent
    public void onHideScreenElementsView(IBasicFunctionClient_onHideScreenElementsView_EventArgs busEventArgs) {
        this.smoothScrollTo(SwipeDirection.CENTER, SwipeDirection.LEFT);
    }

    public IBasicFunctionBehavior getBasicFunctionBehavior() {
        return (IBasicFunctionBehavior)this.getRoot().findComponent(BasicFuncitonComponent.class);
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTouchComponentSniperEventBinder == null) {
            this.mTouchComponentSniperEventBinder = new TouchComponent$$EventBinder();
        }
        this.mTouchComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

