/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.duowan.mobile.entlive.events.ITurnChairClient_onTurnChairMyRecord_EventArgs;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestBasicUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.swivelChair.SwivelChairMyRecord$$EventBinder;
import com.yy.mobile.ui.swivelChair.SwivelChairMyRecordAdapter;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.turnchair.ITurnChairCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwivelChairMyRecord
extends BasePopupComponent
implements EventCompat {
    private SimpleTitleBar mTitleBar;
    private View recordTitle;
    private View nodataLay;
    private PullToRefreshListView mListView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private SwivelChairMyRecordAdapter adapter;
    private int mPageNo = 1;
    private int pageNum = 20;
    private boolean isLastPage = false;
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            SwivelChairMyRecord.this.getHandler().removeCallbacks(SwivelChairMyRecord.this.checkRequestTimeoutTask);
            SwivelChairMyRecord.this.finishLoadData();
            if (SwivelChairMyRecord.this.adapter != null && SwivelChairMyRecord.this.adapter.getCount() > 0) {
                SwivelChairMyRecord.this.checkNetToast();
                if (SwivelChairMyRecord.this.mPageNo > 1) {
                    SwivelChairMyRecord.this.mPageNo--;
                }
            } else {
                SwivelChairMyRecord.this.showNetworkErr();
            }
        }
    };
    private View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            SwivelChairMyRecord.this.showLoading();
            SwivelChairMyRecord.this.reLoadData();
        }
    };
    private EventBinder mSwivelChairMyRecordSniperEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.translucent_micgragment);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.swivelchair_myrecord_fragment, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initPager(view);
    }

    public void onDestroy() {
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        super.onDestroy();
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onTurnChairMyRecord(ITurnChairClient_onTurnChairMyRecord_EventArgs busEventArgs) {
        int result = busEventArgs.mResult;
        ArrayList records = busEventArgs.mRecords;
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        if (!this.checkActivityValid() || null == this.adapter) {
            return;
        }
        this.finishLoadData();
        this.hideStatus();
        if (result == 1) {
            if (this.mPageNo == 1) {
                this.showNetworkErr();
            } else {
                --this.mPageNo;
            }
            return;
        }
        this.isLastPage = false;
        if (null == records || records.size() == 0) {
            if (this.adapter.getCount() == 0) {
                if (null != this.nodataLay && null != this.recordTitle) {
                    this.nodataLay.setVisibility(0);
                    this.recordTitle.setVisibility(8);
                }
            } else {
                this.isLastPage = true;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("isLastPage", "1");
                ArrayList<Map<String, String>> list2 = new ArrayList<Map<String, String>>();
                list2.add(map);
                this.adapter.setData(list2, false);
            }
        } else {
            if (null != this.nodataLay) {
                this.nodataLay.setVisibility(8);
            }
            if (null != this.recordTitle) {
                this.recordTitle.setVisibility(0);
            }
            if (this.mPageNo == 1) {
                this.adapter.setData(records, true);
            } else {
                if (records.size() < this.pageNum) {
                    this.isLastPage = true;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("isLastPage", "1");
                    records.add(map);
                }
                this.adapter.setData(records, false);
            }
        }
    }

    @BusEvent
    public void onRequestBasicUserInfo(IUserClient_onRequestBasicUserInfo_EventArgs busEventArgs) {
        List userIdList = busEventArgs.getUserIdList();
        List userInfoList = busEventArgs.getUserInfoList();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        String ctx = busEventArgs.getCtx();
        if (null != this.adapter) {
            this.adapter.setHead(userInfoList);
        }
    }

    private void initPager(View view) {
        this.recordTitle = view.findViewById(R.id.turnchair_myrecord_title);
        this.nodataLay = view.findViewById(R.id.turnchair_nodata_lay);
        this.mTitleBar = (SimpleTitleBar)view.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte("\u4e2d\u5956\u8bb0\u5f55");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                if (SwivelChairMyRecord.this.checkActivityValid()) {
                    SwivelChairMyRecord.this.dismissAllowingStateLoss();
                }
            }
        });
        view.findViewById(R.id.no_data_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SwivelChairMyRecord.this.checkActivityValid()) {
                    SwivelChairMyRecord.this.dismissAllowingStateLoss();
                }
            }
        });
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.turnchair_myrecord_listview);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                SwivelChairMyRecord.this.reLoadData();
            }
        });
        this.adapter = new SwivelChairMyRecordAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.adapter);
        ((ListView)this.mListView.getRefreshableView()).setSelector(R.drawable.transparent);
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)view.findViewById(R.id.status_layout));
        this.mEndlessListScrollListener.setVisibleThreshold(3);
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (SwivelChairMyRecord.this.checkNetToast()) {
                    if (!SwivelChairMyRecord.this.isLastPage) {
                        SwivelChairMyRecord.this.loadMoreData();
                    }
                } else {
                    SwivelChairMyRecord.this.finishLoadData();
                }
            }

            public boolean shouldLoadData() {
                return SwivelChairMyRecord.this.checkNetToast() && !SwivelChairMyRecord.this.isLastPage;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.showLoading();
        this.loadData();
    }

    private void reLoadData() {
        this.mPageNo = 1;
        this.loadData();
    }

    private void loadMoreData() {
        ++this.mPageNo;
        this.loadData();
    }

    private void loadData() {
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        ((ITurnChairCore)ICoreManagerBase.getCore(ITurnChairCore.class)).queryTurnChairMyRecord(LoginUtil.getUid(), this.mPageNo, this.pageNum);
    }

    private void finishLoadData() {
        if (this.mListView != null) {
            this.mListView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mSwivelChairMyRecordSniperEventBinder == null) {
            this.mSwivelChairMyRecordSniperEventBinder = new SwivelChairMyRecord$$EventBinder();
        }
        this.mSwivelChairMyRecordSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mSwivelChairMyRecordSniperEventBinder != null) {
            this.mSwivelChairMyRecordSniperEventBinder.unBindEvent();
        }
    }
}

