/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Looper;
import android.text.Html;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.util.SafeDispatchHandler;

public class SwivelChairMarque
extends FrameLayout {
    private Context mContext;
    private TextView mTextView;
    private AnimatorSet animatorSet;
    private ObjectAnimator objectAnimator;
    private Runnable endListener;
    private float mSpeed = 10.0f;
    private int mMarqueWidth = 600;
    private long mDuration = 5000L;
    private SafeDispatchHandler mThreadHandle = new SafeDispatchHandler(Looper.myLooper());

    public SwivelChairMarque(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public void setMarqueWidth(int width) {
        if (width < 0) {
            return;
        }
        this.mMarqueWidth = width;
    }

    public void setEndListener(Runnable listener2) {
        this.endListener = listener2;
    }

    private void startMarquee() {
        this.reserverAnimation();
        if (this.mTextView != null) {
            TextPaint paint = this.mTextView.getPaint();
            float len = paint.measureText(this.mTextView.getText().toString());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)len, -2);
            this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.animatorSet = new AnimatorSet();
            this.objectAnimator = ObjectAnimator.ofFloat((Object)this.mTextView, (String)"translationX", (float[])new float[]{this.mMarqueWidth, -len});
            this.mDuration = (long)(this.mSpeed * Math.abs((float)this.mMarqueWidth + 2.0f * len));
            this.objectAnimator.setDuration(this.mDuration);
            this.objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            if (null != this.endListener) {
                this.mThreadHandle.removeCallbacks(this.endListener);
                this.mThreadHandle.postDelayed(this.endListener, this.mDuration);
            }
            this.animatorSet.play((Animator)this.objectAnimator);
            this.animatorSet.start();
        }
    }

    public void reserverAnimation() {
        if (this.animatorSet != null && this.animatorSet.isRunning()) {
            this.animatorSet.end();
            this.animatorSet = null;
        }
        if (null != this.objectAnimator) {
            this.objectAnimator.removeAllListeners();
            this.objectAnimator = null;
        }
        if (null != this.endListener) {
            this.mThreadHandle.removeCallbacks(this.endListener);
        }
    }

    public void setText(CharSequence content) {
        if (this.mTextView == null) {
            this.mTextView = (TextView)this.getChildAt(0);
        }
        if (this.mTextView == null && this.mContext != null) {
            this.mTextView = new TextView(this.mContext);
            this.mTextView.setSingleLine(true);
            this.mTextView.setGravity(16);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(this.mMarqueWidth, -1);
            this.addView((View)this.mTextView, lp);
        }
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)content)));
            this.startMarquee();
        }
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    public boolean isRunning() {
        return null != this.animatorSet && this.animatorSet.isRunning();
    }
}

