/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.streamlight;

import android.graphics.Point;
import android.graphics.Rect;

public class StreamLightProxy {
    public static final int OriginTopPos = 10;
    public static final int OnlyShowBottomStreamLight = 1;
    public static final int OnlyShowTopStreamLight = 2;
    public static final int ShowAllStreamLight = 3;
    private boolean isGiftUIShowNeedOffset = false;
    private boolean reverseOrderStreamlightPos = false;
    private boolean cancleFreeGiftStreamLightLimit = false;
    private boolean isTopPannel = false;
    private boolean isPhoneBottomOrigin = false;
    private Point point = new Point(3, 3);
    private Rect baseMargin;
    private Rect offsetMarginLandscape = new Rect(0, 0, 0, 0);
    private Rect offsetMarginPortrait = new Rect(0, 0, 0, 0);
    private boolean isLandspace = false;
    private int[] areaStateArray = new int[]{0, 0};

    public StreamLightProxy() {
        this.baseMargin = this.offsetMarginPortrait;
    }

    public int[] getAreaStateArray() {
        return this.areaStateArray;
    }

    public void setPoint(Point point) {
        if (point == null) {
            return;
        }
        this.point = point;
        if (this.isLandspace) {
            this.setAreaStateArray(point.y);
        } else {
            this.setAreaStateArray(point.x);
        }
    }

    private void setAreaStateArray(int state) {
        if (state == 1) {
            this.areaStateArray[0] = 1;
        } else if (state == 2) {
            this.areaStateArray[1] = 1;
        } else if (state == 3) {
            this.areaStateArray[0] = 0;
            this.areaStateArray[1] = 0;
        }
    }

    public void reset() {
        this.areaStateArray[0] = 0;
        this.areaStateArray[1] = 0;
        this.offsetMarginLandscape.left = 0;
        this.offsetMarginLandscape.top = 0;
        this.offsetMarginLandscape.bottom = 0;
        this.offsetMarginLandscape.right = 0;
        this.offsetMarginPortrait.left = 0;
        this.offsetMarginPortrait.top = 0;
        this.offsetMarginPortrait.bottom = 0;
        this.offsetMarginPortrait.right = 0;
        this.point.x = 3;
        this.point.y = 3;
        if (this.baseMargin != null) {
            this.baseMargin.left = 0;
            this.baseMargin.top = 0;
            this.baseMargin.right = 0;
            this.baseMargin.bottom = 0;
        }
        this.isGiftUIShowNeedOffset = false;
        this.reverseOrderStreamlightPos = false;
        this.cancleFreeGiftStreamLightLimit = false;
    }

    public void onOrientationChanges(boolean isLandscape) {
        this.isLandspace = isLandscape;
        if (isLandscape) {
            this.baseMargin = this.offsetMarginLandscape;
            this.setAreaStateArray(this.point.y);
        } else {
            this.baseMargin = this.offsetMarginPortrait;
            this.setAreaStateArray(this.point.x);
        }
    }

    public void setOffsetMarginLandscape(Rect offsetMarginLandscape) {
        this.offsetMarginLandscape = offsetMarginLandscape;
        this.baseMargin = offsetMarginLandscape;
    }

    public void setOffsetMarginPortrait(Rect offsetMarginPortrait) {
        if (offsetMarginPortrait == null) {
            return;
        }
        this.offsetMarginPortrait = offsetMarginPortrait;
        this.baseMargin = offsetMarginPortrait;
    }

    public Rect getBaseMargin() {
        return this.baseMargin;
    }

    public boolean isLock(int inedx) {
        if (this.point == null) {
            return false;
        }
        if (this.point.x == 3 && !this.isLandspace || this.point.y == 3 && this.isLandspace) {
            if (inedx > 1 && inedx <= this.areaStateArray.length) {
                this.areaStateArray[inedx - 1] = 0;
            }
            return false;
        }
        if ((this.point.x == 1 || this.point.y == 1) && inedx == 1) {
            this.areaStateArray[0] = 1;
            return true;
        }
        if ((this.point.x == 2 || this.point.y == 2) && inedx == 2) {
            this.areaStateArray[1] = 1;
            return true;
        }
        return false;
    }

    public boolean isGiftUIShowNeedOffset() {
        return this.isGiftUIShowNeedOffset;
    }

    public void setGiftUIShowNeedOffset(boolean giftUIShowNeedOffset) {
        this.isGiftUIShowNeedOffset = giftUIShowNeedOffset;
    }

    public boolean isReverseOrderStreamlightPos() {
        return this.reverseOrderStreamlightPos;
    }

    public void setReverseOrderStreamlightPos(boolean reverseOrderStreamlightPos) {
        this.reverseOrderStreamlightPos = reverseOrderStreamlightPos;
    }

    public boolean isCancleFreeGiftStreamLightLimit() {
        return this.cancleFreeGiftStreamLightLimit;
    }

    public void setCancleFreeGiftStreamLightLimit(boolean cancleFreeGiftStreamLightLimit) {
        this.cancleFreeGiftStreamLightLimit = cancleFreeGiftStreamLightLimit;
    }

    public boolean isTopPannel() {
        return this.isTopPannel;
    }

    public void setTopPannel(boolean topPannel) {
        this.isTopPannel = topPannel;
    }

    public boolean isPhoneBottomOrigin() {
        return this.isPhoneBottomOrigin;
    }

    public void setPhoneBottomOrigin(boolean phoneBottomOrigin) {
        this.isPhoneBottomOrigin = phoneBottomOrigin;
    }
}

