/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.streamlight;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IGiftComboClient_onComboFinish_EventArgs;
import com.duowan.mobile.entlive.events.IGiftComboClient_onGiftComboTypeState_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yymobile.core.gift.GiftComboType;

public class SmallComboView
extends RelativeLayout {
    public boolean isTimeOut = true;
    public boolean isAddToParentt = false;
    private Context mContext;
    private View smallCombo;
    private TextView countTxt1;
    private TextView countTxt2;
    private Button comboBtn;
    private RelativeLayout comboExtensionBar;
    private int countTime = 30;
    private SafeDispatchHandler timeHandler;
    private View.OnClickListener mListener;
    private Runnable setCountTxtRunnable = new Runnable(){

        @Override
        public void run() {
            SmallComboView.this.countTxt1.setText((CharSequence)String.valueOf(SmallComboView.this.countTime));
            SmallComboView.this.countTxt2.setText((CharSequence)String.valueOf(SmallComboView.this.countTime));
        }
    };
    private Runnable countTimeRunnable = new Runnable(){

        @Override
        public void run() {
            if (SmallComboView.this.countTime > 0) {
                SmallComboView.this.countTime--;
                SmallComboView.this.post(SmallComboView.this.setCountTxtRunnable);
                SmallComboView.this.timeHandler.postDelayed(SmallComboView.this.countTimeRunnable, 100L);
            } else {
                SmallComboView.this.onDestroy();
                PluginBus.INSTANCE.get().post((Object)new IGiftComboClient_onComboFinish_EventArgs());
            }
        }
    };

    public SmallComboView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public SmallComboView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.timeHandler = new SafeDispatchHandler(Looper.getMainLooper());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        this.smallCombo = LayoutInflater.from((Context)this.mContext).inflate(R.layout.giftstreamlight_small_combo_layout, null);
        this.smallCombo.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView(this.smallCombo);
        this.countTxt1 = (TextView)this.smallCombo.findViewById(R.id.timeCount1);
        this.countTxt2 = (TextView)this.smallCombo.findViewById(R.id.timeCount2);
        this.comboBtn = (Button)this.smallCombo.findViewById(R.id.small_combo_btn);
        if (Build.VERSION.SDK_INT >= 21) {
            this.comboBtn.setStateListAnimator(null);
        }
        this.comboBtn.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (SmallComboView.this.countTime <= 0) {
                        SmallComboView.this.startTime();
                    }
                    SmallComboView.this.resetTime();
                    SmallComboView.this.comboBtn.setBackgroundResource(R.drawable.smallcombo_press);
                }
                if (event.getAction() == 1) {
                    SmallComboView.this.comboBtn.setBackgroundResource(R.drawable.smallcombo_normal);
                }
                return false;
            }
        });
        this.comboExtensionBar = (RelativeLayout)this.smallCombo.findViewById(R.id.rl_extension_bar);
        this.startTime();
        this.isAddToParentt = true;
        PluginBus.INSTANCE.get().post((Object)new IGiftComboClient_onGiftComboTypeState_EventArgs(true, GiftComboType.SMALL));
    }

    public void clickSmallCombo() {
        if (this.countTime <= 0) {
            this.startTime();
        }
        this.resetTime();
    }

    public void setClickListener(View.OnClickListener listener2) {
        if (this.comboBtn != null && listener2 != null) {
            this.mListener = listener2;
            this.comboBtn.setOnClickListener(this.mListener);
        }
    }

    private void resetTime() {
        this.countTime = 30;
        this.countTxt1.setText((CharSequence)String.valueOf(this.countTime));
        this.countTxt2.setText((CharSequence)String.valueOf(this.countTime));
        this.isTimeOut = false;
    }

    private void startTime() {
        this.isTimeOut = false;
        this.timeHandler.postDelayed(this.countTimeRunnable, 100L);
    }

    public void onDestroy() {
        this.timeHandler.removeCallbacks(this.countTimeRunnable);
        this.removeCallbacks(this.setCountTxtRunnable);
        this.comboBtn.setEnabled(false);
        this.mListener = null;
        this.isTimeOut = true;
        this.setVisibility(8);
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.removeView((View)this);
            this.isAddToParentt = false;
            PluginBus.INSTANCE.get().post((Object)new IGiftComboClient_onGiftComboTypeState_EventArgs(false, GiftComboType.SMALL));
        }
    }

    public RelativeLayout getComboExtensionBar() {
        return this.comboExtensionBar;
    }
}

