/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.startask;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.events.ICavalierClient_onTaskAwardRedDotState_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.startask.TaskAnimationManager;
import com.yy.mobile.ui.startask.TaskEffectController;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import java.lang.ref.WeakReference;

public class TaskWeakEffectView {
    private static int moveDisX = 0;
    private static int moveDisY = 0;
    private final int strongDelayTime = 1100;
    private final int weakDelayTime = 15100;
    private final int apertureAlphaDelayTime = 100;
    private final int translatonAndScaleDelayTime = 300;
    private Context mContext;
    private View rootView;
    private RecycleImageView apertureImg;
    private RecycleImageView taskIconSmall;
    private RelativeLayout.LayoutParams centerLayoutParams;
    private int currentDelayTime = 0;
    private AnimatorSet apertureScaleAnimatorSet;
    private AnimatorSet taskIconScaleAnimatorSet;
    private ObjectAnimator taskIconScaleAnimatorX;
    private ObjectAnimator taskIconScaleAnimatorY;
    private ObjectAnimator translationAnimatorX;
    private ObjectAnimator translationAnimatorY;
    private AnimatorSet iconAnimatorSet;
    private ObjectAnimator apertureAlphaAnimator;
    private boolean isPlaying = false;
    private RelativeLayout.LayoutParams weakLayoutParams;
    private int posX;
    private int posY;
    private boolean anchorLeft = true;
    private WeakReference<TaskEffectController.ITaskAnimationListener> animationListenerWeakRef;
    private WeakReference<TaskEffectController.ITaskControllerPlayState> playStateWeakReference;
    private Runnable translationAndScaleRunnable = new Runnable(){

        @Override
        public void run() {
            TaskWeakEffectView.this.taskIconScaleAnimatorX = TaskAnimationManager.getInstance().scaleAnimator((View)TaskWeakEffectView.this.taskIconSmall, "scaleX", 1.0f, 0.4f);
            TaskWeakEffectView.this.taskIconScaleAnimatorY = TaskAnimationManager.getInstance().scaleAnimator((View)TaskWeakEffectView.this.taskIconSmall, "scaleY", 1.0f, 0.4f);
            TaskWeakEffectView.this.translationAnimatorX = TaskAnimationManager.getInstance().translationAnimator((View)TaskWeakEffectView.this.taskIconSmall, "translationX", moveDisX);
            TaskWeakEffectView.this.translationAnimatorY = TaskAnimationManager.getInstance().translationAnimator((View)TaskWeakEffectView.this.taskIconSmall, "translationY", -moveDisY);
            TaskWeakEffectView.this.iconAnimatorSet = TaskAnimationManager.getInstance().startAnimatorSet((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    TaskEffectController.ITaskAnimationListener l;
                    TaskEffectController.ITaskAnimationListener iTaskAnimationListener = l = TaskWeakEffectView.this.animationListenerWeakRef != null ? (TaskEffectController.ITaskAnimationListener)TaskWeakEffectView.this.animationListenerWeakRef.get() : null;
                    if (l != null) {
                        l.animationEnd();
                    }
                }
            }, 200, TaskWeakEffectView.this.translationAnimatorX, TaskWeakEffectView.this.translationAnimatorY, TaskWeakEffectView.this.taskIconScaleAnimatorX, TaskWeakEffectView.this.taskIconScaleAnimatorY);
        }
    };
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private Runnable apertureAlphaRunnable = new Runnable(){

        @Override
        public void run() {
            TaskWeakEffectView.this.apertureAlphaAnimator = TaskAnimationManager.getInstance().startAlphaAnimator((View)TaskWeakEffectView.this.apertureImg, null, 600, 1.0f, 0.0f);
            TaskWeakEffectView.this.handler.removeCallbacks(TaskWeakEffectView.this.translationAndScaleRunnable);
            TaskWeakEffectView.this.handler.postDelayed(TaskWeakEffectView.this.translationAndScaleRunnable, 300L);
        }
    };
    private Runnable endRunnable = new Runnable(){

        @Override
        public void run() {
            RxBus.getDefault().post((Object)new ICavalierClient_onTaskAwardRedDotState_EventArgs(true));
            TaskWeakEffectView.this.stopTaskAnimation();
        }
    };
    private int verb;

    public TaskWeakEffectView(Context context, int layoutParama, int posX, int posY) {
        this.mContext = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_task_weak_effect, null);
        moveDisX = (int)ResolutionUtils.convertDpToPixel((float)17.0f, (Context)BasicConfig.getInstance().getAppContext());
        moveDisY = (int)ResolutionUtils.convertDpToPixel((float)9.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.verb = layoutParama;
        this.posX = posX;
        this.posY = posY;
        this.anchorLeft = false;
    }

    public TaskWeakEffectView(Context context, int posX, int posY) {
        this.mContext = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_task_weak_effect, null);
        moveDisX = (int)ResolutionUtils.convertDpToPixel((float)17.0f, (Context)BasicConfig.getInstance().getAppContext());
        moveDisY = (int)ResolutionUtils.convertDpToPixel((float)9.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.verb = 9;
        this.anchorLeft = true;
        this.posX = posX;
        this.posY = posY;
    }

    public void setPos(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosX() {
        return this.posX;
    }

    public RelativeLayout.LayoutParams getWeakEffectLayoutParmas() {
        if (this.weakLayoutParams == null) {
            int size = (int)ResolutionUtils.convertDpToPixel((float)90.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.weakLayoutParams = new RelativeLayout.LayoutParams(size, size);
            this.weakLayoutParams.addRule(12);
            this.weakLayoutParams.addRule(this.verb);
            if (this.anchorLeft) {
                this.weakLayoutParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)this.posX, (Context)BasicConfig.getInstance().getAppContext());
            } else {
                this.weakLayoutParams.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)this.posX, (Context)BasicConfig.getInstance().getAppContext());
            }
        }
        this.weakLayoutParams.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)this.posY, (Context)BasicConfig.getInstance().getAppContext());
        return this.weakLayoutParams;
    }

    private void initRes() {
        if (this.apertureImg == null) {
            this.apertureImg = (RecycleImageView)this.rootView.findViewById(R.id.aperture_img);
            this.apertureImg.setVisibility(4);
        }
        if (this.taskIconSmall == null) {
            this.taskIconSmall = (RecycleImageView)this.rootView.findViewById(R.id.task_icon_small);
            this.taskIconSmall.setVisibility(4);
        }
    }

    public View getWeakEffectView() {
        return this.rootView;
    }

    public void startTaskAnimation(boolean isWeak) {
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        this.rootView.setVisibility(0);
        this.currentDelayTime = isWeak ? 15100 : 1100;
        this.initRes();
        this.apertureScaleAnimatorSet = TaskAnimationManager.getInstance().startScaleAnimator((View)this.apertureImg, null, 700, 0.2f, 1.1f);
        this.handler.removeCallbacks(this.apertureAlphaRunnable);
        this.handler.postDelayed(this.apertureAlphaRunnable, 100L);
        this.taskIconScaleAnimatorSet = TaskAnimationManager.getInstance().startScaleAnimator((View)this.taskIconSmall, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                if (TaskWeakEffectView.this.apertureImg != null) {
                    TaskWeakEffectView.this.apertureImg.setVisibility(0);
                }
                if (TaskWeakEffectView.this.taskIconSmall != null) {
                    TaskWeakEffectView.this.taskIconSmall.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animator) {
                TaskWeakEffectView.this.handler.removeCallbacks(TaskWeakEffectView.this.endRunnable);
                TaskWeakEffectView.this.handler.postDelayed(TaskWeakEffectView.this.endRunnable, (long)TaskWeakEffectView.this.currentDelayTime);
            }
        }, 200, 0.4f, 1.0f);
    }

    public void stopTaskAnimation() {
        TaskEffectController.ITaskControllerPlayState state;
        if (!this.isPlaying) {
            return;
        }
        this.rootView.setVisibility(4);
        this.isPlaying = false;
        TaskEffectController.ITaskControllerPlayState iTaskControllerPlayState = state = this.playStateWeakReference != null ? (TaskEffectController.ITaskControllerPlayState)this.playStateWeakReference.get() : null;
        if (state != null) {
            state.playState(false);
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.apertureScaleAnimatorSet != null) {
            this.apertureScaleAnimatorSet.cancel();
            this.apertureScaleAnimatorSet = null;
        }
        if (this.apertureAlphaAnimator != null) {
            this.apertureAlphaAnimator.cancel();
            this.apertureAlphaAnimator = null;
        }
        if (this.taskIconScaleAnimatorSet != null) {
            this.taskIconScaleAnimatorSet.removeAllListeners();
            this.taskIconScaleAnimatorSet.cancel();
            this.taskIconScaleAnimatorSet = null;
        }
        if (this.iconAnimatorSet != null) {
            this.iconAnimatorSet.removeAllListeners();
            this.iconAnimatorSet.cancel();
            this.iconAnimatorSet = null;
        }
        if (this.taskIconScaleAnimatorX != null) {
            this.taskIconScaleAnimatorX = null;
        }
        if (this.taskIconScaleAnimatorY != null) {
            this.taskIconScaleAnimatorY = null;
        }
        if (this.translationAnimatorX != null) {
            this.translationAnimatorX = null;
        }
        if (this.translationAnimatorY != null) {
            this.translationAnimatorY = null;
        }
        if (this.apertureImg != null) {
            this.apertureImg.setVisibility(4);
        }
        if (this.taskIconSmall != null) {
            this.taskIconSmall.setTranslationX(0.0f);
            this.taskIconSmall.setTranslationY(0.0f);
            this.taskIconSmall.setVisibility(4);
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setAnimationListenerWeakRef(TaskEffectController.ITaskAnimationListener animationListener) {
        if (this.animationListenerWeakRef == null) {
            this.animationListenerWeakRef = new WeakReference<TaskEffectController.ITaskAnimationListener>(animationListener);
        }
    }

    public void setPlayStateWeakReference(TaskEffectController.ITaskControllerPlayState playStateListener) {
        if (this.playStateWeakReference == null) {
            this.playStateWeakReference = new WeakReference<TaskEffectController.ITaskControllerPlayState>(playStateListener);
        }
    }

    public boolean isNullAnimationListenerWeakRef() {
        return this.animationListenerWeakRef == null;
    }
}

