/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui.mulitfightpk;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.noble.EntIdentityApi;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.multifightpk.GuestContRankInfo;
import java.util.ArrayList;
import java.util.List;

public class FightGuestContRankAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "FightGuestContRankAdapter";
    private static final int VIEW_TYPE_EMPTY = 0;
    private static final int VIEW_TYPE_NORMAL = 1;
    public static final int DEFAULT_TOP_EMPTY_COUNT = 3;
    public static final int MAX_TOP_EMPTY_COUNT = 5;
    private Context mContext;
    private List<GuestContRankInfo> mDatas = new ArrayList<GuestContRankInfo>();
    private boolean mIsCharmData;
    private int mTopEmptyCount = 3;
    private int mDrawableWidth;

    public FightGuestContRankAdapter(Context context, boolean isCharmData, int topEmptyCount) {
        this.mIsCharmData = isCharmData;
        this.mTopEmptyCount = topEmptyCount;
        this.mContext = context;
        this.mDrawableWidth = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.mContext);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.multi_guest_cont_rank_item, parent, false));
        }
        return new EmptyViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.multi_guest_cont_rank_item, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        if (!(holder instanceof EmptyViewHolder)) {
            GuestContRankInfo info = this.mDatas.get(position);
            if (null != info) {
                if (info.getMystictype() != 1) {
                    holder.nickname.setText((CharSequence)(!FP.empty((CharSequence)info.getName()) ? info.getName() : ""));
                    if (Build.VERSION.SDK_INT >= 17) {
                        holder.nickname.setTextDirection(3);
                    }
                    this.loadFace(info.getLogo(), 0, (RecycleImageView)holder.portrait);
                    this.updateNobelIcon(holder, info);
                }
                this.updateMysteriousPerson(holder, info.getMystictype() == 1);
                this.updateRankIcon(holder, position);
                this.updateContCount(holder, info.getScore());
            }
        } else {
            this.updateContCount(holder, 0L);
            this.updateRankIcon(holder, position);
            ((EmptyViewHolder)holder).updateEmptyView(this.mIsCharmData);
        }
    }

    public int getItemViewType(int position) {
        if (position < this.mDatas.size()) {
            return 1;
        }
        return 0;
    }

    public int getItemCount() {
        return this.mDatas.size() < this.mTopEmptyCount ? this.mTopEmptyCount : this.mDatas.size();
    }

    public void setDatas(@NonNull List<GuestContRankInfo> datas) {
        if (!FP.empty(datas)) {
            this.mDatas.clear();
            this.mDatas.addAll(datas);
            this.notifyDataSetChanged();
        }
    }

    private void updateMysteriousPerson(ViewHolder viewHolder, boolean isMysterions) {
        if (isMysterions) {
            viewHolder.portrait.setVisibility(8);
            viewHolder.mysteriousPersonIv.setVisibility(0);
            viewHolder.mysteriousPersonIv.setImageResource(R.drawable.icon_list_head_invisible);
            viewHolder.nickname.setVisibility(8);
            viewHolder.mysteriousPerson.setVisibility(0);
        } else {
            viewHolder.portrait.setVisibility(0);
            viewHolder.mysteriousPersonIv.setVisibility(8);
            viewHolder.nickname.setVisibility(0);
            viewHolder.mysteriousPerson.setVisibility(8);
        }
    }

    private void updateRankIcon(ViewHolder viewHolder, int position) {
        if (position < 3) {
            viewHolder.rankIcon.setText((CharSequence)"");
            viewHolder.rankIcon.setBackgroundResource(this.getRankIconRes(position + 1));
        } else {
            viewHolder.portrait.setBorderWidth(0);
            viewHolder.rankIcon.setText((CharSequence)String.valueOf(position + 1));
            viewHolder.rankIcon.setBackgroundResource(0);
        }
    }

    private void updateContCount(ViewHolder viewHolder, long score) {
        if (!this.mIsCharmData) {
            viewHolder.contributionCount.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_red_diamond, 0);
            viewHolder.contributionCount.setText((CharSequence)String.format("\u8d21\u732e\u503c: %s", StringUtils.formatCommonSeperate((Object)score)));
        } else {
            viewHolder.contributionCount.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.multi_icon_charm, 0);
            viewHolder.contributionCount.setText((CharSequence)String.format("\u9b45\u529b\u503c: %s", StringUtils.formatCommonSeperate((Object)score)));
        }
    }

    private void updateNobelIcon(ViewHolder viewHolder, GuestContRankInfo info) {
        if (info.getNobleType() > 0) {
            int res = this.getNobelIconRes(info.getNobleType());
            BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)res, (ImageConfig)ImageConfig.defaultImageConfig());
            if (bitmapDrawable != null) {
                bitmapDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableWidth);
            }
            viewHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
        } else if (info.getNobleType() == 0) {
            int res = this.getNobel2IconRes(info.getNobleType2());
            BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawableFromResource((int)res, (ImageConfig)ImageConfig.defaultImageConfig());
            if (bitmapDrawable != null) {
                bitmapDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableWidth);
            }
            viewHolder.nickname.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
        } else {
            viewHolder.nickname.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        }
    }

    private int getNobelIconRes(int level) {
        return ((EntIdentityApi)CoreApiManager.getInstance().getApi(EntIdentityApi.class)).getIconResId(level, 46);
    }

    private int getNobel2IconRes(int level) {
        return ((EntIdentityApi)CoreApiManager.getInstance().getApi(EntIdentityApi.class)).getNoble2IconResId(level);
    }

    private void loadFace(String url, int index, RecycleImageView recycleImageView) {
        int blankBitmapResource = R.drawable.default_portrait;
        int loadingBitmapResource = R.drawable.default_portrait;
        MLog.info((Object)TAG, (String)("load url :" + url + " index :" + index), (Object[])new Object[0]);
        if (index != 999 && index > 0) {
            String headUrl = BasicConfig.getInstance().getAppContext().getString(R.string.str_friend_head_index_url_format, new Object[]{index});
            ImageLoader.loadImage((RecycleImageView)recycleImageView, (String)headUrl, (int)loadingBitmapResource, (int)blankBitmapResource);
            return;
        }
        ImageLoader.loadImage((RecycleImageView)recycleImageView, (String)url, (int)loadingBitmapResource, (int)blankBitmapResource);
    }

    private int getRankIconRes(int rank) {
        switch (rank) {
            case 1: {
                return R.drawable.icon_ranked_1;
            }
            case 2: {
                return R.drawable.icon_ranked_2;
            }
            case 3: {
                return R.drawable.icon_ranked_3;
            }
        }
        return 0;
    }

    class EmptyViewHolder
    extends ViewHolder {
        EmptyViewHolder(View itemView) {
            super(itemView);
        }

        private void updateEmptyView(boolean isCharmData) {
            this.nickname.setText((CharSequence)(isCharmData ? "\u865a\u4f4d\u4ee5\u5f85" : "\u699c\u4e0a\u65e0\u4eba"));
            FightGuestContRankAdapter.this.loadFace("", 0, (RecycleImageView)this.portrait);
        }
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView rankIcon;
        CircleImageView portrait;
        ImageView mysteriousPersonIv;
        TextView nickname;
        TextView contributionCount;
        TextView mysteriousPerson;

        ViewHolder(View itemView) {
            super(itemView);
            this.rankIcon = (TextView)itemView.findViewById(R.id.iv_rank_icon);
            this.portrait = (CircleImageView)itemView.findViewById(R.id.iv_portrait);
            this.mysteriousPersonIv = (ImageView)itemView.findViewById(R.id.mysterious_person_iv);
            this.nickname = (TextView)itemView.findViewById(R.id.tv_nickname);
            this.mysteriousPerson = (TextView)itemView.findViewById(R.id.tv_mysterious_person);
            this.contributionCount = (TextView)itemView.findViewById(R.id.tv_contribution);
        }
    }
}

