/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.richtop.ui.mulitfightpk;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.richtop.ui.mulitfightpk.FightGuestContRankAdapter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.multifightpk.IMultiFightPKRankCore;
import com.yymobile.core.multifightpk.MultiFightPK_OnQueryAllGuestContRank_EventArgs;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.Collection;

public class FightAllGuestContRankFragment
extends BaseLinkFragment {
    private static final String TAG = "FightAllGuestContRankFragment";
    private RadioGroup mRadioGroup;

    public static FightAllGuestContRankFragment newInstatnce() {
        return new FightAllGuestContRankFragment();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.multi_all_guest_cont_rank_layout, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mRadioGroup = (RadioGroup)view.findViewById(R.id.title);
        this.mRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.today_btn) {
                    FightAllGuestContRankFragment.this.showTodayContRank();
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0004");
                } else if (checkedId == R.id.weekly_btn) {
                    FightAllGuestContRankFragment.this.showWeeklyContRank();
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0003");
                }
            }
        });
        this.mRadioGroup.check(R.id.today_btn);
        this.showTodayContRank();
    }

    private void showWeeklyContRank() {
        this.replaceFragment(WeeklyContRankFragment.class);
    }

    private void showTodayContRank() {
        this.replaceFragment(TodayContRankFragment.class);
    }

    private void replaceFragment(@NonNull Class<? extends BaseContRankFragment> replaceFragmentClz) {
        FragmentManager fm = this.getChildFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment fragment = fm.findFragmentByTag(replaceFragmentClz.getName());
        if (null == fragment) {
            fragment = Fragment.instantiate((Context)this.getContext(), (String)replaceFragmentClz.getName());
        }
        if (null != fragment) {
            ft.replace(R.id.container, fragment);
            ft.commitAllowingStateLoss();
        }
    }

    public static class BaseContRankFragment
    extends BaseLinkFragment {
        private RecyclerView mRecyclerView;
        protected FightGuestContRankAdapter mAdapter;
        protected CompositeDisposable mCompositeDisposable = new CompositeDisposable();

        @Nullable
        public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return inflater.inflate(R.layout.multi_guest_cont_rank_layout, container, false);
        }

        public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
            this.initRecyclerView();
        }

        private void initRecyclerView() {
            final int dividerHeight = ScreenUtil.getInstance().dip2px(1);
            final int marginLeft = ScreenUtil.getInstance().dip2px(95);
            final Paint mPaint = new Paint(1);
            mPaint.setColor(this.getResources().getColor(R.color.live_common_color_9_transparent_10));
            this.mRecyclerView.addItemDecoration(new RecyclerView.ItemDecoration(){

                public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
                    int left = parent.getPaddingLeft() + marginLeft;
                    int right = parent.getMeasuredWidth() - parent.getPaddingRight();
                    int childSize = parent.getChildCount();
                    for (int i = 0; i < childSize && i != childSize - 1; ++i) {
                        View child = parent.getChildAt(i);
                        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
                        int top = child.getBottom() + layoutParams.bottomMargin;
                        int bottom = top + dividerHeight;
                        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, mPaint);
                    }
                }

                public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                    outRect.set(0, 0, 0, dividerHeight);
                }
            });
            this.mAdapter = new FightGuestContRankAdapter((Context)this.getActivity(), true, 5);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
            LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.getActivity());
            layoutManager.setAutoMeasureEnabled(false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        }

        public void onDestroyView() {
            super.onDestroyView();
            this.mCompositeDisposable.dispose();
        }
    }

    public static class TodayContRankFragment
    extends BaseContRankFragment {
        public static TodayContRankFragment newInstance() {
            return new TodayContRankFragment();
        }

        @Override
        public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            this.mCompositeDisposable.add(((IMultiFightPKRankCore)ICoreManagerBase.getCore(IMultiFightPKRankCore.class)).queryAllGuestContRank(1).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MultiFightPK_OnQueryAllGuestContRank_EventArgs>(){

                public void accept(MultiFightPK_OnQueryAllGuestContRank_EventArgs eventArgs) throws Exception {
                    if (eventArgs.rankDay == 1 && !FP.empty((Collection)eventArgs.list)) {
                        TodayContRankFragment.this.mAdapter.setDatas(eventArgs.list);
                        TodayContRankFragment.this.mAdapter.notifyDataSetChanged();
                    }
                }
            }, RxUtils.errorConsumer((String)FightAllGuestContRankFragment.TAG, (String)"queryAllGuestContRank error")));
        }
    }

    public static class WeeklyContRankFragment
    extends BaseContRankFragment {
        public static WeeklyContRankFragment newInstance() {
            return new WeeklyContRankFragment();
        }

        @Override
        public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            this.mCompositeDisposable.add(((IMultiFightPKRankCore)ICoreManagerBase.getCore(IMultiFightPKRankCore.class)).queryAllGuestContRank(7).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MultiFightPK_OnQueryAllGuestContRank_EventArgs>(){

                public void accept(MultiFightPK_OnQueryAllGuestContRank_EventArgs eventArgs) throws Exception {
                    if (eventArgs.rankDay == 7 && !FP.empty((Collection)eventArgs.list)) {
                        WeeklyContRankFragment.this.mAdapter.setDatas(eventArgs.list);
                        WeeklyContRankFragment.this.mAdapter.notifyDataSetChanged();
                    }
                }
            }, RxUtils.errorConsumer((String)FightAllGuestContRankFragment.TAG, (String)"queryAllGuestContRank error")));
        }
    }
}

