/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.redpacket.newuserpacket;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.ui.redpacket.newuserpacket.LiveRedPacketComponent$$EventBinder;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.ShowGiftCompoentEventArgs;
import com.yymobile.core.redpacket.homereward.IRewardCore;
import com.yymobile.core.redpacket.homereward.event.GetRedPacketEventArgs;
import com.yymobile.core.redpacket.homereward.protos.BasePacketInfo;
import com.yymobile.core.redpacket.homereward.protos.PacketInfo;
import com.yymobile.core.redpacket.homereward.protos.RewardProtocol;
import com.yymobile.core.redpacket.newuserpacket.ILiveRewardCore;
import com.yymobile.core.redpacket.newuserpacket.event.ReceiveLiveRedPacketEventArgs;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class LiveRedPacketComponent
extends BasePopupComponent {
    private static final String TAG = "LiveRedPacketComponent";
    private static final String KEY_ISSUCCESS = "key_isscuccess";
    private static final String KEY_PACKETINFO = "key_packetinfo";
    private static final String KEY_TIPMESSAGE = "key_tipmsg";
    private static final String KEY_GIFTTYPE = "key_giftpoptype";
    private View mRootView;
    private RecycleImageView mBackView;
    private TextView mTipView;
    private Button mLoginBtn;
    private LinearLayout mSendGiftContainer;
    private Button mSendGiftView;
    private TextView mStorePacageView;
    private View mClostBtn;
    private boolean isReceivePacket;
    private String mTipMsg;
    private PacketInfo mPacketInfo;
    private int mGiftPopType;
    private Disposable mGetPacketReq;
    private ScaleAnimation mScaleAnimation;
    private EventBinder mLiveRedPacketComponentSniperEventBinder;

    public static void showNewinstance(FragmentActivity fragmentActivity, ReceiveLiveRedPacketEventArgs liveRedPacket) {
        if (null == fragmentActivity || fragmentActivity.isFinishing()) {
            return;
        }
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        if (null != fragmentManager.findFragmentByTag(TAG)) {
            return;
        }
        LiveRedPacketComponent component = new LiveRedPacketComponent();
        Bundle bundle = new Bundle();
        if (null != liveRedPacket) {
            bundle.putBoolean(KEY_ISSUCCESS, liveRedPacket.isSuccess);
            bundle.putString(KEY_TIPMESSAGE, liveRedPacket.tipMessage);
            bundle.putParcelable(KEY_PACKETINFO, (Parcelable)liveRedPacket.packetInfo);
            bundle.putInt(KEY_GIFTTYPE, liveRedPacket.giftPopType);
        }
        component.setArguments(bundle);
        component.show(fragmentManager, TAG);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973833);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog mDialog = super.onCreateDialog(savedInstanceState);
        mDialog.setCanceledOnTouchOutside(false);
        mDialog.requestWindowFeature(1);
        mDialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        mDialog.getWindow().setWindowAnimations(R.style.DialogAnimationTop);
        mDialog.getWindow().setGravity(17);
        mDialog.getWindow().setLayout(-1, -1);
        return mDialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.layout_liveredpacket_component, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ((ILiveRewardCore)ICoreManagerBase.getCore(ILiveRewardCore.class)).cancelRegistBusEvent();
        this.initData();
        this.initView(view);
    }

    private void initData() {
        Bundle bundle = this.getArguments();
        if (null == bundle) {
            return;
        }
        this.isReceivePacket = bundle.getBoolean(KEY_ISSUCCESS);
        this.mTipMsg = bundle.getString(KEY_TIPMESSAGE);
        this.mPacketInfo = (PacketInfo)bundle.getParcelable(KEY_PACKETINFO);
        this.mGiftPopType = bundle.getInt(KEY_GIFTTYPE);
    }

    private void initView(View root) {
        if (null == root) {
            return;
        }
        this.mRootView = root.findViewById(R.id.live_redpacket_root);
        this.mBackView = (RecycleImageView)root.findViewById(R.id.live_redpacket_back);
        this.mTipView = (TextView)root.findViewById(R.id.live_redpacket_tipmsg);
        this.mLoginBtn = (Button)root.findViewById(R.id.live_redpacket_login);
        this.mSendGiftContainer = (LinearLayout)root.findViewById(R.id.live_redpacket_packetcontainer);
        this.mSendGiftView = (Button)root.findViewById(R.id.live_redpacket_sendtoanchor);
        this.mStorePacageView = (TextView)root.findViewById(R.id.live_redpacket_pushtopacket);
        this.mClostBtn = root.findViewById(R.id.live_redpacket_close);
        this.mClostBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiveRedPacketComponent.this.dismiss();
            }
        });
        if (this.isReceivePacket) {
            if (this.isLogined()) {
                this.showLoginPacket();
            } else {
                this.showUnLoginPacket();
            }
        } else {
            this.showError();
        }
    }

    private void showError() {
        MLog.info((Object)TAG, (String)"showError", (Object[])new Object[0]);
        this.mLoginBtn.setVisibility(8);
        this.mSendGiftContainer.setVisibility(8);
        this.mTipView.setVisibility(0);
        this.mTipView.setText((CharSequence)this.mTipMsg);
        if (null != this.mPacketInfo) {
            ImageLoader.loadImage((RecycleImageView)this.mBackView, (String)this.mPacketInfo.getBigFailUri());
        }
    }

    private void showLoginPacket() {
        MLog.info((Object)TAG, (String)"showLoginPacket", (Object[])new Object[0]);
        this.sendHiidoStatistic("0005");
        this.mTipView.setVisibility(8);
        this.mLoginBtn.setVisibility(8);
        this.mSendGiftContainer.setVisibility(0);
        if (null != this.mPacketInfo) {
            ImageLoader.loadImage((RecycleImageView)this.mBackView, (String)this.mPacketInfo.getBigSuccUri());
        }
        this.mSendGiftView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                v.setEnabled(false);
                LiveRedPacketComponent.this.sendHiidoStatistic("0003");
                RxBus.getDefault().post((Object)new ShowGiftCompoentEventArgs(LiveRedPacketComponent.this.mGiftPopType == 1));
                if (LiveRedPacketComponent.this.mGiftPopType == 1) {
                    ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).showGiftBag();
                }
                LiveRedPacketComponent.this.dismiss();
            }
        });
        this.mStorePacageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                v.setEnabled(false);
                LiveRedPacketComponent.this.sendHiidoStatistic("0004");
                LiveRedPacketComponent.this.dismissWithAnim();
            }
        });
    }

    private void showUnLoginPacket() {
        MLog.info((Object)TAG, (String)"showUnLoginPacket", (Object[])new Object[0]);
        this.sendHiidoStatistic("0001");
        this.mTipView.setVisibility(8);
        this.mSendGiftContainer.setVisibility(8);
        this.mLoginBtn.setVisibility(0);
        if (null != this.mPacketInfo) {
            this.mLoginBtn.setText((CharSequence)this.mPacketInfo.getUnloginMsg());
            ImageLoader.loadImage((RecycleImageView)this.mBackView, (String)this.mPacketInfo.getBigUnloginUri());
        }
        this.mLoginBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiveRedPacketComponent.this.sendHiidoStatistic("0002");
                LoginUtil.showLoginDialog((Context)LiveRedPacketComponent.this.getActivity());
            }
        });
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        if (null != this.mLoginBtn) {
            this.mLoginBtn.setEnabled(false);
        }
        this.startGetLivePacket();
    }

    private boolean startGetLivePacket() {
        if (null != this.mGetPacketReq && !this.mGetPacketReq.isDisposed()) {
            return true;
        }
        if (null == this.mPacketInfo) {
            return false;
        }
        long aid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        if (aid <= 0L) {
            return false;
        }
        this.mGetPacketReq = ((IRewardCore)ICoreManagerBase.getCore(IRewardCore.class)).getLivePacket(aid, this.mPacketInfo.getId(), null).subscribe((Consumer)new Consumer<RewardProtocol.LiveGetPacketResp>(){

            public void accept(RewardProtocol.LiveGetPacketResp liveGetPacketResp) throws Exception {
                MLog.info((Object)LiveRedPacketComponent.TAG, (String)("startGetLivePacket->result:" + liveGetPacketResp.resultCode + ",businessCode:" + liveGetPacketResp.busiCode + ",message:" + liveGetPacketResp.message), (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new GetRedPacketEventArgs(liveGetPacketResp.resultCode == 0 && liveGetPacketResp.busiCode == 0, (BasePacketInfo)LiveRedPacketComponent.this.mPacketInfo));
                if (liveGetPacketResp.resultCode != 0 || liveGetPacketResp.busiCode != 0) {
                    LiveRedPacketComponent.this.mTipMsg = TextUtils.isEmpty((CharSequence)liveGetPacketResp.message) ? "\u7ea2\u5305\u9886\u53d6\u5931\u8d25" : liveGetPacketResp.message;
                    LiveRedPacketComponent.this.showError();
                } else {
                    LiveRedPacketComponent.this.mGiftPopType = liveGetPacketResp.popType;
                    LiveRedPacketComponent.this.showLoginPacket();
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)LiveRedPacketComponent.TAG, (Throwable)throwable);
                LiveRedPacketComponent.this.mTipMsg = "\u7ea2\u5305\u9886\u53d6\u5931\u8d25";
                LiveRedPacketComponent.this.showError();
            }
        });
        return true;
    }

    private void dismissWithAnim() {
        if (null == this.getActivity() || null != this.mScaleAnimation && this.mScaleAnimation.hasStarted()) {
            return;
        }
        this.setCancelable(false);
        int[] viewPos = this.getViewPos((View)this.mBackView);
        int[] giftPos = this.getViewPos(this.getGiftView());
        this.mScaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 0, (float)(giftPos[0] - viewPos[0]), 0, (float)(giftPos[1] - viewPos[1]));
        this.mScaleAnimation.setDuration(800L);
        this.mScaleAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                if (null != LiveRedPacketComponent.this.mClostBtn) {
                    LiveRedPacketComponent.this.mClostBtn.setEnabled(false);
                }
                if (null != LiveRedPacketComponent.this.mSendGiftView) {
                    LiveRedPacketComponent.this.mSendGiftView.setEnabled(false);
                }
            }

            public void onAnimationEnd(Animation animation) {
                if (LiveRedPacketComponent.this.isShowing()) {
                    LiveRedPacketComponent.this.dismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        if (null != this.mRootView) {
            this.mRootView.startAnimation((Animation)this.mScaleAnimation);
        }
    }

    private View getGiftView() {
        if (null == this.getActivity()) {
            return null;
        }
        return this.getActivity().findViewById(R.id.icon_gift);
    }

    private int[] getViewPos(@Nonnull View view) {
        int[] location = new int[2];
        if (null != view) {
            view.getLocationInWindow(location);
        } else {
            location[0] = ResolutionUtils.getScreenWidth((Context)this.getContext());
            location[1] = ResolutionUtils.getScreenHeight((Context)this.getContext());
        }
        return location;
    }

    public void onDestroyView() {
        if (null != this.mGetPacketReq && !this.mGetPacketReq.isDisposed()) {
            this.mGetPacketReq.dispose();
        }
        if (null != this.mScaleAnimation) {
            this.mScaleAnimation.cancel();
        }
        ((ILiveRewardCore)ICoreManagerBase.getCore(ILiveRewardCore.class)).startRegistBusEvent();
        super.onDestroyView();
    }

    private void sendHiidoStatistic(String label) {
        Property property = new Property();
        property.putString("key1", null == this.mPacketInfo ? "" : this.mPacketInfo.getId() + "");
        if (null != ICoreManagerBase.getChannelLinkCore() && null != ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo()) {
            property.putString("key2", ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid + "");
        }
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51048", label, (Serializable)property);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mLiveRedPacketComponentSniperEventBinder == null) {
            this.mLiveRedPacketComponentSniperEventBinder = new LiveRedPacketComponent$$EventBinder();
        }
        this.mLiveRedPacketComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mLiveRedPacketComponentSniperEventBinder != null) {
            this.mLiveRedPacketComponentSniperEventBinder.unBindEvent();
        }
    }
}

