/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.record;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewFragmentInterface;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.core.ICoreManagerBase;

public class RecordPopupComponent
extends PopupComponent {
    public static final String TAG = "RecordPopupComponent";
    private View rootView;
    private View mWebviewLayout;
    private boolean isDismissed = true;
    private BaseLinkFragment mBaseLinkFragment;
    private View mBenchReloadView;
    private IWebViewFragmentInterface mWebViewFragmentInterface;
    private boolean isLoadSuccessed = false;
    private String url;

    public static RecordPopupComponent newInstance() {
        RecordPopupComponent component = new RecordPopupComponent();
        return component;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.rootView = inflater.inflate(R.layout.fragment_recordpoup_layout, container, false);
        this.mWebviewLayout = this.rootView.findViewById(R.id.record_entrance_webview);
        this.url = "http://pubgquery.yy.com/start.html?uid=" + ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        this.mBaseLinkFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(this.url, true);
        MLog.info((Object)TAG, (String)("url = " + this.url), (Object[])new Object[0]);
        this.mBenchReloadView = this.rootView.findViewById(R.id.ll_bench_reload_layout);
        this.mBenchReloadView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!RecordPopupComponent.this.isLoadSuccessed && RecordPopupComponent.this.mWebViewFragmentInterface != null) {
                    RecordPopupComponent.this.mWebViewFragmentInterface.setUrl(RecordPopupComponent.this.url);
                }
            }
        });
        if (this.mBaseLinkFragment != null) {
            this.mWebViewFragmentInterface = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).getWebViewFragmentMethod(this.mBaseLinkFragment);
            if (this.mWebViewFragmentInterface != null) {
                this.mWebViewFragmentInterface.setEnablePullRefresh(false);
                this.mWebViewFragmentInterface.setWebViewEventLister((IWebViewEventListener)new WebViewEventListener(){

                    public void onViewCreated(View view) {
                        WebView webView;
                        if (RecordPopupComponent.this.mWebViewFragmentInterface != null && (webView = RecordPopupComponent.this.mWebViewFragmentInterface.getWebView()) != null) {
                            webView.setHorizontalScrollBarEnabled(false);
                            webView.setVerticalScrollBarEnabled(false);
                        }
                    }

                    public void onPageFinished(WebView view, String url) {
                        RecordPopupComponent.this.isLoadSuccessed = true;
                        if (RecordPopupComponent.this.mBenchReloadView != null && RecordPopupComponent.this.mWebviewLayout != null) {
                            RecordPopupComponent.this.mWebviewLayout.setVisibility(0);
                            RecordPopupComponent.this.mBenchReloadView.setVisibility(8);
                        }
                    }

                    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                        RecordPopupComponent.this.isLoadSuccessed = false;
                        if (RecordPopupComponent.this.mBenchReloadView != null && RecordPopupComponent.this.mWebviewLayout != null) {
                            RecordPopupComponent.this.mWebviewLayout.setVisibility(8);
                            RecordPopupComponent.this.mBenchReloadView.setVisibility(0);
                        }
                        MLog.error((Object)RecordPopupComponent.TAG, (String)("onReceivedError errorCode = " + errorCode + " description = " + description + " failingUrl = " + failingUrl), (Object[])new Object[0]);
                    }
                });
            }
        }
        FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
        if (this.mBaseLinkFragment.isDetached()) {
            ft.attach((Fragment)this.mBaseLinkFragment);
            ft.commitAllowingStateLoss();
        } else if (!this.mBaseLinkFragment.isAdded()) {
            ft.add(R.id.record_entrance_webview, (Fragment)this.mBaseLinkFragment);
            ft.commitAllowingStateLoss();
        }
        return this.rootView;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog mDialog = super.onCreateDialog(savedInstanceState);
        mDialog.setCanceledOnTouchOutside(true);
        mDialog.requestWindowFeature(1);
        mDialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        mDialog.getWindow().setWindowAnimations(R.style.slide_shake_animation);
        mDialog.getWindow().setFlags(1024, 1024);
        if (this.getResources().getConfiguration().orientation == 1) {
            mDialog.getWindow().setLayout(-1, (int)ResolutionUtils.convertDpToPixel((float)300.0f, (Context)this.getContext()));
            mDialog.getWindow().setGravity(80);
        } else {
            mDialog.getWindow().setLayout(this.getResources().getDisplayMetrics().widthPixels / 2, -1);
            mDialog.getWindow().setGravity(5);
        }
        mDialog.getWindow().clearFlags(2);
        return mDialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.isDismissed = true;
    }

    public void show(FragmentManager manager, String tag) {
        if (this.isDismissed) {
            try {
                FragmentTransaction transaction = manager.beginTransaction();
                transaction.add((Fragment)this, tag);
                transaction.commitAllowingStateLoss();
                this.isDismissed = false;
            }
            catch (IllegalStateException e) {
                MLog.error((Object)TAG, (String)("checkFragmentManager IllegalStateException " + e), (Object[])new Object[0]);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("checkFragmentManager Exception " + e), (Object[])new Object[0]);
            }
        }
    }
}

