/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.ResolutionUtils;

public class RevenueMarqueeLayout
extends FrameLayout {
    private static final String TAG = "RevenueMarqueeLayout";
    private Context mContext;
    protected TextView mTextView;
    protected AnimatorSet animatorSet;
    protected boolean isMarque = false;
    protected float mSpeed = 3.0f;
    protected int mMarqueWidth = 600;
    protected long mMaxDuration = 5000L;
    protected long mMaxComboTaskDuration = 6000L;
    protected long mDuration = 5000L;
    protected long mDelayStart = 500L;
    private int mMargin = 15;
    protected int mTicketWidth = 98;
    protected boolean isLastTicket = false;
    protected boolean isComboTask = false;
    protected long commonMsgDuration = 0L;

    public RevenueMarqueeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mMarqueWidth = ResolutionUtils.getScreenWidth((Context)context) - DensityUtil.dip2px((Context)context, (float)140.0f) - DensityUtil.dip2px((Context)context, (float)this.mMargin);
        this.mTicketWidth = DensityUtil.dip2px((Context)context, (float)49.0f) - (int)ResolutionUtils.convertDpToPixel((float)7.5f, (Context)this.mContext);
    }

    public void setComboTask(boolean comboTask) {
        this.isComboTask = comboTask;
    }

    public void setCommonMsgDuration(long commonMsgDuration) {
        this.commonMsgDuration = commonMsgDuration;
    }

    public void setMarqueWidth(int width) {
        if ((width -= DensityUtil.dip2px((Context)this.getContext(), (float)this.mMargin)) < 0) {
            return;
        }
        this.mMarqueWidth = width;
    }

    protected void startMarquee(boolean withTicket) {
        this.reserverAnimation();
        if (this.mTextView != null) {
            TextPaint paint = this.mTextView.getPaint();
            CharSequence content = this.mTextView.getText();
            float len = Layout.getDesiredWidth((CharSequence)content, (TextPaint)paint);
            int marqueWidth = 0;
            if (this.getMeasuredWidth() > 0 && !this.isLastTicket) {
                this.mMarqueWidth = marqueWidth = this.getMeasuredWidth();
            } else {
                marqueWidth = this.mMarqueWidth;
            }
            if (withTicket) {
                marqueWidth -= this.mTicketWidth;
            }
            if (this.isComboTask) {
                marqueWidth = 500;
                this.mSpeed = 8.0f;
            }
            this.isLastTicket = withTicket;
            if (len >= (float)marqueWidth) {
                this.isMarque = true;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)len, -2);
                this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.animatorSet = new AnimatorSet();
                int scrollWidth = (int)(-len + (float)marqueWidth);
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mTextView, (String)"translationX", (float[])new float[]{0.0f, scrollWidth});
                this.mDuration = (long)(this.mSpeed * (float)Math.abs(scrollWidth));
                if (this.isComboTask) {
                    if (this.mDuration > this.mMaxComboTaskDuration) {
                        this.mDuration = this.mMaxComboTaskDuration;
                    }
                } else if (this.mDuration > this.mMaxDuration) {
                    this.mDuration = this.mMaxDuration;
                }
                if (this.commonMsgDuration > 0L) {
                    this.mDuration = this.commonMsgDuration;
                }
                objectAnimator.setDuration(this.mDuration);
                objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.animatorSet.play((Animator)objectAnimator);
                this.animatorSet.setStartDelay(this.mDelayStart);
                this.animatorSet.start();
            } else {
                this.isMarque = false;
            }
        }
    }

    public void reserverAnimation() {
        if (this.animatorSet != null) {
            this.animatorSet.end();
            this.animatorSet = null;
        }
        if (this.mTextView != null) {
            this.mTextView.setTranslationX(0.0f);
        }
    }

    public void setText(CharSequence content, int ticketWidth, boolean withTicket) {
        if (this.mTextView == null) {
            this.mTextView = (TextView)this.getChildAt(0);
        }
        if (this.mTextView == null && this.mContext != null) {
            this.mTextView = new TextView(this.mContext);
            this.mTextView.setSingleLine(true);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -2);
            this.addView((View)this.mTextView, lp);
        }
        if (this.mTextView != null) {
            if (withTicket && ticketWidth > 0) {
                this.mTicketWidth = ticketWidth;
            }
            this.mTextView.setText(content);
            this.startMarquee(withTicket);
        }
    }

    public void setTextDelay(CharSequence content, int ticketWidth, final boolean withTicket, long duration) {
        if (this.mTextView == null) {
            this.mTextView = (TextView)this.getChildAt(0);
        }
        if (this.mTextView == null && this.mContext != null) {
            this.mTextView = new TextView(this.mContext);
            this.mTextView.setSingleLine(true);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -2);
            this.addView((View)this.mTextView, lp);
        }
        if (this.mTextView != null) {
            if (withTicket && ticketWidth > 0) {
                this.mTicketWidth = ticketWidth;
            }
            this.mTextView.setText(content);
            if (this.getHandler() != null) {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RevenueMarqueeLayout.this.startMarquee(withTicket);
                    }
                }, duration);
            } else {
                this.startMarquee(withTicket);
            }
        }
    }

    public boolean isMarque() {
        return this.isMarque;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setMaxDuration(long max) {
        this.mMaxDuration = max;
    }
}

