/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat;

import java.util.Comparator;
import java.util.concurrent.locks.ReentrantLock;

public class PriorityBlockingDequeue<T> {
    int limit = 11;
    Comparator<? super T> comparator;
    ReentrantLock lock;
    Object[] objects;
    int size;

    public PriorityBlockingDequeue(int limit, Comparator<? super T> comparator) {
        this.limit = limit;
        this.comparator = comparator;
        this.lock = new ReentrantLock();
        this.objects = new Object[limit];
    }

    public T poll() {
        this.lock.lock();
        try {
            if (this.size > 0 && this.size <= this.limit) {
                Object o = this.objects[0];
                for (int i = 0; i < this.size - 1; ++i) {
                    this.objects[i] = this.objects[i + 1];
                }
                --this.size;
                Object object = o;
                return (T)object;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public T remove() {
        this.lock.lock();
        try {
            if (this.size > 0 && this.size <= this.limit) {
                Object o = this.objects[this.size - 1];
                this.objects[this.size - 1] = null;
                --this.size;
                Object object = o;
                return (T)object;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T item2) {
        if (item2 == null || this.comparator == null) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl;
            for (int i = 0; i < this.size; ++i) {
                Object o = this.objects[i];
                if (this.comparator.compare(o, item2) >= 0) continue;
                boolean bl2 = this.insert(item2, i);
                return bl2;
            }
            if (this.size == this.limit) {
                bl = false;
                return bl;
            }
            this.objects[this.size] = item2;
            ++this.size;
            bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean insert(T item2, int index) {
        if (item2 == null || index < 0 || index > this.size) {
            return false;
        }
        if (this.size == this.limit) {
            this.remove();
        }
        for (int i = this.size - 1; i >= index; --i) {
            this.objects[i + 1] = this.objects[i];
        }
        this.objects[index] = item2;
        ++this.size;
        return true;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.size = 0;
            for (int i = 0; i < this.limit; ++i) {
                this.objects[i] = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.size == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            int n = this.size;
            if (this.size == 0) {
                String string2 = "[]";
                return string2;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < n; ++i) {
                Object e = this.objects[i];
                sb.append(e == this ? "(this Collection)" : e);
                if (i == n - 1) continue;
                sb.append(',').append(' ');
            }
            String string3 = sb.append(']').toString();
            return string3;
        }
        finally {
            this.lock.unlock();
        }
    }
}

