/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.programinfo;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.IntEvaluator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IProgramInfoClient_onScheduleNextLiveBroadcast_EventArgs;
import com.duowan.mobile.entlive.events.IProgramInfoClient_showContributionNms_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.programinfo.OfficialPrevAnimManager$$EventBinder;
import com.yy.mobile.ui.programinfo.data.NextLiveInfo;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channelofficialInfo.IChannelOfficialInfoCore;
import org.json.JSONObject;

public class OfficialPrevAnimManager
implements EventCompat {
    private static final String TAG = "OfficialPrevAnimManager";
    private static final int animDuration = 500;
    public boolean isShowContributionNms = true;
    private Context mContext;
    private Handler mHandler;
    private View mRootView;
    private TextView tvProgramInfoTxt;
    private RelativeLayout mPreViewContainer;
    private TextView tvNextTitle;
    private TextView tvNextNickName;
    private RelativeLayout rlNextAnchorInfo;
    private NextLiveInfo mNextLiveInfo;
    private boolean isCurrentShow = false;
    private int livePreviewWidth = 0;
    private IChannelLinkCore channelLinkCore;
    private boolean isInitReqPreLiveData = false;
    private Runnable mScheduleNextLiveInfoTask = new Runnable(){

        @Override
        public void run() {
            MLog.info((Object)OfficialPrevAnimManager.TAG, (String)("[mScheduleNextLiveInfoTask run] isCurrentShow=" + OfficialPrevAnimManager.this.isCurrentShow + ", mNextLiveInfo=" + OfficialPrevAnimManager.this.mNextLiveInfo), (Object[])new Object[0]);
            if (OfficialPrevAnimManager.this.isCurrentShow) {
                OfficialPrevAnimManager.this.hideNextLiveInfo();
            } else {
                OfficialPrevAnimManager.this.showNextLiveInfo();
            }
            if (OfficialPrevAnimManager.this.mHandler != null && OfficialPrevAnimManager.this.mNextLiveInfo != null && ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime > 0 && ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval > 0 && ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime > ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)OfficialPrevAnimManager.TAG, (String)"post mScheduleNextLiveInfoTask", (Object[])new Object[0]);
                }
                ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime -= ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval;
                OfficialPrevAnimManager.this.mHandler.removeCallbacks(OfficialPrevAnimManager.this.mScheduleNextLiveInfoTask);
                OfficialPrevAnimManager.this.mHandler.postDelayed(OfficialPrevAnimManager.this.mScheduleNextLiveInfoTask, (long)(((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval * 1000));
            } else {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)OfficialPrevAnimManager.TAG, (String)"stop mScheduleNextLiveInfoTask", (Object[])new Object[0]);
                }
                OfficialPrevAnimManager.this.isInitReqPreLiveData = false;
                ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime = 0;
                ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval = 0;
                OfficialPrevAnimManager.this.hideNextLiveInfo();
            }
        }
    };
    private EventBinder mOfficialPrevAnimManagerSniperEventBinder;

    public void onEventBind() {
        if (this.mOfficialPrevAnimManagerSniperEventBinder == null) {
            this.mOfficialPrevAnimManagerSniperEventBinder = new OfficialPrevAnimManager$$EventBinder();
        }
        this.mOfficialPrevAnimManagerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mOfficialPrevAnimManagerSniperEventBinder != null) {
            this.mOfficialPrevAnimManagerSniperEventBinder.unBindEvent();
        }
    }

    public OfficialPrevAnimManager(Context mContext, Handler mHandler2, View mRootView, RelativeLayout mPreViewContainer) {
        ICoreManagerBase.addClient((Object)this);
        this.mContext = mContext;
        this.mHandler = mHandler2;
        this.mRootView = mRootView;
        this.mPreViewContainer = mPreViewContainer;
        this.init();
    }

    public void init() {
        this.assignNextLiveView();
        if (this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!OfficialPrevAnimManager.this.isInitReqPreLiveData) {
                        OfficialPrevAnimManager.this.reqNextLiveInfo();
                        OfficialPrevAnimManager.this.isInitReqPreLiveData = true;
                    }
                }
            }, 800L);
        }
    }

    private void assignNextLiveView() {
        if (this.mRootView != null) {
            this.tvProgramInfoTxt = (TextView)this.mRootView.findViewById(R.id.program_info_txt);
            this.rlNextAnchorInfo = (RelativeLayout)this.mRootView.findViewById(R.id.rl_next_channel_pre);
            this.tvNextTitle = (TextView)this.mRootView.findViewById(R.id.tv_next_title);
            this.tvNextNickName = (TextView)this.mRootView.findViewById(R.id.tv_next_nickname);
            this.rlNextAnchorInfo.setVisibility(4);
        }
        this.mNextLiveInfo = new NextLiveInfo();
    }

    public void reqNextLiveInfo() {
        if (this.channelLinkCore == null) {
            this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
        }
        long topSid = this.channelLinkCore.getCurrentChannelInfo().topSid;
        long subSid = this.channelLinkCore.getCurrentChannelInfo().subSid;
        boolean isOfficialChannel = ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).isOfficialProgram(topSid);
        MLog.info((Object)TAG, (String)("[reqNextLiveInfo] topSid=" + topSid + ", subSid=" + subSid + ", isOfficialChannel=" + isOfficialChannel), (Object[])new Object[0]);
        if (isOfficialChannel) {
            String url = LinkUriProvider.OFFICIAL_PROGRAM_NEXT + "/" + topSid + "/" + subSid;
            NextLiveResponse mNextLiveResponse = new NextLiveResponse();
            RequestManager.instance().submitStringQueryRequest(url, null, (ResponseListener)mNextLiveResponse, (ResponseErrorListener)mNextLiveResponse, true);
        }
    }

    private void retriveNextLiveInfo(String response) {
        if (!StringUtils.isNullOrEmpty((String)response)) {
            try {
                JSONObject jsonObject = new JSONObject(response);
                if (jsonObject.getString("code") != null && StringUtils.equal((String)"0", (String)jsonObject.getString("code")) && !StringUtils.isEmpty((String)jsonObject.getString("data")).booleanValue()) {
                    JSONObject dataJson = jsonObject.getJSONObject("data");
                    this.mNextLiveInfo.nextAnchorName = dataJson.getString("name");
                    this.mNextLiveInfo.nextAnchorUid = dataJson.getString("uid");
                    this.mNextLiveInfo.leftTime = dataJson.getInt("timeLeft");
                    this.mNextLiveInfo.timeInterval = dataJson.getInt("timeInterval");
                    this.mNextLiveInfo.type = 1;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on retriveNextLiveInfo", (Throwable)e);
            }
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[onJoinChannelSuccess] reqNextLiveInfo", (Object[])new Object[0]);
        }
        if (this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!OfficialPrevAnimManager.this.isInitReqPreLiveData) {
                        OfficialPrevAnimManager.this.reqNextLiveInfo();
                        OfficialPrevAnimManager.this.isInitReqPreLiveData = true;
                    }
                }
            }, 1000L);
        }
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.initPreLiveAnimData();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onScheduleNextLiveBroadcast(IProgramInfoClient_onScheduleNextLiveBroadcast_EventArgs busEventArgs) {
        NextLiveInfo nextLiveInfo = busEventArgs.mNextLiveInfo;
        MLog.info((Object)TAG, (String)("[onScheduleNextLiveBroadcast] nextLiveInfo=" + nextLiveInfo + ", current mNextLiveInfo=" + this.mNextLiveInfo), (Object[])new Object[0]);
        if (nextLiveInfo != null) {
            if (nextLiveInfo.type == 0) {
                this.initPreLiveAnimData();
            } else {
                this.mNextLiveInfo = nextLiveInfo;
                this.updateNextLiveInfo();
                this.showNextLiveInfo();
                int tempTime = this.mNextLiveInfo.timeInterval;
                if (this.mNextLiveInfo != null && this.mNextLiveInfo.timeInterval >= this.mNextLiveInfo.leftTime) {
                    this.mNextLiveInfo.timeInterval = 0;
                    this.mNextLiveInfo.leftTime = 0;
                }
                if (this.mHandler != null && this.mNextLiveInfo != null) {
                    this.mHandler.removeCallbacks(this.mScheduleNextLiveInfoTask);
                    this.mHandler.postDelayed(this.mScheduleNextLiveInfoTask, (long)(tempTime * 1000));
                }
            }
        }
    }

    public void updateNextLiveInfo() {
        if (!StringUtils.isEmpty((String)this.mNextLiveInfo.nextAnchorName).booleanValue()) {
            this.tvNextNickName.setText((CharSequence)this.mNextLiveInfo.nextAnchorName);
        }
    }

    private void showNextLiveInfo() {
        if (this.mPreViewContainer != null) {
            int width = this.mPreViewContainer.getWidth();
            int measuredWidth = this.mPreViewContainer.getMeasuredWidth();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("[showNextLiveInfo] getMeasuredWidth measuredWidth=" + measuredWidth + ", width=" + width), (Object[])new Object[0]);
            }
            int marginLeft = (int)ResolutionUtils.convertDpToPixel((float)65.0f, (Context)this.mContext);
            if (measuredWidth > 0 && measuredWidth - marginLeft > 0) {
                this.livePreviewWidth = measuredWidth - marginLeft;
            }
        }
        if (this.rlNextAnchorInfo != null) {
            int curWidth = this.rlNextAnchorInfo.getMeasuredWidth();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("[showNextLiveInfo] curWidth=" + curWidth + ", livePreviewWidth=" + this.livePreviewWidth), (Object[])new Object[0]);
            }
            this.performAnimShow(0, this.livePreviewWidth);
        }
        this.isCurrentShow = true;
    }

    private void hideNextLiveInfo() {
        if (this.rlNextAnchorInfo != null) {
            int curWidth = this.rlNextAnchorInfo.getMeasuredWidth();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("[hideNextLiveInfo] curWidth=" + curWidth + ", livePreviewWidth=" + this.livePreviewWidth), (Object[])new Object[0]);
            }
            this.performAnimHide(this.livePreviewWidth, 0);
        }
        this.isCurrentShow = false;
    }

    private void performAnimShow(int ... widths) {
        if (this.tvProgramInfoTxt == null || this.rlNextAnchorInfo == null) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[performAnimShow] rlNextAnchorInfo VISIBLE ? " + (this.rlNextAnchorInfo.getVisibility() == 0)), (Object[])new Object[0]);
        }
        try {
            ObjectAnimator animProgTxtAlpha = ObjectAnimator.ofFloat((Object)this.tvProgramInfoTxt, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(500L);
            ObjectAnimator animShowAlpha = ObjectAnimator.ofFloat((Object)this.rlNextAnchorInfo, (String)"alpha", (float[])new float[]{0.8f, 1.0f}).setDuration(500L);
            ViewWrapper wrapper = new ViewWrapper((View)this.rlNextAnchorInfo);
            ValueAnimator animShow2 = this.buildWidthPropAnim((View)this.rlNextAnchorInfo, widths[0], widths[1]);
            AnimatorSet animSet = new AnimatorSet();
            animSet.play((Animator)animShow2).with((Animator)animShowAlpha).with((Animator)animProgTxtAlpha);
            animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    OfficialPrevAnimManager.this.isShowContributionNms = false;
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimShow onAnimationStart", (Object[])new Object[0]);
                    if (OfficialPrevAnimManager.this.rlNextAnchorInfo != null) {
                        OfficialPrevAnimManager.this.rlNextAnchorInfo.setVisibility(0);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimShow onAnimationEnd", (Object[])new Object[0]);
                    if (OfficialPrevAnimManager.this.rlNextAnchorInfo != null) {
                        OfficialPrevAnimManager.this.livePreviewWidth = OfficialPrevAnimManager.this.rlNextAnchorInfo.getMeasuredWidth();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimShow onAnimationCancel", (Object[])new Object[0]);
                }
            });
            animSet.start();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"[performAnimShow] perform show next live anim error!", (Object[])new Object[0]);
        }
    }

    private void performAnimHide(int ... widths) {
        if (this.tvProgramInfoTxt == null || this.rlNextAnchorInfo == null) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[performAnimHide] rlNextAnchorInfo VISIBLE ? " + (this.rlNextAnchorInfo.getVisibility() == 0)), (Object[])new Object[0]);
        }
        try {
            ObjectAnimator animProgTxtAlpha = ObjectAnimator.ofFloat((Object)this.tvProgramInfoTxt, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(500L);
            ObjectAnimator animHideAlpha = ObjectAnimator.ofFloat((Object)this.rlNextAnchorInfo, (String)"alpha", (float[])new float[]{1.0f, 0.8f}).setDuration(500L);
            ViewWrapper wrapper = new ViewWrapper((View)this.rlNextAnchorInfo);
            ValueAnimator animHide2 = this.buildWidthPropAnim((View)this.rlNextAnchorInfo, widths[0], widths[1]);
            AnimatorSet animSet = new AnimatorSet();
            animSet.play((Animator)animHide2).with((Animator)animHideAlpha).with((Animator)animProgTxtAlpha);
            animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    OfficialPrevAnimManager.this.isShowContributionNms = true;
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimHide onAnimationStart", (Object[])new Object[0]);
                    PluginBus.INSTANCE.get().post((Object)new IProgramInfoClient_showContributionNms_EventArgs(OfficialPrevAnimManager.this.isShowContributionNms));
                }

                public void onAnimationEnd(Animator animation) {
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimHide onAnimationEnd", (Object[])new Object[0]);
                    if (OfficialPrevAnimManager.this.rlNextAnchorInfo != null) {
                        OfficialPrevAnimManager.this.rlNextAnchorInfo.setVisibility(4);
                        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)OfficialPrevAnimManager.this.rlNextAnchorInfo.getLayoutParams();
                        layoutParams.width = 0;
                        OfficialPrevAnimManager.this.rlNextAnchorInfo.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    MLog.info((Object)OfficialPrevAnimManager.TAG, (String)"performAnimHide onAnimationCancel", (Object[])new Object[0]);
                }
            });
            animSet.start();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"[performAnimShow] perform hide next live anim error!", (Object[])new Object[0]);
        }
    }

    private void initPreLiveAnimData() {
        MLog.info((Object)TAG, (String)"[initPreLiveAnimData]", (Object[])new Object[0]);
        if (this.mHandler != null && this.mScheduleNextLiveInfoTask != null) {
            this.mHandler.removeCallbacks(this.mScheduleNextLiveInfoTask);
            this.isInitReqPreLiveData = false;
        }
        if (this.mNextLiveInfo != null) {
            this.mNextLiveInfo.clear();
        }
        if (this.tvProgramInfoTxt != null) {
            this.tvProgramInfoTxt.setAlpha(1.0f);
        }
        if (this.rlNextAnchorInfo != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.rlNextAnchorInfo.getLayoutParams();
            layoutParams.width = 0;
            this.rlNextAnchorInfo.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.rlNextAnchorInfo.setVisibility(4);
        }
        this.isCurrentShow = false;
    }

    private ValueAnimator buildWidthPropAnim(final View target2, final int start, final int end) {
        ValueAnimator valueAnimator = null;
        try {
            valueAnimator = ValueAnimator.ofInt((int[])new int[]{1, 100});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                private IntEvaluator mEvaluator = new IntEvaluator();

                public void onAnimationUpdate(ValueAnimator animator) {
                    int currentValue = (Integer)animator.getAnimatedValue();
                    float fraction = (float)currentValue / 100.0f;
                    target2.getLayoutParams().width = this.mEvaluator.evaluate(fraction, Integer.valueOf(start), Integer.valueOf(end));
                    target2.requestLayout();
                }
            });
            valueAnimator.setDuration(500L).start();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"[buildWidthPropAnim] error!", (Object[])new Object[0]);
        }
        return valueAnimator;
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)this);
        this.isInitReqPreLiveData = false;
        this.mContext = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mScheduleNextLiveInfoTask);
            this.mHandler = null;
            this.mScheduleNextLiveInfoTask = null;
        }
        this.mRootView = null;
        this.mPreViewContainer = null;
        this.tvNextTitle = null;
        this.tvNextNickName = null;
        this.rlNextAnchorInfo = null;
        this.mNextLiveInfo = null;
        this.isCurrentShow = false;
        this.livePreviewWidth = 0;
        this.channelLinkCore = null;
    }

    class NextLiveResponse
    implements ResponseListener<String>,
    ResponseErrorListener {
        NextLiveResponse() {
        }

        public void onResponse(String response) {
            MLog.info((Object)OfficialPrevAnimManager.TAG, (String)("Req NextLiveResponse success! response = " + response), (Object[])new Object[0]);
            if (OfficialPrevAnimManager.this.mNextLiveInfo == null) {
                OfficialPrevAnimManager.this.mNextLiveInfo = new NextLiveInfo();
            }
            OfficialPrevAnimManager.this.retriveNextLiveInfo(response);
            if (((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval == 0 || ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime == 0 || StringUtils.isEmpty((String)((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.nextAnchorUid).booleanValue()) {
                return;
            }
            OfficialPrevAnimManager.this.updateNextLiveInfo();
            OfficialPrevAnimManager.this.showNextLiveInfo();
            int tempTime = ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval;
            if (OfficialPrevAnimManager.this.mNextLiveInfo != null && ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval >= ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime) {
                ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.timeInterval = 0;
                ((OfficialPrevAnimManager)OfficialPrevAnimManager.this).mNextLiveInfo.leftTime = 0;
            }
            if (OfficialPrevAnimManager.this.mHandler != null && OfficialPrevAnimManager.this.mNextLiveInfo != null) {
                OfficialPrevAnimManager.this.mHandler.removeCallbacks(OfficialPrevAnimManager.this.mScheduleNextLiveInfoTask);
                OfficialPrevAnimManager.this.mHandler.postDelayed(OfficialPrevAnimManager.this.mScheduleNextLiveInfoTask, (long)(tempTime * 1000));
            }
        }

        public void onErrorResponse(RequestError error) {
            MLog.info((Object)OfficialPrevAnimManager.TAG, (String)("Req NextLiveResponse failed! error = " + error), (Object[])new Object[0]);
        }
    }

    @DontProguardClass
    private static class ViewWrapper {
        private View mTarget;

        ViewWrapper(View target2) {
            this.mTarget = target2;
        }

        public int getWidth() {
            return this.mTarget.getLayoutParams().width;
        }

        public void setWidth(int width) {
            this.mTarget.getLayoutParams().width = width;
            this.mTarget.requestLayout();
        }
    }
}

