/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.ui.chatemotion.HotWordsListAdapter;
import com.yy.mobile.ui.chatemotion.SendChatPresenter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.List;

public class HotwordPopupWindow
extends PopupWindow {
    private Activity activity;
    private View mHotWordsView;
    private TextView mHotWordsLoading;
    private ListView mHotWordsListView;
    private HotWordsListAdapter mHotWordsListAdapter;
    private SendChatPresenter mSendPresenter;
    private int mDataSize = 0;
    private AdapterView.OnItemClickListener mHotWordsOnItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> var1, View var2, int position, long id2) {
            HotwordPopupWindow.this.dismissPopupAmountList();
            String strMessage = HotwordPopupWindow.this.mHotWordsListAdapter.getItemText(position);
            if (!TextUtils.isEmpty((CharSequence)strMessage)) {
                HotwordPopupWindow.this.mSendPresenter.onPreSendMessage(strMessage, null, new boolean[]{true}, "1");
                LoginFollowGuideManager.instance().showFollowGuide(1);
                if (HotwordPopupWindow.this.mHotWordsListAdapter.getItemViewType(position) == 0) {
                    Property property = new Property();
                    property.putString("key1", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid));
                    property.putString("key3", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0004", (Serializable)property);
                }
                if (strMessage.equals("1") || strMessage.equals("2")) {
                    ChannelInfo channelInfo = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
                    Property property = new Property();
                    property.putString("key1", String.valueOf(channelInfo.topSid));
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic_Channel(LoginUtil.getUid(), "51001", "0016", (Serializable)property);
                }
            }
        }
    };
    private static final int MAX_DATA_SIZE = 6;
    private static final int DEFAULT_TOW_DATA = 2;

    public HotwordPopupWindow(Activity activity, int dataSize) {
        super((Context)activity);
        this.activity = activity;
        this.mDataSize = dataSize;
        this.mSendPresenter = new SendChatPresenter((Context)activity);
        this.mHotWordsListAdapter = new HotWordsListAdapter((Context)activity);
    }

    private static Rect locateView(View v) {
        int[] locInt = new int[2];
        if (v == null) {
            return null;
        }
        try {
            v.getLocationOnScreen(locInt);
        }
        catch (NullPointerException npe) {
            return null;
        }
        Rect location = new Rect();
        location.left = locInt[0];
        location.top = locInt[1];
        location.right = location.left + v.getWidth();
        location.bottom = location.top + v.getHeight();
        return location;
    }

    public void show(View anchor, boolean isLandscape) {
        double heightPercent;
        Rect rect = HotwordPopupWindow.locateView(anchor);
        if (rect == null) {
            return;
        }
        this.initHotWordsListPopupWindow(isLandscape);
        int x = rect.left - this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_left);
        int y = (anchor.getHeight() + rect.height()) / 2 + this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_bottom);
        double d2 = heightPercent = this.mDataSize >= 6 ? 1.0 : (double)(this.mDataSize + 2) * 1.0 / 8.0;
        if (isLandscape) {
            DisplayMetrics metrics = new DisplayMetrics();
            this.activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            x = rect.right + this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_left_landscape);
            y = (int)ResolutionUtils.convertDpToPixel((float)metrics.heightPixels, (Context)this.activity) - this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_bottom_landscape);
            this.mHotWordsView.setBackgroundResource(R.drawable.landscape_hot_words_list_bkg);
            this.setHeight((int)((double)this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_height_landscape) * heightPercent));
            this.showAtLocation(anchor, 0, x, y);
        } else {
            this.mHotWordsView.setBackgroundResource(R.drawable.hot_words_list_bkg);
            this.setHeight((int)((double)this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_height) * heightPercent));
            this.showAtLocation(anchor, 83, x, y);
        }
    }

    public void initHotWordsListPopupWindow(boolean isLandscape) {
        if (this.mHotWordsView == null) {
            this.mHotWordsView = this.activity.getLayoutInflater().inflate(R.layout.hot_words_list, null);
            this.mHotWordsLoading = (TextView)this.mHotWordsView.findViewById(R.id.hot_words_list_loading);
            this.mHotWordsListView = (ListView)this.mHotWordsView.findViewById(R.id.lv_hot_words_list);
            this.mHotWordsListView.setAdapter((ListAdapter)this.mHotWordsListAdapter);
            this.mHotWordsListView.setOnItemClickListener(this.mHotWordsOnItemClickListener);
            this.setContentView(this.mHotWordsView);
            this.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.setOutsideTouchable(true);
            this.setFocusable(true);
            if (isLandscape) {
                this.setAnimationStyle(R.style.left_popup_menu_animation);
            } else {
                this.setAnimationStyle(R.style.left_bottom_popup_scale_menu_animation);
            }
            this.setWidth(this.activity.getResources().getDimensionPixelSize(R.dimen.hot_words_list_width));
        }
    }

    private void dismissPopupAmountList() {
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    public void setHotWordsListView(List<String> list2) {
        if (this.mHotWordsListView == null || this.mHotWordsLoading == null) {
            return;
        }
        if (!FP.empty(list2) && list2.size() > 0) {
            this.mHotWordsLoading.setVisibility(8);
            this.mHotWordsListView.setVisibility(0);
            this.mHotWordsListAdapter.setListData(list2);
        } else {
            this.mHotWordsLoading.setVisibility(0);
            this.mHotWordsListView.setVisibility(8);
        }
    }
}

