/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter.authority;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.home.BasicFaceHelper;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.plugincenter.AuthorityUtil;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.core.plugincenter.PluginInfo;
import com.yymobile.core.role.RoleMobuleUtil;
import java.util.ArrayList;
import java.util.List;

public class AuthorityAdapter
extends BaseAdapter {
    public List<Long> mData;
    private LayoutInflater inflater;

    public AuthorityAdapter(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
        this.mData = new ArrayList<Long>();
    }

    public List<Long> getData() {
        return this.mData;
    }

    public void setData(List<Long> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    public void seSelectState(int state) {
        for (int i = 0; i < this.mData.size(); ++i) {
            PluginInfo.AuthorityInfo authorityInfo = (PluginInfo.AuthorityInfo)((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getUserInfos().get(this.mData.get(i));
            authorityInfo.select = state;
        }
        this.notifyDataSetChanged();
    }

    public List<Long> getSelectUid() {
        ArrayList<Long> selectUid = new ArrayList<Long>();
        for (int i = 0; i < this.mData.size(); ++i) {
            PluginInfo.AuthorityInfo authorityInfo = (PluginInfo.AuthorityInfo)((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getUserInfos().get(this.mData.get(i));
            if (authorityInfo.select != 1) continue;
            selectUid.add(this.mData.get(i));
        }
        return selectUid;
    }

    public int getCount() {
        return this.mData.size();
    }

    public Object getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHodler viewHodler;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.plugincenter_user_item, parent, false);
            viewHodler = new ViewHodler();
            viewHodler.headerImg = (CircleImageView)convertView.findViewById(R.id.iv_portrait);
            viewHodler.role = (ImageView)convertView.findViewById(R.id.role);
            viewHodler.nick = (TextView)convertView.findViewById(R.id.tv_nick_name);
            viewHodler.select = (CheckBox)convertView.findViewById(R.id.cb_select);
            viewHodler.itemView = convertView.findViewById(R.id.item_view);
            convertView.setTag((Object)viewHodler);
        } else {
            viewHodler = (ViewHodler)convertView.getTag();
        }
        final PluginInfo.AuthorityInfo authorityInfo = (PluginInfo.AuthorityInfo)((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getUserInfos().get(this.mData.get(position));
        if (authorityInfo != null) {
            if (!TextUtils.isEmpty((CharSequence)authorityInfo.iconUrl100x100)) {
                BasicFaceHelper.loadFace((String)authorityInfo.iconUrl100x100, (int)authorityInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)viewHodler.headerImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            } else if (!TextUtils.isEmpty((CharSequence)authorityInfo.iconUrl) || authorityInfo.iconIndex > 0) {
                BasicFaceHelper.loadFace((String)authorityInfo.iconUrl, (int)authorityInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)viewHodler.headerImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            } else {
                ImageLoader.loadImage((String)authorityInfo.iconUrl, (RecycleImageView)viewHodler.headerImg, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait, (int)R.drawable.default_portrait);
            }
            Drawable drawable2 = RoleMobuleUtil.getModuleDrawable((long)this.mData.get(position));
            if (drawable2 != null) {
                viewHodler.role.setVisibility(0);
                viewHodler.role.setImageDrawable(drawable2);
            } else {
                Drawable roleDrawable = AuthorityUtil.getRoleDrawable((int)authorityInfo.role, (boolean)authorityInfo.isMan());
                if (roleDrawable != null) {
                    viewHodler.role.setVisibility(0);
                    viewHodler.role.setImageDrawable(roleDrawable);
                } else {
                    viewHodler.role.setVisibility(8);
                }
            }
            viewHodler.nick.setText((CharSequence)authorityInfo.nick);
            if (authorityInfo.select == -1) {
                viewHodler.select.setVisibility(4);
            } else if (authorityInfo.select == 0) {
                viewHodler.select.setVisibility(0);
                viewHodler.select.setChecked(false);
            } else {
                viewHodler.select.setVisibility(0);
                viewHodler.select.setChecked(true);
            }
            viewHodler.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (authorityInfo.select == -1) {
                        return;
                    }
                    if (authorityInfo.select == 0) {
                        authorityInfo.select = 1;
                        viewHodler.select.setChecked(true);
                        viewHodler.select.setVisibility(0);
                    } else if (authorityInfo.select == 1) {
                        authorityInfo.select = 0;
                        viewHodler.select.setChecked(false);
                        viewHodler.select.setVisibility(0);
                    }
                }
            });
        }
        return convertView;
    }

    static class ViewHodler {
        public View itemView;
        public CircleImageView headerImg;
        public ImageView role;
        public TextView nick;
        public CheckBox select;

        ViewHodler() {
        }
    }
}

