/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.onlinebusiness;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_switchShowDanmuStatus_EventArgs;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.webview.purewebview.IPureWebview;
import com.yy.mobile.ui.webview.purewebview.PureWebviewUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.noble.EntIdentity;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OLBusinessWebViewController {
    private static final String TAG = "tag_webview";
    private RelativeLayout rootView;
    private Context context;
    private RelativeLayout wvLayout;
    private IPureWebview webView;
    private RelativeLayout.LayoutParams wvLayoutPortaritParams;
    private RelativeLayout.LayoutParams wvLayoutLandsapceParams;
    private RelativeLayout.LayoutParams wvLayoutToastParams;
    private RelativeLayout.LayoutParams bgLayoutParams;
    private RelativeLayout bgLayout;
    private boolean isToastWeb = false;
    private int delayTime = 8000;
    private SafeDispatchHandler handler = new SafeDispatchHandler();
    private boolean isLandspace = false;
    private Runnable removeRunnable = new Runnable(){

        @Override
        public void run() {
            OLBusinessWebViewController.this.hideWebView();
        }
    };

    public OLBusinessWebViewController(Context context, RelativeLayout rootView) {
        this.rootView = rootView;
        this.context = context;
        this.init();
    }

    private void init() {
        this.wvLayout = new RelativeLayout(this.context);
        this.wvLayout.setId(R.id.business_weblayout_tag);
        this.wvLayout.setVisibility(8);
        this.bgLayout = new RelativeLayout(this.context);
        this.bgLayout.setClickable(true);
        this.bgLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OLBusinessWebViewController.this.isLandspace) {
                    PluginBus.INSTANCE.get().post((Object)new IDanmuViewBasicClient_switchShowDanmuStatus_EventArgs(true));
                }
                OLBusinessWebViewController.this.hideWebView();
            }
        });
    }

    public void showWebView(boolean isToast, final String itemId, final String pid, boolean isLandspace) {
        this.isToastWeb = false;
        if (this.handler != null) {
            this.handler.removeCallbacks(this.removeRunnable);
        }
        if (this.rootView != null && this.rootView.getParent() != null && this.bgLayout.getParent() == null) {
            ((ViewGroup)this.rootView.getParent()).addView((View)this.bgLayout, (ViewGroup.LayoutParams)this.getBgLayoutParams());
        }
        if (this.rootView != null && this.rootView.getParent() != null && this.wvLayout.getParent() == null) {
            ((ViewGroup)this.rootView.getParent()).addView((View)this.wvLayout);
        }
        if (this.webView != null) {
            this.hideWebView();
        }
        if (!isToast) {
            if (isLandspace) {
                PluginBus.INSTANCE.get().post((Object)new IDanmuViewBasicClient_switchShowDanmuStatus_EventArgs(false));
                this.wvLayout.setLayoutParams((ViewGroup.LayoutParams)this.getWvLayoutLandsapceParams());
                this.wvLayout.requestLayout();
            } else {
                this.wvLayout.setLayoutParams((ViewGroup.LayoutParams)this.getWvLayoutPortaritParams());
                this.wvLayout.requestLayout();
            }
            this.bgLayout.setVisibility(0);
        } else {
            this.wvLayout.setLayoutParams((ViewGroup.LayoutParams)this.getWvLayoutToastParams());
            this.wvLayout.requestLayout();
        }
        this.wvLayout.setVisibility(0);
        if (this.webView == null) {
            this.webView = new PureWebviewUtil.Builder(this.context).setOpenStatus(true).create();
            this.webView.setUrl(this.cretateWebUrl("", "", isLandspace, isToast));
            this.wvLayout.addView(this.webView.getRootView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        } else if (isToast && !StringUtils.isEmptyString((String)itemId)) {
            this.openJsGoods(itemId, pid);
        }
        this.reloadWeb();
        if (isToast) {
            this.webView.setWebViewEventLister((IWebViewEventListener)new WebViewEventListener(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    OLBusinessWebViewController.this.openJsGoods(itemId, pid);
                }
            });
        }
    }

    private void openJsGoods(String itemId, String pid) {
        this.isToastWeb = true;
        this.handler.removeCallbacks(this.removeRunnable);
        this.handler.postDelayed(this.removeRunnable, (long)this.delayTime);
        this.webView.loadJavaScript("javascript:openGoods(\"" + itemId + "\",\"" + pid + "\")");
    }

    public void onOrientationChanges(boolean isLandscape) {
        this.isLandspace = isLandscape;
        this.reloadWeb();
    }

    public void onDestroy() {
        this.removeWebView();
    }

    private void removeWebView() {
        if (this.rootView != null && this.bgLayout != null && !this.rootParentIsNull()) {
            ((ViewGroup)this.rootView.getParent()).removeView((View)this.bgLayout);
        }
        if (this.rootView != null && this.wvLayout != null && !this.rootParentIsNull()) {
            ((ViewGroup)this.rootView.getParent()).removeView((View)this.wvLayout);
        }
        if (this.webView != null) {
            this.webView.release();
        }
        this.webView = null;
    }

    public void hideWebView() {
        this.bgLayout.setVisibility(8);
        this.wvLayout.setVisibility(8);
    }

    private RelativeLayout.LayoutParams getWvLayoutPortaritParams() {
        if (this.wvLayoutPortaritParams == null) {
            this.wvLayoutPortaritParams = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)324.0f, (Context)BasicConfig.getInstance().getAppContext()));
            this.wvLayoutPortaritParams.addRule(12);
        }
        return this.wvLayoutPortaritParams;
    }

    private RelativeLayout.LayoutParams getWvLayoutLandsapceParams() {
        if (this.wvLayoutLandsapceParams == null) {
            this.wvLayoutLandsapceParams = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)155.0f, (Context)BasicConfig.getInstance().getAppContext()));
            this.wvLayoutLandsapceParams.addRule(12);
        }
        return this.wvLayoutLandsapceParams;
    }

    private RelativeLayout.LayoutParams getWvLayoutToastParams() {
        if (this.wvLayoutToastParams == null) {
            this.wvLayoutToastParams = new RelativeLayout.LayoutParams(1, 1);
            this.wvLayoutToastParams.addRule(10);
        }
        return this.wvLayoutToastParams;
    }

    private RelativeLayout.LayoutParams getBgLayoutParams() {
        if (this.bgLayoutParams == null) {
            this.bgLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.bgLayoutParams.addRule(12);
        }
        return this.bgLayoutParams;
    }

    private String cretateWebUrl(String itemId, String pid, boolean isLandspace, boolean isToastWeb) {
        StringBuffer sb = isLandspace && !isToastWeb ? new StringBuffer(EntIdentity.OLBUSINESS_WEB_URL_LANDSPACE) : new StringBuffer(EntIdentity.OLBUSINESS_WEB_URL_PORTAIT);
        sb.append("?");
        sb.append("topchid=" + ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid);
        sb.append("&subchid=" + ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid);
        sb.append("&anchorUid=" + ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId());
        sb.append("&myUid=" + LoginUtil.getUid());
        String name = "";
        try {
            if (ICoreManagerBase.getUserCore().getCacheLoginUserInfo() != null) {
                name = URLEncoder.encode(ICoreManagerBase.getUserCore().getCacheLoginUserInfo().nickName, "UTF-8");
            } else {
                MLog.info((Object)TAG, (String)"wwd olbussiness ICoreManagerBase.getUserCore().getCacheLoginUserInfo() is null!", (Object[])new Object[0]);
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"OLBusinessWebViewCtrler", (String)"Empty Catch on cretateWebUrl", (Throwable)e);
        }
        sb.append("&nick=" + name);
        if (!itemId.equals("")) {
            sb.append("&itemId=" + itemId);
        }
        if (!pid.equals("")) {
            sb.append("&pid=" + pid);
        }
        MLog.info((Object)TAG, (String)("wwd url=" + sb.toString()), (Object[])new Object[0]);
        return sb.toString();
    }

    private boolean rootParentIsNull() {
        if (this.rootView == null) {
            return true;
        }
        return this.rootView.getParent() == null;
    }

    public boolean isWebShowing() {
        if (this.webView != null) {
            return this.webView.getRootView().getVisibility() == 0;
        }
        return false;
    }

    public void reloadWeb() {
        if (!this.isToastWeb && this.webView != null) {
            this.webView.setUrl(this.cretateWebUrl("", "", this.isLandscape(), false), false);
        }
    }

    public void refreshWebTag(int mallType, String itemId, int operate) {
        if (!this.isToastWeb && this.webView != null) {
            this.webView.loadJavaScript("javascript:showOrHideRecommend(" + operate + "," + itemId + "," + mallType + ")");
        }
    }

    private boolean isLandscape() {
        return this.context.getResources().getConfiguration().orientation == 2;
    }
}

