/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.nobleSeat.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Shader;
import android.text.TextPaint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.contribution.ui.AnimationCircleView;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.nobleSeat.core.NobleSeatProtocol;
import com.yy.mobile.ui.nobleSeat.ui.GradientManager;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Vector;

public class NobleSeatAdapter
extends BaseAdapter {
    private static final String TAG = "NobleSeatAdapter";
    private Context mContext;
    private Vector<NobleSeatProtocol.MobileNobleInfo> mInfoList = new Vector();
    private int animationPosition = -1;
    private OnNobleSeatItemClickListener mOnItemClickListener;
    PlayAnimationListener mPlayAnimationListener;

    public NobleSeatAdapter(Context context) {
        this.mContext = context;
    }

    public void removeCacheDrawables() {
        if (this.mInfoList != null && this.mInfoList.size() > 0) {
            Map extend = null;
            String headPic = null;
            String iconIndex = null;
            String iconHttpUrl = null;
            ImageConfig config = ImageConfig.smallImageConfig();
            for (NobleSeatProtocol.MobileNobleInfo item2 : this.mInfoList) {
                if (item2 == null || item2.extend == null || (iconHttpUrl = FaceHelperFactory.getFriendHeadUrl((String)(headPic = (String)(extend = item2.extend).get("icon")), (int)StringUtils.safeParseInt((String)(iconIndex = (String)extend.get("iconIndex"))))) == null) continue;
                ImageLoader.removeBitmapFromCache((String)iconHttpUrl, (ImageConfig)config);
            }
        }
    }

    public Vector<NobleSeatProtocol.MobileNobleInfo> getData() {
        return this.mInfoList;
    }

    public void setData(Vector<NobleSeatProtocol.MobileNobleInfo> infoList) {
        this.mInfoList.clear();
        if (infoList != null) {
            if (infoList.size() > 20) {
                this.mInfoList.addAll(infoList.subList(0, 20));
            } else {
                this.mInfoList.addAll(infoList);
            }
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnNobleSeatItemClickListener listener2) {
        this.mOnItemClickListener = listener2;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mInfoList.size();
    }

    public NobleSeatProtocol.MobileNobleInfo getItem(int position) {
        if (this.mInfoList.size() > 0) {
            if (position < this.mInfoList.size()) {
                return this.mInfoList.get(position);
            }
            return this.mInfoList.get(0);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int i, View view, ViewGroup viewGroup) {
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.nobleseat_layout_seat_item, viewGroup, false);
        }
        final NobleSeatProtocol.MobileNobleInfo itemInfo = this.getItem(i);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != NobleSeatAdapter.this.mOnItemClickListener) {
                    NobleSeatAdapter.this.mOnItemClickListener.onItemClick(i, v, itemInfo);
                }
            }
        });
        if (itemInfo == null) {
            MLog.info((Object)TAG, (String)("itemInfo is null index is " + i), (Object[])new Object[0]);
            return view;
        }
        CircleImageView headView = (CircleImageView)view.findViewById(R.id.headView);
        this.loadPortrait(itemInfo, (RecycleImageView)headView);
        RecycleImageView nobleIcon = (RecycleImageView)view.findViewById(R.id.nobleIcon);
        if (itemInfo.grade.intValue() > 0) {
            nobleIcon.setVisibility(0);
            ImageLoader.loadImageResource((int)EntIdentityIconSet.getIconResId((int)itemInfo.grade.intValue()), (RecycleImageView)nobleIcon, (ImageConfig)ImageConfig.defaultImageConfig());
        } else {
            nobleIcon.setVisibility(8);
        }
        ImageView ivHuangguan = (ImageView)view.findViewById(R.id.icon_ctb_rank);
        TextView tvContributeValue = (TextView)view.findViewById(R.id.tv_ctb_value);
        TextView tvContributeInRank = (TextView)view.findViewById(R.id.tv_ctb_in_rank);
        this.loadContribution(i, itemInfo, tvContributeValue, ivHuangguan);
        if (this.isGameTemplate()) {
            ivHuangguan.setVisibility(8);
        }
        AnimationCircleView animationCircleView = (AnimationCircleView)view.findViewById(R.id.acv_in_rank);
        if (!this.isGameTemplate() && this.animationPosition == i && !animationCircleView.isAnimationPlaying() && LoginUtil.getUid() == itemInfo.uid.longValue()) {
            this.animationPosition = -1;
            animationCircleView.playAnimation();
            this.playScaleAnimation((View)headView);
            this.playScaleAnimation((View)animationCircleView);
            this.playAlphaAnimation((View)tvContributeInRank);
            this.playBlingAnimation(tvContributeInRank);
        }
        return view;
    }

    private void loadPortrait(NobleSeatProtocol.MobileNobleInfo itemInfo, RecycleImageView portraitIv) {
        MLog.info((Object)TAG, (String)("loadPortrait: itemInfo = " + itemInfo), (Object[])new Object[0]);
        Map extend = itemInfo.extend;
        String headPic = (String)extend.get("icon");
        String iconIndex = (String)extend.get("iconIndex");
        MLog.info((Object)TAG, (String)("loadPortrait: icon = " + headPic + ", iconIndex = " + iconIndex), (Object[])new Object[0]);
        AbsChannelControllerCore absChannelControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
        if (absChannelControllerCore == null || !absChannelControllerCore.isInterceptShowVivoPortrait(headPic, (ImageView)portraitIv)) {
            if (!StringUtils.isEmpty((String)headPic).booleanValue() && headPic.contains("header/10001.jpg")) {
                ImageLoader.loadImage((String)"", (RecycleImageView)portraitIv, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait);
            } else {
                FaceHelperFactory.loadFace((String)headPic, (int)StringUtils.safeParseInt((String)iconIndex), (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)portraitIv, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.default_portrait);
            }
        }
    }

    private void loadContribution(int rank, NobleSeatProtocol.MobileNobleInfo itemInfo, TextView tvCtb, ImageView ivHuangguan) {
        if (itemInfo == null || tvCtb == null || ivHuangguan == null) {
            return;
        }
        Map extend = itemInfo.extend;
        if (extend.get("ctbValue") != null) {
            tvCtb.setVisibility(0);
            tvCtb.setTextColor(Color.parseColor((String)"#ffffff"));
            tvCtb.setText((CharSequence)this.convertToShortString((String)extend.get("ctbValue")));
            if (rank == 0) {
                ivHuangguan.setVisibility(0);
                ivHuangguan.setBackgroundResource(R.drawable.liveroom_ctb_1);
                tvCtb.setBackgroundResource(R.drawable.bg_ctb_result_drawable1);
                int mWidth = tvCtb.getWidth();
                int mHeight = tvCtb.getHeight();
                Point size = new Point(mWidth, mHeight);
                GradientManager mGradientManager = new GradientManager(this.mContext, size);
                tvCtb.getPaint().setShader((Shader)mGradientManager.getFirstLinearGradient());
            } else if (rank == 1) {
                ivHuangguan.setVisibility(0);
                ivHuangguan.setBackgroundResource(R.drawable.liveroom_ctb_2);
                tvCtb.setBackgroundResource(R.drawable.bg_ctb_result_drawable2);
                int mWidth = tvCtb.getWidth();
                int mHeight = tvCtb.getHeight();
                Point size = new Point(mWidth, mHeight);
                GradientManager mGradientManager = new GradientManager(this.mContext, size);
                tvCtb.getPaint().setShader((Shader)mGradientManager.getSecondLinearGradient());
            } else if (rank == 2) {
                ivHuangguan.setVisibility(0);
                ivHuangguan.setBackgroundResource(R.drawable.liveroom_ctb_3);
                tvCtb.setBackgroundResource(R.drawable.bg_ctb_result_drawable3);
                int mWidth = tvCtb.getWidth();
                int mHeight = tvCtb.getHeight();
                Point size = new Point(mWidth, mHeight);
                GradientManager mGradientManager = new GradientManager(this.mContext, size);
                tvCtb.getPaint().setShader((Shader)mGradientManager.getThirdLinearGradient());
            } else {
                ivHuangguan.setVisibility(8);
                tvCtb.setBackgroundResource(R.drawable.bg_ctb_value);
                int mWidth = tvCtb.getWidth();
                int mHeight = tvCtb.getHeight();
                Point size = new Point(mWidth, mHeight);
                GradientManager mGradientManager = new GradientManager(this.mContext, size);
                tvCtb.getPaint().setShader((Shader)mGradientManager.getNormalLinearGradient());
            }
        } else {
            tvCtb.setVisibility(8);
            ivHuangguan.setVisibility(8);
        }
    }

    public void playAnimation(int position) {
        this.animationPosition = position;
    }

    private void playScaleAnimation(View view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 1.0f, 1.1f, 1.1f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 1.0f, 1.1f, 1.1f, 1.0f});
        animatorSet.setDuration(2000L);
        animatorSet.play((Animator)scaleX).with((Animator)scaleY);
        animatorSet.start();
    }

    private void playAlphaAnimation(final View view) {
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f});
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                view.setVisibility(0);
                if (NobleSeatAdapter.this.mPlayAnimationListener != null) {
                    NobleSeatAdapter.this.mPlayAnimationListener.onAnimStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                view.setVisibility(8);
                if (NobleSeatAdapter.this.mPlayAnimationListener != null) {
                    NobleSeatAdapter.this.mPlayAnimationListener.onAnimStart();
                }
            }

            public void onAnimationCancel(Animator animation) {
                if (NobleSeatAdapter.this.mPlayAnimationListener != null) {
                    NobleSeatAdapter.this.mPlayAnimationListener.onAnimStart();
                }
            }
        });
        anim2.setDuration(3500L);
        anim2.start();
    }

    private void playBlingAnimation(TextView tv) {
        float width = tv.getWidth();
        if (width == 0.0f) {
            width = ResolutionUtils.convertDpToPixel((float)28.0f, (Context)this.mContext);
        }
        TextPaint paint = tv.getPaint();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, width});
        final float finalWidth = width;
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((Paint)paint, tv){
            final /* synthetic */ Paint val$paint;
            final /* synthetic */ TextView val$tv;
            {
                this.val$paint = paint;
                this.val$tv = textView;
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                float position = ((Float)animation.getAnimatedValue()).floatValue();
                LinearGradient lg = new LinearGradient(0.0f + position, 0.0f, finalWidth + position, 0.0f, Color.parseColor((String)"#ffffff"), Color.parseColor((String)"#000000"), Shader.TileMode.MIRROR);
                this.val$paint.setShader((Shader)lg);
                this.val$tv.postInvalidate();
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((Paint)paint, tv){
            final /* synthetic */ Paint val$paint;
            final /* synthetic */ TextView val$tv;
            {
                this.val$paint = paint;
                this.val$tv = textView;
            }

            public void onAnimationEnd(Animator animation) {
                LinearGradient lg = new LinearGradient(0.0f, 0.0f, finalWidth, 0.0f, Color.parseColor((String)"#000000"), Color.parseColor((String)"#000000"), Shader.TileMode.CLAMP);
                this.val$paint.setShader((Shader)lg);
                this.val$tv.postInvalidate();
            }
        });
        animator.setDuration(1000L);
        animator.start();
    }

    public void setPlayAnimationListener(PlayAnimationListener playAnimationListener) {
        this.mPlayAnimationListener = playAnimationListener;
    }

    private String convertToShortString(String value) {
        double v = Double.valueOf(value);
        if (v >= 1.0E8) {
            DecimalFormat format = new DecimalFormat("0.0");
            format.setRoundingMode(RoundingMode.DOWN);
            return format.format(v / 1.0E8) + "\u4ebf";
        }
        if (v >= 10000.0) {
            return (int)(v / 10000.0) + "\u4e07";
        }
        return value;
    }

    private boolean isGameTemplate() {
        if (ICoreManagerBase.getCore(IChannelLinkCore.class) != null) {
            return ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate();
        }
        return false;
    }

    public static interface PlayAnimationListener {
        public void onAnimStart();

        public void onAnimFinished();
    }

    public static interface OnNobleSeatItemClickListener {
        public void onItemClick(int var1, View var2, NobleSeatProtocol.MobileNobleInfo var3);
    }
}

