/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.clipviewpager;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class ClipViewPager
extends ViewPager {
    private boolean mChangeCurrent = false;

    public ClipViewPager(Context context) {
        super(context);
    }

    public ClipViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        View view;
        this.mChangeCurrent = false;
        if (ev.getAction() == 1 && (view = this.viewOfClickOnScreen(ev)) != null) {
            int index = this.indexOfChild(view);
            if (this.getCurrentItem() != index) {
                this.mChangeCurrent = true;
                this.setCurrentItem(this.indexOfChild(view));
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private View viewOfClickOnScreen(MotionEvent ev) {
        int childCount = this.getChildCount();
        int[] location = new int[2];
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            v.getLocationOnScreen(location);
            int minX = location[0];
            int minY = this.getTop();
            int maxX = location[0] + v.getWidth();
            int maxY = this.getBottom();
            float x = ev.getX();
            float y = ev.getY();
            if (!(x > (float)minX) || !(x < (float)maxX) || !(y > (float)minY) || !(y < (float)maxY)) continue;
            return v;
        }
        return null;
    }

    public Boolean isChangeCurrentItem() {
        return this.mChangeCurrent;
    }
}

