/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.video;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MicNoVideoId;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.NonMixVideoLayoutController;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.IVideoViewController;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.releasemanager.ObjectReleaseBeforeInitManager;
import com.yymobile.core.flowmanagement.compatiblecore.audience.VideoMixtureManager;
import java.util.List;

public class AnchorModeVideoViewController
implements IVideoViewController,
ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject {
    private static final String TAG = "AnchorModeVideoViewController";
    private Context mContext;
    private ViewGroup mVideoParent;
    private AudienceVideoView mFirstMicVideoView;
    private AudienceVideoView mSecondMicVideoView;
    private NonMixVideoLayoutController mNonMixVideoLayoutController;

    public AnchorModeVideoViewController(ViewGroup videoParent, int orientation, List<AbsVideoLayoutParser> layoutParsers) {
        this(videoParent, new AudienceVideoView(videoParent.getContext()), new AudienceVideoView(videoParent.getContext()), orientation, layoutParsers);
    }

    public AnchorModeVideoViewController(ViewGroup mVideoParent, AudienceVideoView mFirstMicVideoView, AudienceVideoView mSecondMicVideoView, int orientation, List<AbsVideoLayoutParser> layoutParsers) {
        MLog.info((Object)TAG, (String)"AnchorModeVideoViewController constructor", (Object[])new Object[0]);
        this.mVideoParent = mVideoParent;
        this.mFirstMicVideoView = mFirstMicVideoView;
        this.mSecondMicVideoView = mSecondMicVideoView;
        this.mContext = mVideoParent.getContext();
        this.mFirstMicVideoView.setZOrderMediaOverlay(false);
        this.mSecondMicVideoView.setZOrderMediaOverlay(false);
        this.initVideoView();
        this.mNonMixVideoLayoutController = new NonMixVideoLayoutController(orientation, mFirstMicVideoView, mSecondMicVideoView, layoutParsers);
    }

    @Override
    public void initVideoView() {
        MLog.info((Object)TAG, (String)"init anchor mode video view", (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.getInstance().callInit((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
        VideoMixtureManager.getInstance().setVideoNeedMixture(false);
        this.mVideoParent.addView((View)this.mFirstMicVideoView);
        this.mVideoParent.addView((View)this.mSecondMicVideoView);
        this.innerStartVideo();
    }

    private void innerStartVideo() {
        MLog.info((Object)TAG, (String)"innerStartVideo called", (Object[])new Object[0]);
        if (this.mFirstMicVideoView != null) {
            this.mFirstMicVideoView.start((AbsVideoId)new MicNoVideoId(0));
        }
        if (this.mSecondMicVideoView != null) {
            this.mSecondMicVideoView.start((AbsVideoId)new MicNoVideoId(1));
        }
    }

    @Override
    public void removeVideoView() {
        MLog.info((Object)TAG, (String)"removeVideoView called", (Object[])new Object[0]);
        this.removeVideoView(this.mFirstMicVideoView);
        this.removeVideoView(this.mSecondMicVideoView);
    }

    @Override
    public void startVideo() {
        MLog.info((Object)TAG, (String)"startVideo called", (Object[])new Object[0]);
        this.innerStartVideo();
    }

    @Override
    public void switchOrientation(int orientation) {
        MLog.info((Object)TAG, (String)("switchOrientation called with: orientation = [" + orientation + "]"), (Object[])new Object[0]);
        this.mNonMixVideoLayoutController.switchOrientation(orientation);
    }

    @Override
    public void setVideoEnable(boolean enable) {
        MLog.info((Object)TAG, (String)("setVideoEnable called with: enable = [" + enable + "]"), (Object[])new Object[0]);
        if (this.mFirstMicVideoView != null) {
            this.mFirstMicVideoView.setVideoEnable(enable);
        }
        if (this.mSecondMicVideoView != null) {
            this.mSecondMicVideoView.setVideoEnable(enable);
        }
    }

    @Override
    public void onStop() {
        MLog.info((Object)TAG, (String)"onStop called", (Object[])new Object[0]);
        this.mFirstMicVideoView.setVideoEnable(false);
        this.mSecondMicVideoView.setVideoEnable(false);
    }

    @Override
    public void onResume() {
        MLog.info((Object)TAG, (String)"onResume called", (Object[])new Object[0]);
        if (AudienceVideoEnableManager.getInstance().isVideoEnable()) {
            this.mFirstMicVideoView.setVideoEnable(true);
            this.mSecondMicVideoView.setVideoEnable(true);
        } else {
            MLog.info((Object)TAG, (String)"onResume, current is not video mode, do not enable video", (Object[])new Object[0]);
        }
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"release anchor mode video controller", (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.getInstance().callRelease((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
    }

    private void innerRelease() {
        MLog.info((Object)TAG, (String)"innerRelease called", (Object[])new Object[0]);
        this.mFirstMicVideoView.release();
        this.mSecondMicVideoView.release();
        this.mNonMixVideoLayoutController.release();
    }

    private void removeVideoView(AudienceVideoView videoView) {
        if (videoView != null) {
            this.mVideoParent.removeView((View)videoView);
            videoView.release();
        }
    }

    public void onInit() {
    }

    public void onRelease() {
        MLog.info((Object)TAG, (String)"onRelease called", (Object[])new Object[0]);
        this.innerRelease();
    }

    public String getType() {
        return "AUDIENCE_VIDEO";
    }
}

