/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.video.MediaVideoViewSiteChangeEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.api.layout.videosize.AudienceVideoSizeChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videolayout.videosize.VideoSizeChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamListSizeChangeEvent;
import com.yy.mobile.ui.meidabasicvideoview.IMediaAuxiliaryVideoViewFrameCore;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.NonMixVideoLayoutController$$EventBinder;
import com.yy.mobile.ui.meidabasicvideoview.uicore.IMediaVideoBasicCore;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.List;

public class NonMixVideoLayoutController
implements VideoSizeChangeListener,
EventCompat {
    private static final String TAG = "NonMixVideoLayoutController";
    private VideoSizeInfo mFirstMicVideoSizeInfo;
    private VideoSizeInfo mSecondMicVideoSizeInfo;
    private AudienceVideoView mFirstVideoView;
    private AudienceVideoView mSecondVideoView;
    private int mCurrentOrientation;
    private Context mContext;
    private int mVideoStreamCount;
    private List<AbsVideoLayoutParser> mLayoutParsers;
    private EventBinder mNonMixVideoLayoutControllerSniperEventBinder;

    public NonMixVideoLayoutController(int currentOrientation, AudienceVideoView firstVideoView, AudienceVideoView secondVideoView, List<AbsVideoLayoutParser> layoutParsers) {
        MLog.info((Object)TAG, (String)("NonMixVideoLayoutController constructor called with: currentOrientation = [" + currentOrientation + "]"), (Object[])new Object[0]);
        this.mCurrentOrientation = currentOrientation;
        this.mVideoStreamCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        this.mFirstVideoView = firstVideoView;
        this.mSecondVideoView = secondVideoView;
        this.mContext = this.mFirstVideoView.getContext();
        this.mLayoutParsers = layoutParsers;
        AudienceVideoSizeChangeEventHandler.getInstance().addListener((VideoSizeChangeListener)this);
        this.onEventBind();
    }

    public void switchOrientation(int orientation) {
        MLog.info((Object)TAG, (String)("switchOrientation called with: orientation = [" + orientation + "]"), (Object[])new Object[0]);
        this.requireValidOrientation(orientation);
        this.mCurrentOrientation = orientation;
        this.updateVideoSizeInfo(this.mFirstMicVideoSizeInfo, this.mCurrentOrientation);
        this.updateVideoSizeInfo(this.mSecondMicVideoSizeInfo, this.mCurrentOrientation);
        this.refreshLayout();
    }

    public void onVideoSizeChanged(VideoSizeInfo info) {
        MLog.info((Object)TAG, (String)("onVideoSizeChanged called with: info = [" + info + "]"), (Object[])new Object[0]);
        this.updateVideoSizeInfo(info, this.mCurrentOrientation);
        this.refreshLayout();
    }

    @BusEvent
    public void onVideoStreamCountChange(VideoStreamListSizeChangeEvent event) {
        int preCount = this.mVideoStreamCount;
        this.mVideoStreamCount = event.videoStreamListSize;
        boolean isStreamRemove = this.mVideoStreamCount < preCount;
        MLog.info((Object)TAG, (String)("onVideoStreamCountChange called with: event = [" + event + "], isStreamRemove: %b"), (Object[])new Object[]{isStreamRemove});
        if (isStreamRemove) {
            this.refreshLayout();
        }
    }

    public void release() {
        AudienceVideoSizeChangeEventHandler.getInstance().removeListener((VideoSizeChangeListener)this);
        this.onEventUnBind();
    }

    @NonNull
    private LayoutInfo findParser(VideoSizeInfo info) {
        LayoutInfo layoutInfo = new LayoutInfo();
        if (info == null) {
            return layoutInfo;
        }
        AbsVideoLayoutParser interceptedParser = null;
        for (AbsVideoLayoutParser layoutParser : this.mLayoutParsers) {
            if (!layoutParser.intercept(info)) continue;
            interceptedParser = layoutParser;
            break;
        }
        if (interceptedParser != null) {
            MLog.info((Object)TAG, (String)("findParser success, parser: ======%s======, info = [" + info + "]"), (Object[])new Object[]{interceptedParser.getLogTag()});
            VideoRect rect = interceptedParser.calculateVideoViewRect(this.mContext, info);
            List<MediaVideoViewSite> sites = interceptedParser.calculateMediaVideoViewSiteCompat(this.mContext, info);
            layoutInfo.videoRect = rect;
            layoutInfo.viewSite = sites.size() > 0 ? sites.get(0) : null;
        } else {
            MLog.error((Object)TAG, (String)"=Bug=findParser, parser not found, video layout might not display right!!!!, sizeInfo: %s", (Object[])new Object[]{info});
        }
        return layoutInfo;
    }

    private void requireValidOrientation(int orientation) {
        if (orientation != 1 && orientation != 2) {
            ExceptionUtil.throwOrWriteLog((String)TAG, (String)("invalid orientation: " + orientation), (Object[])new Object[0]);
        }
    }

    private void updateVideoSizeInfo(VideoSizeInfo videoSizeInfo, int orientation) {
        if (videoSizeInfo == null) {
            return;
        }
        if (videoSizeInfo.micNo == 0) {
            this.mFirstMicVideoSizeInfo = videoSizeInfo;
        } else if (videoSizeInfo.micNo == 1) {
            this.mSecondMicVideoSizeInfo = videoSizeInfo;
        } else {
            MLog.error((Object)TAG, (String)"updateVideoSizeInfo, illegal mic no, videoSizeInfo: %s", (Object[])new Object[]{videoSizeInfo});
        }
        MLog.info((Object)TAG, (String)"updateVideoSizeInfo called before: %s, orientation: %d", (Object[])new Object[]{videoSizeInfo, orientation});
        this.mCurrentOrientation = orientation;
        videoSizeInfo.videoCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        videoSizeInfo.isVerticalOrientation = orientation == 1;
        videoSizeInfo.parentHeight = ResolutionUtils.getScreenHeight((Context)this.mContext);
        videoSizeInfo.parentWidth = ResolutionUtils.getScreenWidth((Context)this.mContext);
        MLog.info((Object)TAG, (String)"updateVideoSizeInfo called after: %s", (Object[])new Object[]{videoSizeInfo});
    }

    private void syncVideoCount() {
        int streamCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        if (this.mFirstMicVideoSizeInfo != null) {
            this.mFirstMicVideoSizeInfo.videoCount = streamCount;
        }
        if (this.mSecondMicVideoSizeInfo != null) {
            this.mSecondMicVideoSizeInfo.videoCount = streamCount;
        }
    }

    private void refreshLayout() {
        MLog.info((Object)TAG, (String)"refreshLayout called, first mic video size: %s, second mic video size: %s", (Object[])new Object[]{this.mFirstMicVideoSizeInfo, this.mSecondMicVideoSizeInfo});
        this.refreshVideoSizeInfo();
        this.syncVideoCount();
        LayoutInfo firstMicLayout = this.findParser(this.mFirstMicVideoSizeInfo);
        LayoutInfo secondMicLayout = this.findParser(this.mSecondMicVideoSizeInfo);
        this.innerUpdateVideoLayoutParams(firstMicLayout.videoRect, this.mFirstVideoView);
        this.innerUpdateVideoLayoutParams(secondMicLayout.videoRect, this.mSecondVideoView);
        this.updateVideoViewSite(firstMicLayout, secondMicLayout);
    }

    private void refreshVideoSizeInfo() {
        long firstMicUid = VideoStreamCompat.getInstance().getFirstVideoStreamUid();
        long secondMicUid = VideoStreamCompat.getInstance().getSecondVideoStreamUid();
        MLog.info((Object)TAG, (String)"refreshVideoSizeInfo called, firstMicUid: %d, secondMicUid: %d", (Object[])new Object[]{firstMicUid, secondMicUid});
        if (firstMicUid <= 0L) {
            this.mFirstMicVideoSizeInfo = null;
        }
        if (secondMicUid <= 0L) {
            this.mSecondMicVideoSizeInfo = null;
        }
    }

    private void updateVideoViewSite(LayoutInfo firstLayout, LayoutInfo secondLayout) {
        MLog.info((Object)TAG, (String)("updateVideoViewSite called with: firstLayout = [" + firstLayout + "], secondLayout = [" + secondLayout + "]"), (Object[])new Object[0]);
        MediaVideoViewSiteChangeEvent siteChangeEvent = new MediaVideoViewSiteChangeEvent();
        MediaVideoViewSite firstSite = firstLayout.viewSite;
        MediaVideoViewSite secondSite = secondLayout.viewSite;
        if (firstSite != null) {
            siteChangeEvent.firstMicVideoViewSite = firstSite;
            ((IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class)).setFirstVideoViewFrame(firstSite);
        }
        if (secondSite != null) {
            siteChangeEvent.secondMicVideoViewSite = secondSite;
            ((IMediaAuxiliaryVideoViewFrameCore)ICoreManagerBase.getCore(IMediaAuxiliaryVideoViewFrameCore.class)).setAuxiliaryVideoViewFrame(secondSite);
        }
        RxBus.getDefault().post((Object)siteChangeEvent);
    }

    private void innerUpdateVideoLayoutParams(VideoRect videoRect, AudienceVideoView videoView) {
        if (videoRect == null) {
            return;
        }
        ViewGroup.LayoutParams params = videoView.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
        marginLayoutParams.leftMargin = videoRect.left;
        marginLayoutParams.topMargin = videoRect.top;
        marginLayoutParams.width = videoRect.width;
        marginLayoutParams.height = videoRect.height;
        videoView.setVisibility(0);
        videoView.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        videoView.setScaleMode(videoRect.videoScaleMode);
        MLog.info((Object)TAG, (String)("innerUpdateLayoutParams called with: videoViewLayoutParams = [" + videoRect + "]"), (Object[])new Object[0]);
    }

    public void onEventBind() {
        if (this.mNonMixVideoLayoutControllerSniperEventBinder == null) {
            this.mNonMixVideoLayoutControllerSniperEventBinder = new NonMixVideoLayoutController$$EventBinder();
        }
        this.mNonMixVideoLayoutControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mNonMixVideoLayoutControllerSniperEventBinder != null) {
            this.mNonMixVideoLayoutControllerSniperEventBinder.unBindEvent();
        }
    }

    private static class LayoutInfo {
        VideoRect videoRect;
        MediaVideoViewSite viewSite;

        private LayoutInfo() {
        }

        public String toString() {
            return "LayoutInfo{videoRect=" + this.videoRect + ", viewSite=" + this.viewSite + '}';
        }
    }
}

