/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.component;

import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.duowan.mobile.entlive.events.IChannelLinkClient_onPowerUserOpenMic_EventArgs;
import com.duowan.mobile.entlive.events.SlideChannelEvent;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.android.arouter.facade.annotation.Autowired;
import com.yy.mobile.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.meidabasicvideoview.compat.biz.miccard.MicCardController;
import com.yy.mobile.ui.meidabasicvideoview.compat.component.AudienceVideoViewFragment$$EventBinder;
import com.yy.mobile.ui.meidabasicvideoview.compat.loading.AudienceVideoLoadingController;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.MixLayoutParsersFactory;
import com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.OriginLayoutParsersFactory;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.AnchorModeVideoViewController;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.AudienceVideoViewController;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.IVideoViewController;
import com.yy.mobile.ui.programinfo.ISecondVideoInfoFactory;
import com.yy.mobile.ui.programinfo.ISecondVideoUserInfoController;
import com.yy.mobile.ui.programinfo.SecondVideoUserInfoController;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.releasemanager.ObjectReleaseBeforeInitManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.flowmanagement.compatiblecore.audience.TimeCostStatistics;

public class AudienceVideoViewFragment
extends Component {
    private static final String TAG = "AudienceVideoViewFragment";
    protected View mRootView;
    protected ViewGroup mVideoParent;
    protected IVideoViewController mVideoViewController;
    private AudienceVideoLoadingController mLoadingController;
    @Autowired(name="channel_screenshot_url")
    public String loadingSnapshot;
    @Autowired(name="channel_second_video_controller")
    String secondVideoControllerSchema = "/SecondVideo/UserInfo/Default";
    private MicCardController mMicCardController;
    private ISecondVideoUserInfoController mSecondVideoUserInfoController;
    private EventBinder mAudienceVideoViewFragmentSniperEventBinder;

    public static AudienceVideoViewFragment newInstance() {
        return new AudienceVideoViewFragment();
    }

    public AudienceVideoViewFragment() {
        MLog.info((Object)TAG, (String)"AudienceVideoViewFragment constructor called, this: %s", (Object[])new Object[]{this});
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mVideoViewController.switchOrientation(newConfig.orientation);
        this.mMicCardController.onOrientationChange(newConfig.orientation == 1);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        MLog.info((Object)TAG, (String)"onCreateView called, this: %s", (Object[])new Object[]{this});
        super.onCreateView(inflater, container, savedInstanceState);
        this.mRootView = inflater.inflate(R.layout.fragment_audience_videoview, container, false);
        this.mVideoParent = (ViewGroup)this.mRootView.findViewById(R.id.fl_audience_video_container);
        this.mVideoViewController = this.createVideoViewController(this.mVideoParent);
        this.mLoadingController = this.createVideoLoadingController();
        this.mMicCardController = new MicCardController(this.mRootView);
        this.initSecondVideoController();
        this.checkAudioMode();
        return this.mRootView;
    }

    private void initSecondVideoController() {
        Object obj = ARouter.getInstance().build(this.secondVideoControllerSchema).navigation();
        this.mSecondVideoUserInfoController = obj instanceof ISecondVideoInfoFactory ? ((ISecondVideoInfoFactory)obj).createSecondVideoController(this.getChildFragmentManager()) : new SecondVideoUserInfoController(this.getChildFragmentManager());
    }

    private void checkAudioMode() {
        boolean isVideoEnable = AudienceVideoEnableManager.getInstance().isVideoEnable();
        if (!isVideoEnable) {
            MLog.info((Object)TAG, (String)"notifyAudioMode on component created", (Object[])new Object[0]);
            RxBus.getDefault().post((Object)new IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs(false));
        }
    }

    protected IVideoViewController createVideoViewController(ViewGroup videoParent) {
        boolean hasOpenMic = ICoreManagerBase.getChannelLinkCore().isOpenMic();
        MLog.info((Object)TAG, (String)("createVideoViewController called with: hasOpenMic = [" + hasOpenMic + "]"), (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject mVideoViewController = hasOpenMic ? new AnchorModeVideoViewController(videoParent, this.getOrientation(), OriginLayoutParsersFactory.getOldTemplateLayoutParsers()) : new AudienceVideoViewController(videoParent, MixLayoutParsersFactory.getOldTemplateParsers());
        return mVideoViewController;
    }

    protected AudienceVideoLoadingController createVideoLoadingController() {
        return new AudienceVideoLoadingController(this.mRootView, this.loadingSnapshot);
    }

    @BusEvent(sync=true)
    public void onSwitchToAnchorMode(IChannelLinkClient_onPowerUserOpenMic_EventArgs eventArgs) {
        MLog.info((Object)TAG, (String)"onSwitchToAnchorMode called", (Object[])new Object[0]);
        if (this.mVideoViewController instanceof AnchorModeVideoViewController) {
            MLog.info((Object)TAG, (String)"onSwitchToAnchorMode called, current video controller is in anchor mode, do nothing", (Object[])new Object[0]);
        } else {
            MLog.info((Object)TAG, (String)"onSwitchToAnchorMode called, switch to anchor mode", (Object[])new Object[0]);
            this.mVideoViewController.removeVideoView();
            int orientation = this.getOrientation();
            this.mVideoViewController = new AnchorModeVideoViewController(this.mVideoParent, orientation, OriginLayoutParsersFactory.getOldTemplateLayoutParsers());
        }
    }

    @BusEvent
    public void onSlideChannel(SlideChannelEvent event) {
        if (this.needToRecreateVideoViewController()) {
            MLog.info((Object)TAG, (String)"onChannelSlide\uff0c recreate video view controller", (Object[])new Object[0]);
            if (this.mVideoViewController != null) {
                this.mVideoViewController.removeVideoView();
            }
            this.mVideoViewController = this.createVideoViewController(this.mVideoParent);
        }
        this.mLoadingController.updateSnapshot(event.getThumb());
    }

    private boolean needToRecreateVideoViewController() {
        boolean hasOpenMic = ICoreManagerBase.getChannelLinkCore().isOpenMic();
        boolean needToRecreate = hasOpenMic && !(this.mVideoViewController instanceof AnchorModeVideoViewController) || !hasOpenMic && !(this.mVideoViewController instanceof AudienceVideoViewController);
        MLog.info((Object)TAG, (String)"needToRecreateVideoViewController called, needToReCreate: %b, hasOpenMic: %b, mVideoViewController: %s", (Object[])new Object[]{needToRecreate, hasOpenMic, this.mVideoViewController});
        return needToRecreate;
    }

    protected int getOrientation() {
        return this.getResources().getConfiguration().orientation;
    }

    @BusEvent
    public void onVideoAudioModeSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs eventArgs) {
        MLog.info((Object)TAG, (String)("onVideoAudioModeSwitch called with: eventArgs = [" + eventArgs + "]"), (Object[])new Object[0]);
        if (this.mVideoViewController != null) {
            this.mVideoViewController.setVideoEnable(eventArgs.isVideoEnable);
        }
    }

    public void onStop() {
        MLog.info((Object)TAG, (String)"onStop called, this: %s", (Object[])new Object[]{this});
        super.onStop();
        this.mVideoViewController.onStop();
    }

    public void onResume() {
        MLog.info((Object)TAG, (String)"onResume called, this: %s", (Object[])new Object[]{this});
        super.onResume();
        TimeCostStatistics.Companion.startTask("loadVideoComponentTimeCost");
        this.mVideoViewController.onResume();
    }

    public void onDestroyView() {
        MLog.info((Object)TAG, (String)"onDestroyView called, this: %s", (Object[])new Object[]{this});
        super.onDestroyView();
        this.mVideoViewController.release();
        this.mLoadingController.release();
        this.mSecondVideoUserInfoController.release();
        this.mMicCardController.release();
        Object var2_1 = null;
        if (this.mAudienceVideoViewFragmentSniperEventBinder != null) {
            this.mAudienceVideoViewFragmentSniperEventBinder.unBindEvent();
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void hideMicCard() {
        if (this.mMicCardController != null) {
            this.mMicCardController.hideRootView();
        }
    }

    public void setLoadingDrawable(Drawable d2) {
        this.mLoadingController.updateLoadingDrawable(d2);
    }

    public void setLoadingController(AudienceVideoLoadingController loadingController) {
        loadingController.updateSnapshot(this.loadingSnapshot);
        loadingController.updateLoadingDrawable(this.mLoadingController.getLoadingDrawable());
        this.mLoadingController.release();
        this.mLoadingController = loadingController;
    }

    public View getRootView() {
        return this.mRootView;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mAudienceVideoViewFragmentSniperEventBinder == null) {
            this.mAudienceVideoViewFragmentSniperEventBinder = new AudienceVideoViewFragment$$EventBinder();
        }
        this.mAudienceVideoViewFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }
}

