/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.biz.miccard;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IMediaVideoBasicClient_showContentRecommendComponent_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IConnectivityClient_onConnectivityChange_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onLeaveClear_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IMediaVideoBasicClient_onSetMicCardUrl_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.playstatus.VideoPlayStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.HasVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.ui.meidabasicvideoview.compat.biz.miccard.MicCardController$$EventBinder;
import com.yy.mobile.ui.meidabasicvideoview.uicore.IMediaVideoBasicCore;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.media.ILiveConfigCore;
import com.yymobile.core.media.LiveConfigType;
import com.yymobile.core.utils.IConnectivityCore;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class MicCardController
implements VideoPlayStatusListener,
EventCompat {
    private static final String TAG = "MicCardController";
    protected IMediaVideoBasicCore mediaVideoBasicCore;
    private View mMicCardRootView;
    private View mTvNetwork;
    private RecycleImageView mIvMicCard;
    private boolean mIsOrientationVertical = true;
    private boolean mIsMicCardShowing;
    private Context mContext;
    private Disposable mNoLiveShowMicDisposable;
    private EventBinder mMicCardControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mMicCardControllerSniperEventBinder == null) {
            this.mMicCardControllerSniperEventBinder = new MicCardController$$EventBinder();
        }
        this.mMicCardControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mMicCardControllerSniperEventBinder != null) {
            this.mMicCardControllerSniperEventBinder.unBindEvent();
        }
    }

    public MicCardController(View parent) {
        MLog.info((Object)TAG, (String)"MicCardController: init", (Object[])new Object[0]);
        this.mContext = parent.getContext();
        this.mediaVideoBasicCore = (IMediaVideoBasicCore)ICoreManagerBase.getCore(IMediaVideoBasicCore.class);
        this.initViews(parent);
        this.onEventBind();
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            this.mTvNetwork.setVisibility(0);
        }
        VideoPlayStatusEventHandler.getInstance().addVideoPlayStatusListener((VideoPlayStatusListener)this);
    }

    public void release() {
        MLog.info((Object)TAG, (String)"release called", (Object[])new Object[0]);
        this.mContext = null;
        this.onEventUnBind();
        VideoPlayStatusEventHandler.getInstance().removeVideoPlayStatusListener((VideoPlayStatusListener)this);
        RxUtils.dispose((Disposable)this.mNoLiveShowMicDisposable);
    }

    private void initViews(View parent) {
        this.mMicCardRootView = parent.findViewById(R.id.layout_audience_video_mic_card_root);
        this.mIvMicCard = (RecycleImageView)this.mMicCardRootView.findViewById(R.id.iv_mic_card);
        this.mTvNetwork = this.mMicCardRootView.findViewById(R.id.iv_mic_network);
        this.showMicCardIfNoVideo();
    }

    @BusEvent
    public void onVideoAudioModeSwitch(IMediaVideoBasicClient_onMediaVideoBasicStopSwitch_EventArgs event) {
        MLog.info((Object)TAG, (String)("onVideoAudioModeSwitch called with: event = [" + event + "]"), (Object[])new Object[0]);
        if (event.isVideoEnable) {
            this.onSwitchToVideoMode();
        } else {
            this.onSwitchToAudioMode();
        }
    }

    private void onSwitchToVideoMode() {
        MLog.info((Object)TAG, (String)"onSwitchToVideoMode called", (Object[])new Object[0]);
        this.hideRootView();
    }

    private void onSwitchToAudioMode() {
        MLog.info((Object)TAG, (String)"onSwitchToAudioMode called", (Object[])new Object[0]);
        this.loadMicCardImage();
        this.showRootView();
    }

    @BusEvent(sync=true)
    public void onConnectivityChange(IConnectivityClient_onConnectivityChange_EventArgs busEventArgs) {
        IConnectivityCore.ConnectivityState previousState = busEventArgs.getPreviousState();
        IConnectivityCore.ConnectivityState currentState = busEventArgs.getCurrentState();
        MLog.info((Object)TAG, (String)("onConnectivityChange previousState = " + previousState + ", currentState = " + currentState), (Object[])new Object[0]);
        if (previousState != IConnectivityCore.ConnectivityState.NetworkUnavailable && currentState == IConnectivityCore.ConnectivityState.NetworkUnavailable) {
            this.onNetworkNotAvailable();
        } else if (previousState == IConnectivityCore.ConnectivityState.NetworkUnavailable && currentState != IConnectivityCore.ConnectivityState.NetworkUnavailable) {
            this.onNetworkAvailable();
        }
    }

    private void onNetworkNotAvailable() {
        MLog.info((Object)TAG, (String)"onNetworkNotAvailable called", (Object[])new Object[0]);
        this.mTvNetwork.setVisibility(0);
        this.showRootView();
    }

    private void onNetworkAvailable() {
        MLog.info((Object)TAG, (String)"onNetworkAvailable called", (Object[])new Object[0]);
        this.mTvNetwork.setVisibility(8);
        this.hideRootView();
    }

    @BusEvent
    public void onLeaveChannelClear(IMediaVideoBasicClient_onLeaveClear_EventArgs eventArgs) {
        MLog.info((Object)TAG, (String)("onLeaveChannelClear called with: eventArgs = [" + eventArgs + "]"), (Object[])new Object[0]);
        this.hideRootView();
    }

    @BusEvent
    public void onNoVideoStreamNotify(NoVideoStreamEvent event) {
        MLog.info((Object)TAG, (String)"onNoVideoStreamNotify:", (Object[])new Object[0]);
        this.tryToShowMicCard(5000L);
    }

    private void tryToShowMicCard(long delayInMillis) {
        if (((ILiveConfigCore)ICoreManagerBase.getCore(ILiveConfigCore.class)).getLiveType() == LiveConfigType.LianMai) {
            MLog.info((Object)TAG, (String)"me as link user, ignore show mic card", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"tryToShowMicCard called with delay: %d", (Object[])new Object[]{delayInMillis});
        RxUtils.dispose((Disposable)this.mNoLiveShowMicDisposable);
        this.mNoLiveShowMicDisposable = Observable.timer((long)delayInMillis, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                MLog.debug((Object)MicCardController.TAG, (String)"tryToShowMicCard delay accept", (Object[])new Object[0]);
                RxUtils.dispose((Disposable)MicCardController.this.mNoLiveShowMicDisposable);
                MicCardController.this.setNoVideoStreamInfo();
            }
        }, RxUtils.errorConsumer((String)"tryToShowMicCard"));
    }

    private void setNoVideoStreamInfo() {
        if (this.hasMicCardUrl()) {
            MLog.info((Object)TAG, (String)"setNoVideoStreamInfo, show mic card", (Object[])new Object[0]);
            this.loadMicCardImage();
        } else {
            MLog.info((Object)TAG, (String)"setNoVideoStreamInfo, show no video image", (Object[])new Object[0]);
            this.loadNoVideoImage();
        }
        if (ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().channelMode == ChannelInfo.ChannelMode.Free_Mode) {
            return;
        }
        this.showRootView();
    }

    @BusEvent
    public void hasVideoStreamNotify(HasVideoStreamEvent event) {
        MLog.info((Object)TAG, (String)("hasVideoStreamNotify called with: event = [" + event + "]"), (Object[])new Object[0]);
        this.hideRootView();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void showContentRecommendComponent(IMediaVideoBasicClient_showContentRecommendComponent_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)("showContentRecommendComponent called with: busEventArgs = [" + busEventArgs + "]"), (Object[])new Object[0]);
        this.mIvMicCard.setVisibility(8);
    }

    public void onOrientationChange(boolean isOrientationVertical) {
        this.mIsOrientationVertical = isOrientationVertical;
        if (this.mIsMicCardShowing) {
            this.loadMicCardImage();
        }
    }

    public void onPlayStatusChanged(VideoPlayInfo videoPlayInfo, VideoPlayStatus videoPlayStatus) {
        if (videoPlayStatus == VideoPlayStatus.LOADING || videoPlayStatus == VideoPlayStatus.PLAYING) {
            if (this.mNoLiveShowMicDisposable != null && !this.mNoLiveShowMicDisposable.isDisposed()) {
                this.mNoLiveShowMicDisposable.dispose();
            }
            MLog.info((Object)TAG, (String)"onPlayStatusChanged called\uff0c VideoPlayStatus.LOADING", (Object[])new Object[0]);
            this.hideRootView();
        }
    }

    @BusEvent
    public void onMicCardChange(IMediaVideoBasicClient_onSetMicCardUrl_EventArgs eventArgs) {
        MLog.info((Object)TAG, (String)("onMicCardChange called with: eventArgs = [" + eventArgs + "]"), (Object[])new Object[0]);
        this.showMicCardIfNoVideo();
    }

    private void showMicCardIfNoVideo() {
        boolean isCurrentNoLive = NoLiveManager.getInstance().isCurrentNoLive();
        if (isCurrentNoLive) {
            MLog.info((Object)TAG, (String)"current is no live, show mic card", (Object[])new Object[0]);
            this.tryToShowMicCard(0L);
        }
    }

    private void loadNoVideoImage() {
        MLog.info((Object)TAG, (String)"loadNoVideoImage called", (Object[])new Object[0]);
        this.mIvMicCard.setImageResource(R.drawable.basic_mediavideo_iv_mic_card);
        this.mIvMicCard.setVisibility(0);
    }

    private void loadMicCardImage() {
        this.mIvMicCard.setVisibility(0);
        String micCardUrl = this.getMicCardUrl();
        ImageView.ScaleType scaleType = this.mediaVideoBasicCore.getMicCardScaleType();
        MLog.info((Object)TAG, (String)"loadMicCardImage called, url: %s, scaleType: %s", (Object[])new Object[]{micCardUrl, scaleType});
        if (scaleType != null) {
            this.mIvMicCard.setScaleType(scaleType);
        }
        if (this.hasMicCardUrl()) {
            this.mIvMicCard.setLayoutParams((ViewGroup.LayoutParams)this.getHasMicCardUrlLayoutParams());
            ImageLoader.loadImage((RecycleImageView)this.mIvMicCard, (String)micCardUrl);
        } else if (NoLiveManager.getInstance().isCurrentNoLive()) {
            this.loadNoVideoImage();
        } else {
            this.mIvMicCard.setLayoutParams((ViewGroup.LayoutParams)this.getNoMicCardUrlLayoutParams());
            this.mIvMicCard.setImageResource(R.drawable.basic_mediavideo_novideo_iv_mic_card);
        }
    }

    public void showRootView() {
        MLog.info((Object)TAG, (String)"showRootView called", (Object[])new Object[0]);
        this.mIsMicCardShowing = true;
        this.mMicCardRootView.setVisibility(0);
        this.mMicCardRootView.setBackgroundResource(R.drawable.mediavideo_basic_bg_horizontal);
    }

    public void hideRootView() {
        MLog.info((Object)TAG, (String)"hideRootView called", (Object[])new Object[0]);
        this.mIsMicCardShowing = false;
        if (this.mMicCardRootView != null) {
            this.mMicCardRootView.setVisibility(8);
        }
    }

    private RelativeLayout.LayoutParams getHasMicCardUrlLayoutParams() {
        int height;
        int width;
        if (this.mIsOrientationVertical) {
            width = ResolutionUtils.getScreenWidth((Context)this.mContext);
            height = (int)((float)width * 0.75f);
        } else {
            width = (int)((float)ResolutionUtils.getScreenWidth((Context)this.mContext) - ResolutionUtils.convertDpToPixel((float)160.0f, (Context)this.mContext));
            height = ResolutionUtils.getScreenHeight((Context)this.mContext);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, height);
        params.topMargin = this.mIsOrientationVertical ? (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)this.mContext) : 0;
        params.addRule(14, -1);
        return params;
    }

    private RelativeLayout.LayoutParams getNoMicCardUrlLayoutParams() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        return params;
    }

    private boolean hasMicCardUrl() {
        return !FP.empty((CharSequence)this.getMicCardUrl());
    }

    private String getMicCardUrl() {
        return this.mIsOrientationVertical ? this.mediaVideoBasicCore.getMcCardUrlPortrait() : this.mediaVideoBasicCore.getMcCardUrlLandscape();
    }
}

