/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.magichat;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IQueueClient_onExecute_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IChannelTurntableClient_onQueryTurnTableGrabChest_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.magichat.MagicHatController$$EventBinder;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.ui.turntable.core.IChannelTurntableCore;
import com.yy.mobile.ui.turntable.info.TurnTableLottoryInfo;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.userinterfaceQueue.QueueMessage;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import java.util.List;
import java.util.Map;

public class MagicHatController
implements EventCompat {
    private static final String TAG = "MagicHatController";
    private Context mContext;
    private View layout;
    private RelativeLayout mRlMagic;
    private LinearLayout mLlSendInfo;
    private LinearLayout mLlMagicTextContainer;
    private ImageView mIvMagician;
    private ImageView mIvRotatinglight;
    private ImageView mIvMagichat;
    private String baoXiangId;
    private String giftId;
    private String comboCnt;
    private String numPerCombo;
    private String mNobleLevel;
    private TextView mTvTip;
    private TextView mMagicUserName;
    private ImageView mNobleIcon;
    private RelativeLayout mParent;
    private RecycleImageView mIvGift;
    private View.OnClickListener magicHatOnclickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (LoginUtil.isLogined()) {
                MagicHatController.this.layout.setClickable(false);
                ((IChannelTurntableCore)ICoreManagerBase.getCore(IChannelTurntableCore.class)).queryTurnTableGrabChest(MagicHatController.this.baoXiangId, MagicHatController.this.giftId);
            } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)MagicHatController.this.mContext);
            }
        }
    };
    private EventBinder mMagicHatControllerSniperEventBinder;

    public void onEventBind() {
        if (this.mMagicHatControllerSniperEventBinder == null) {
            this.mMagicHatControllerSniperEventBinder = new MagicHatController$$EventBinder();
        }
        this.mMagicHatControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mMagicHatControllerSniperEventBinder != null) {
            this.mMagicHatControllerSniperEventBinder.unBindEvent();
        }
    }

    public MagicHatController(Context ctx, ViewGroup parentView) {
        ICoreManagerBase.addClient((Object)this);
        this.mContext = ctx;
        this.mParent = new RelativeLayout(this.mContext);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.mParent.setVisibility(8);
        parentView.addView((View)this.mParent, (ViewGroup.LayoutParams)lp);
    }

    private void initViews() {
        this.layout = LayoutInflater.from((Context)this.mContext).inflate(R.layout.magic_hat_layout, null);
        this.mRlMagic = (RelativeLayout)this.layout.findViewById(R.id.rl_magic);
        this.mIvMagician = (ImageView)this.layout.findViewById(R.id.iv_magician);
        this.mIvRotatinglight = (ImageView)this.layout.findViewById(R.id.iv_rotatinglight);
        this.mIvMagichat = (ImageView)this.layout.findViewById(R.id.iv_magichat);
        this.mTvTip = (TextView)this.layout.findViewById(R.id.tv_tip);
        this.mLlSendInfo = (LinearLayout)this.layout.findViewById(R.id.ll_send_info);
        this.mMagicUserName = (TextView)this.layout.findViewById(R.id.magic_user_name);
        this.mNobleIcon = (ImageView)this.layout.findViewById(R.id.noble_icon);
        this.mIvGift = (RecycleImageView)this.layout.findViewById(R.id.iv_gift);
        this.layout.setOnClickListener(this.magicHatOnclickListener);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12);
        this.mParent.setVisibility(0);
        this.mParent.addView(this.layout, (ViewGroup.LayoutParams)lp);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onExecute(IQueueClient_onExecute_EventArgs busEventArgs) {
        QueueMessage message = busEventArgs.mMessage;
        if (message != null) {
            this.onExecute(message.object);
        }
    }

    public void onExecute(Object queueMsg) {
        this.onReceiveQueueBroadCast(queueMsg);
    }

    protected void onReceiveQueueBroadCast(Object queueMsg) {
        if (queueMsg != null && queueMsg instanceof TurnTableLottoryInfo) {
            TurnTableLottoryInfo info = (TurnTableLottoryInfo)queueMsg;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("----- run magic hat info= " + info), (Object[])new Object[0]);
            }
            if (info.giftId.equals("402")) {
                this.mParent.setVisibility(0);
                if (this.layout == null) {
                    this.initViews();
                }
                this.show(info);
            }
        }
    }

    @BusEvent(sync=true)
    public void onQueryTurnTableGrabChest(IChannelTurntableClient_onQueryTurnTableGrabChest_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        List otherList = busEventArgs.getOtherList();
        if (this.layout == null) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("------[onQueryTurnTableGrabChest],result==" + result + ",redDiamond==" + (String)extendInfo.get("RED_DIAMOND")), (Object[])new Object[0]);
        }
        if (result == 0L) {
            if (LoginUtil.isLogined()) {
                ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).queryFreeGift();
            }
            String redDiamond = (String)extendInfo.get("RED_DIAMOND");
            SpannableString ss = new SpannableString((CharSequence)(this.numPerCombo + "x" + this.comboCnt + "\u7ec4\uff0c\u60a8\u62a2\u5f97" + redDiamond + "\u9b54\u672f\u5e3d"));
            int start = (this.numPerCombo + "x" + this.comboCnt + "\u7ec4\uff0c\u60a8\u62a2\u5f97").length();
            int end = start + redDiamond.length();
            ss.setSpan((Object)new ForegroundColorSpan(this.mContext.getResources().getColor(R.color.hot_ball_user_name)), start, end, 33);
            ss.setSpan((Object)new StyleSpan(1), start, end, 33);
            this.mTvTip.setText((CharSequence)ss);
            this.animClickInfoTv();
        } else {
            SpannableString sp = new SpannableString((CharSequence)(this.numPerCombo + "x" + this.comboCnt + "\u7ec4\uff0c\u60a8\u4e0b\u624b\u6162\u4e86"));
            int start = (this.numPerCombo + "x" + this.comboCnt + "\u7ec4\uff0c\u60a8").length();
            int end = start + "\u4e0b\u624b\u6162\u4e86".length();
            sp.setSpan((Object)new ForegroundColorSpan(this.mContext.getResources().getColor(R.color.hot_ball_fail_info)), start, end, 33);
            sp.setSpan((Object)new StyleSpan(1), start, end, 33);
            this.mTvTip.setText((CharSequence)sp);
            this.animClickInfoTv();
        }
    }

    private void show(TurnTableLottoryInfo info) {
        if (this.layout == null) {
            return;
        }
        this.baoXiangId = info.treasureId;
        this.giftId = info.giftId;
        this.comboCnt = info.comboCnt;
        this.numPerCombo = info.numPerCombo;
        this.mNobleLevel = info.noble;
        this.layout.setVisibility(0);
        this.layout.setClickable(false);
        this.layout.setAlpha(1.0f);
        if (this.mNobleLevel != null && !"".equals(this.mNobleLevel) && EntIdentityIconSet.getIconResId((int)Integer.valueOf(this.mNobleLevel)) > 0) {
            this.mNobleIcon.setImageResource(EntIdentityIconSet.getIconResId((int)Integer.valueOf(this.mNobleLevel)));
            this.mNobleIcon.setVisibility(0);
        }
        String path = GiftConfigParser.getInstance().getGiftIconPath(StringUtils.safeParseInt((String)this.giftId));
        ImageLoader.loadImage((RecycleImageView)this.mIvGift, (String)path);
        this.mMagicUserName.setText((CharSequence)info.fromName);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mMagicUserName.setTextDirection(3);
        }
        this.mTvTip.setText((CharSequence)(this.numPerCombo + "x" + this.comboCnt + "\u7ec4"));
        this.animSendInfoTv();
        this.animMagician();
        this.animRotatingLight();
    }

    private void animSendInfoTv() {
        TranslateAnimation translate = null;
        if (null != translate) {
            translate.cancel();
        }
        translate = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        translate.setDuration(1000L);
        translate.setFillAfter(true);
        this.mLlSendInfo.startAnimation((Animation)translate);
    }

    private void animClickInfoTv() {
        ScaleAnimation scale = null;
        if (null != scale) {
            scale.cancel();
        }
        scale = new ScaleAnimation(0.98f, 1.0f, 0.98f, 1.0f, 1, 0.5f, 1, 0.5f);
        scale.setRepeatMode(2);
        scale.setRepeatCount(10);
        scale.setDuration(100L);
        this.mLlSendInfo.startAnimation((Animation)scale);
    }

    private void animMagician() {
        AlphaAnimation mShowAnimation = null;
        if (null != mShowAnimation) {
            mShowAnimation.cancel();
        }
        mShowAnimation = new AlphaAnimation(0.0f, 1.0f);
        mShowAnimation.setDuration(240L);
        mShowAnimation.setFillAfter(true);
        this.mIvMagician.startAnimation((Animation)mShowAnimation);
        this.mIvMagichat.startAnimation((Animation)mShowAnimation);
    }

    private void animRotatingLight() {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.mIvRotatinglight, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alpha.setDuration(240L);
        ObjectAnimator rotate = ObjectAnimator.ofFloat((Object)this.mIvRotatinglight, (String)"rotation", (float[])new float[]{0.0f, 900.0f});
        rotate.setDuration(7520L);
        ObjectAnimator alphaRootView = ObjectAnimator.ofFloat((Object)this.layout, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        alphaRootView.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                MagicHatController.this.layout.setVisibility(4);
                MagicHatController.this.mNobleIcon.setVisibility(8);
                MagicHatController.this.mParent.setVisibility(8);
            }
        });
        alphaRootView.setDuration(240L);
        set.play((Animator)alpha);
        set.play((Animator)rotate).after((Animator)alpha);
        set.play((Animator)alphaRootView).after((Animator)rotate);
        set.start();
    }

    public void onOrientationChange(boolean isLandscape) {
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)this);
    }
}

