/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.guess.result;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.guess.result.GuessResult;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class GuessResultAdapter
extends RecyclerView.Adapter<VH> {
    private int mUnitIconResId;
    private List<GuessResult> mData = new ArrayList<GuessResult>();
    private DecimalFormat mNumberFormatter = new DecimalFormat("#,###,###");

    public GuessResultAdapter(int resId) {
        if (resId > 0) {
            this.mUnitIconResId = resId;
        }
        this.mUnitIconResId = resId > 0 ? resId : R.drawable.ic_game_quiz_diamond;
    }

    public void setData(List<GuessResult> data) {
        this.mData.clear();
        this.mData.addAll(data);
        this.notifyDataSetChanged();
    }

    public GuessResult getItem(int index) {
        return this.mData.get(index);
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.item_game_quiz_result, parent, false);
        return new VH(itemView);
    }

    public void onBindViewHolder(VH holder, int position) {
        GuessResult result = this.getItem(position);
        holder.mTvQuestion.setText((CharSequence)(position + 1 + "." + result.question));
        holder.mTvAnswer.setText((CharSequence)result.winAnswer);
        String diamondCountSign = result.diamondCount > 0L ? "+" : "";
        holder.mTvDiamond.setText((CharSequence)(diamondCountSign + this.mNumberFormatter.format(result.diamondCount)));
        holder.mItemDivider.setVisibility(this.mData.size() == 1 ? 4 : 0);
        holder.mUnitIcon.setImageResource(this.mUnitIconResId);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    static class VH
    extends RecyclerView.ViewHolder {
        TextView mTvQuestion;
        TextView mTvAnswer;
        TextView mTvDiamond;
        View mItemDivider;
        ImageView mUnitIcon;

        VH(View itemView) {
            super(itemView);
            this.mTvQuestion = (TextView)itemView.findViewById(R.id.tv_question);
            this.mTvAnswer = (TextView)itemView.findViewById(R.id.tv_answer);
            this.mTvDiamond = (TextView)itemView.findViewById(R.id.tv_diamond);
            this.mItemDivider = itemView.findViewById(R.id.item_divider);
            this.mUnitIcon = (ImageView)itemView.findViewById(R.id.iv_uniticon);
        }
    }
}

